"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiAvatar", {
  enumerable: true,
  get: function get() {
    return _avatar.EuiAvatar;
  }
});
Object.defineProperty(exports, "checkValidColor", {
  enumerable: true,
  get: function get() {
    return _avatar.checkValidColor;
  }
});

var _avatar = require("./avatar");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiAvatar.__docgenInfo = {
    description: '',
    displayName: 'EuiAvatar',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      name: {
        defaultValue: null,
        description: 'Full name of avatar for title attribute and calculating initial if not provided',
        name: 'name',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      color: {
        defaultValue: null,
        description: 'Accepts hex value `#FFFFFF`, `#000` otherwise a viz palette color will be assigned',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      initials: {
        defaultValue: null,
        description: 'Custom initials (max 2 characters).\nBy default will take the first character (of each word).',
        name: 'initials',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      initialsLength: {
        defaultValue: null,
        description: 'Specify how many characters to show (max 2 allowed).\nBy default, will show based on number of words.',
        name: 'initialsLength',
        parent: undefined,
        required: false,
        type: {
          name: '1 | 2'
        }
      },
      type: {
        defaultValue: null,
        description: 'The type of avatar this is displaying',
        name: 'type',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"user" | "space"',
          value: [{
            value: '"user"'
          }, {
            value: '"space"'
          }]
        }
      },
      imageUrl: {
        defaultValue: null,
        description: '',
        name: 'imageUrl',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  checkValidColor.__docgenInfo = {
    description: '',
    displayName: 'checkValidColor',
    methods: [],
    props: {},
    extends: ['DOMAttributes']
  };
} catch (e) {}