"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiBetaBadge", {
  enumerable: true,
  get: function get() {
    return _beta_badge.EuiBetaBadge;
  }
});

var _beta_badge = require("./beta_badge");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiBetaBadge.__docgenInfo = {
    description: '',
    displayName: 'EuiBetaBadge',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Supply an icon type if the badge should just be an icon',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      label: {
        defaultValue: null,
        description: 'One word label like "Beta" or "Lab"\nOne word label like "Beta" or "Lab"',
        name: 'label',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      tooltipContent: {
        defaultValue: null,
        description: 'Content for the tooltip',
        name: 'tooltipContent',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      tooltipPosition: {
        defaultValue: null,
        description: 'Custom position of the tooltip',
        name: 'tooltipPosition',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute\notherwise the label will be used',
        name: 'title',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}