"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiBottomBar", {
  enumerable: true,
  get: function get() {
    return _bottom_bar.EuiBottomBar;
  }
});

var _bottom_bar = require("./bottom_bar");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiBottomBar.__docgenInfo = {
    description: '',
    displayName: 'EuiBottomBar',
    methods: [],
    props: {
      bodyClassName: {
        defaultValue: null,
        description: 'Optional class applied to the body class',
        name: 'bodyClassName',
        parent: {
          fileName: 'eui/src/components/bottom_bar/bottom_bar.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'Padding applied to the bar',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/bottom_bar/bottom_bar.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      landmarkHeading: {
        defaultValue: null,
        description: 'Customize the screen reader heading that helps users find this control. Default is "Page level controls".',
        name: 'landmarkHeading',
        parent: {
          fileName: 'eui/src/components/bottom_bar/bottom_bar.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}