"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "COLORS", {
  enumerable: true,
  get: function get() {
    return _button.COLORS;
  }
});
Object.defineProperty(exports, "EuiButton", {
  enumerable: true,
  get: function get() {
    return _button.EuiButton;
  }
});
Object.defineProperty(exports, "EuiButtonEmpty", {
  enumerable: true,
  get: function get() {
    return _button_empty.EuiButtonEmpty;
  }
});
Object.defineProperty(exports, "EuiButtonIcon", {
  enumerable: true,
  get: function get() {
    return _button_icon.EuiButtonIcon;
  }
});
Object.defineProperty(exports, "EuiButtonToggle", {
  enumerable: true,
  get: function get() {
    return _button_toggle.EuiButtonToggle;
  }
});
Object.defineProperty(exports, "EuiButtonGroup", {
  enumerable: true,
  get: function get() {
    return _button_group.EuiButtonGroup;
  }
});

var _button = require("./button");

var _button_empty = require("./button_empty");

var _button_icon = require("./button_icon");

var _button_toggle = require("./button_toggle");

var _button_group = require("./button_group");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiButton.__docgenInfo = {
    description: '',
    displayName: 'EuiButton',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      fill: {
        defaultValue: null,
        description: 'Make button a solid color for prominence',
        name: 'fill',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      color: {
        defaultValue: null,
        description: 'Any of our named colors. `text` color is set for deprecation',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Use size `s` in confined spaces',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'Extends the button to 100% width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: undefined,
        required: false,
        type: {
          name: '((instance: HTMLButtonElement) => void) | RefObject<HTMLButtonElement> | ((instance: HTMLAnchorElement) => void) | RefObject<...>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiButtonEmpty.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonEmpty',
    methods: [],
    props: {
      color: {
        defaultValue: null,
        description: 'Any of our named colors',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiButtonEmptyColor',
          value: [{
            value: '"disabled"'
          }, {
            value: '"primary"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      flush: {
        defaultValue: null,
        description: 'Ensure the text of the button sits flush to the left or right side of its container',
        name: 'flush',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"submit" | "button"',
          value: [{
            value: '"submit"'
          }, {
            value: '"button"'
          }]
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: '(ref: HTMLAnchorElement | HTMLButtonElement) => void'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiButtonIcon.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonIcon',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiButtonIconColor',
          value: [{
            value: '"disabled"'
          }, {
            value: '"primary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"success"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-labelledby': {
        defaultValue: null,
        description: 'Identifies the element (or elements) that labels the current element.\n@see aria-describedby.',
        name: 'aria-labelledby',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      iconSize: {
        defaultValue: null,
        description: '',
        name: 'iconSize',
        parent: {
          fileName: 'eui/src/components/button/button_icon/button_icon.tsx',
          name: 'EuiButtonIconProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl" | "original" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"original"'
          }, {
            value: '"xxl"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: undefined,
        required: false,
        type: {
          name: '((instance: HTMLButtonElement) => void) | RefObject<HTMLButtonElement> | ((instance: HTMLAnchorElement) => void) | RefObject<...>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiButtonToggle.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonToggle',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isEmpty: {
        defaultValue: null,
        description: 'Simulates a `EuiButtonEmpty`',
        name: 'isEmpty',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isIconOnly: {
        defaultValue: null,
        description: 'Hides the label from the button content and only displays the icon',
        name: 'isIconOnly',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Initial state of the toggle',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      label: {
        defaultValue: null,
        description: 'Button label, which is also passed to `EuiToggle` as the input\'s label',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      toggleClassName: {
        defaultValue: null,
        description: 'Classnames to add to `EuiToggle` instead of the `EuiButton`',
        name: 'toggleClassName',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: 'Is the button a single action or part of a group (multi)?\nUsed primarily for `EuiButtonGroup`',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"single" | "multi"',
          value: [{
            value: '"single"'
          }, {
            value: '"multi"'
          }]
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: '(((event: ChangeEvent<HTMLInputElement>) => void) & ((event: FormEvent<HTMLButtonElement>) => void)) | (((event: ChangeEvent<HTMLInputElement>) => void) & ((event: FormEvent<...>) => void))'
        }
      },
      fill: {
        defaultValue: null,
        description: 'Make button a solid color for prominence',
        name: 'fill',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      color: {
        defaultValue: null,
        description: 'Any of our named colors. `text` color is set for deprecation',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Use size `s` in confined spaces',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'Extends the button to 100% width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiButtonGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'EuiButtonGroupOption[]'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: true,
        type: {
          name: '(id: string, value?: any) => void'
        }
      },
      buttonSize: {
        defaultValue: null,
        description: 'Typical sizing is `s`. Medium `m` size should be reserved for major features.\n`compressed` is meant to be used alongside and within compressed forms.',
        name: 'buttonSize',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'GroupButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"compressed"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isFullWidth: {
        defaultValue: null,
        description: '',
        name: 'isFullWidth',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isIconOnly: {
        defaultValue: null,
        description: '',
        name: 'isIconOnly',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      idSelected: {
        defaultValue: null,
        description: '',
        name: 'idSelected',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      legend: {
        defaultValue: null,
        description: '',
        name: 'legend',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"single" | "multi"',
          value: [{
            value: '"single"'
          }, {
            value: '"multi"'
          }]
        }
      },
      idToSelectedMap: {
        defaultValue: null,
        description: '',
        name: 'idToSelectedMap',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'EuiButtonGroupIdToSelectedMap'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}