"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlock = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _code_block = require("./_code_block");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiCodeBlock = function EuiCodeBlock(_ref) {
  var inline = _ref.inline,
      rest = _objectWithoutProperties(_ref, ["inline"]);

  return _react.default.createElement(_code_block.EuiCodeBlockImpl, _extends({
    inline: false
  }, rest));
};

exports.EuiCodeBlock = EuiCodeBlock;
EuiCodeBlock.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  inline: _propTypes.default.oneOf([false]),
  paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),
  fontSize: _propTypes.default.oneOf(["s", "m", "l"]),
  overflowHeight: _propTypes.default.number,
  isCopyable: _propTypes.default.bool,

  /**
     * Sets the syntax highlighting for a specific language
     * @see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases
     * for options
     */
  language: _propTypes.default.string,
  transparentBackground: _propTypes.default.bool
};

try {
  EuiCodeBlock.__docgenInfo = {
    description: '',
    displayName: 'EuiCodeBlock',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      inline: {
        defaultValue: null,
        description: '',
        name: 'inline',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'false'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: '',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      fontSize: {
        defaultValue: null,
        description: '',
        name: 'fontSize',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }]
        }
      },
      overflowHeight: {
        defaultValue: null,
        description: '',
        name: 'overflowHeight',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      isCopyable: {
        defaultValue: null,
        description: '',
        name: 'isCopyable',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      language: {
        defaultValue: null,
        description: 'Sets the syntax highlighting for a specific language\n@see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases\nfor options',
        name: 'language',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'EuiCodeSharedProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      transparentBackground: {
        defaultValue: null,
        description: '',
        name: 'transparentBackground',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'EuiCodeSharedProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}