"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiComboBoxOptionsList", {
  enumerable: true,
  get: function get() {
    return _combo_box_options_list.EuiComboBoxOptionsList;
  }
});
Object.defineProperty(exports, "EuiComboBoxOption", {
  enumerable: true,
  get: function get() {
    return _combo_box_option.EuiComboBoxOption;
  }
});
Object.defineProperty(exports, "EuiComboBoxTitle", {
  enumerable: true,
  get: function get() {
    return _combo_box_title.EuiComboBoxTitle;
  }
});

var _combo_box_options_list = require("./combo_box_options_list");

var _combo_box_option = require("./combo_box_option");

var _combo_box_title = require("./combo_box_title");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiComboBoxOptionsList.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxOptionsList',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasShadow: {
        defaultValue: null,
        description: 'If active, adds a deeper shadow to the panel',
        name: 'hasShadow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'Padding applied to the panel',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: 'When true the panel will grow to match `EuiFlexItem`',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      panelRef: {
        defaultValue: null,
        description: '',
        name: 'panelRef',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'Ref<HTMLDivElement>'
        }
      },
      betaBadgeLabel: {
        defaultValue: null,
        description: 'Add a badge to the panel to label it as "Beta" or other non-GA state',
        name: 'betaBadgeLabel',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      betaBadgeTooltipContent: {
        defaultValue: null,
        description: 'Add a description to the beta badge (will appear in a tooltip)',
        name: 'betaBadgeTooltipContent',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      betaBadgeTitle: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute otherwise the label will be used',
        name: 'betaBadgeTitle',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      activeOptionIndex: {
        defaultValue: null,
        description: '',
        name: 'activeOptionIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      areAllOptionsSelected: {
        defaultValue: null,
        description: '',
        name: 'areAllOptionsSelected',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      customOptionText: {
        defaultValue: null,
        description: 'Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.\nIt won\'t show if there\'s no onCreateOption.',
        name: 'customOptionText',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      getSelectedOptionForSearchValue: {
        defaultValue: null,
        description: '',
        name: 'getSelectedOptionForSearchValue',
        parent: undefined,
        required: false,
        type: {
          name: '(searchValue: string, selectedOptions: any[]) => EuiComboBoxOptionOption<T>'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listRef: {
        defaultValue: null,
        description: '',
        name: 'listRef',
        parent: undefined,
        required: true,
        type: {
          name: '(instance: HTMLDivElement) => void'
        }
      },
      matchingOptions: {
        defaultValue: null,
        description: '',
        name: 'matchingOptions',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      onCloseList: {
        defaultValue: null,
        description: '',
        name: 'onCloseList',
        parent: undefined,
        required: true,
        type: {
          name: '(event: Event) => void'
        }
      },
      onCreateOption: {
        defaultValue: null,
        description: '',
        name: 'onCreateOption',
        parent: undefined,
        required: false,
        type: {
          name: '(searchValue: string, options: EuiComboBoxOptionOption<T>[]) => boolean | void'
        }
      },
      onOptionClick: {
        defaultValue: null,
        description: '',
        name: 'onOptionClick',
        parent: undefined,
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      onOptionEnterKey: {
        defaultValue: null,
        description: '',
        name: 'onOptionEnterKey',
        parent: undefined,
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      optionRef: {
        defaultValue: null,
        description: '',
        name: 'optionRef',
        parent: undefined,
        required: true,
        type: {
          name: '(index: number, node: EuiFilterSelectItem) => void'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiComboBoxOptionsListPosition',
          value: [{
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      renderOption: {
        defaultValue: null,
        description: '',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: EuiComboBoxOptionOption<T>, searchValue: string, OPTION_CONTENT_CLASSNAME: string) => ReactNode'
        }
      },
      rootId: {
        defaultValue: null,
        description: '',
        name: 'rootId',
        parent: undefined,
        required: true,
        type: {
          name: '(idSuffix?: string) => string'
        }
      },
      rowHeight: {
        defaultValue: null,
        description: '',
        name: 'rowHeight',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      scrollToIndex: {
        defaultValue: null,
        description: '',
        name: 'scrollToIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      searchValue: {
        defaultValue: null,
        description: '',
        name: 'searchValue',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      selectedOptions: {
        defaultValue: null,
        description: '',
        name: 'selectedOptions',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      updatePosition: {
        defaultValue: null,
        description: '',
        name: 'updatePosition',
        parent: undefined,
        required: true,
        type: {
          name: 'UpdatePositionHandler'
        }
      },
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: '',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | EuiComboBoxSingleSelectionShape'
        }
      },
      delimiter: {
        defaultValue: null,
        description: '',
        name: 'delimiter',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      zIndex: {
        defaultValue: null,
        description: '',
        name: 'zIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxOption.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxOption',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isFocused: {
        defaultValue: null,
        description: '',
        name: 'isFocused',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      onEnterKey: {
        defaultValue: null,
        description: '',
        name: 'onEnterKey',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      option: {
        defaultValue: null,
        description: '',
        name: 'option',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>'
        }
      },
      optionRef: {
        defaultValue: null,
        description: '',
        name: 'optionRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLButtonElement) => void'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxTitle.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxTitle',
    methods: [],
    props: {},
    extends: ['DOMAttributes']
  };
} catch (e) {}