"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiComment", {
  enumerable: true,
  get: function get() {
    return _comment.EuiComment;
  }
});
Object.defineProperty(exports, "EuiCommentEvent", {
  enumerable: true,
  get: function get() {
    return _comment_event.EuiCommentEvent;
  }
});
Object.defineProperty(exports, "EuiCommentTimeline", {
  enumerable: true,
  get: function get() {
    return _comment_timeline.EuiCommentTimeline;
  }
});
Object.defineProperty(exports, "EuiCommentList", {
  enumerable: true,
  get: function get() {
    return _comment_list.EuiCommentList;
  }
});

var _comment = require("./comment");

var _comment_event = require("./comment_event");

var _comment_timeline = require("./comment_timeline");

var _comment_list = require("./comment_list");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiComment.__docgenInfo = {
    description: '',
    displayName: 'EuiComment',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      username: {
        defaultValue: null,
        description: 'Author of the comment. Display a small icon or avatar with it if needed.',
        name: 'username',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      timestamp: {
        defaultValue: null,
        description: 'Time of occurrence of the event. Its format is set on the consumer\'s side',
        name: 'timestamp',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      event: {
        defaultValue: null,
        description: 'Describes the event that took place',
        name: 'event',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      actions: {
        defaultValue: null,
        description: 'Custom actions that the user can perform from the comment\'s header',
        name: 'actions',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      type: {
        defaultValue: null,
        description: 'Use "update" when the comment is primarily showing info about actions that the user or the system has performed (e.g. "user1 edited a case").',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"regular" | "update"',
          value: [{
            value: '"regular"'
          }, {
            value: '"update"'
          }]
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      timelineIcon: {
        defaultValue: null,
        description: 'Main icon that accompanies the comment. The default is `user` for regular comments and `dot` for update comments. To customize, pass a `string` as an `EuiIcon[\'type\']` or any `ReactNode`.',
        name: 'timelineIcon',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_timeline.tsx',
          name: 'EuiCommentTimelineProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactNodeArray | ReactPortal | ComponentClass<...> | FunctionComponent<...>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCommentEvent.__docgenInfo = {
    description: '',
    displayName: 'EuiCommentEvent',
    methods: [],
    props: {
      username: {
        defaultValue: null,
        description: 'Author of the comment. Display a small icon or avatar with it if needed.',
        name: 'username',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      timestamp: {
        defaultValue: null,
        description: 'Time of occurrence of the event. Its format is set on the consumer\'s side',
        name: 'timestamp',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      event: {
        defaultValue: null,
        description: 'Describes the event that took place',
        name: 'event',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      actions: {
        defaultValue: null,
        description: 'Custom actions that the user can perform from the comment\'s header',
        name: 'actions',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      type: {
        defaultValue: null,
        description: 'Use "update" when the comment is primarily showing info about actions that the user or the system has performed (e.g. "user1 edited a case").',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"regular" | "update"',
          value: [{
            value: '"regular"'
          }, {
            value: '"update"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCommentTimeline.__docgenInfo = {
    description: '',
    displayName: 'EuiCommentTimeline',
    methods: [],
    props: {
      timelineIcon: {
        defaultValue: null,
        description: 'Main icon that accompanies the comment. The default is `user` for regular comments and `dot` for update comments. To customize, pass a `string` as an `EuiIcon[\'type\']` or any `ReactNode`.',
        name: 'timelineIcon',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_timeline.tsx',
          name: 'EuiCommentTimelineProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactNodeArray | ReactPortal | ComponentClass<...> | FunctionComponent<...>'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_timeline.tsx',
          name: 'EuiCommentTimelineProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"regular" | "update"',
          value: [{
            value: '"regular"'
          }, {
            value: '"update"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCommentList.__docgenInfo = {
    description: '',
    displayName: 'EuiCommentList',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      comments: {
        defaultValue: null,
        description: 'List of comments to render. See #EuiComment',
        name: 'comments',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiCommentProps[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}