"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridBody = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _code = require("../code");

var _data_grid_data_row = require("./data_grid_data_row");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var defaultComparator = function defaultComparator(a, b, direction) {
  if (a < b) return direction === 'asc' ? -1 : 1;
  if (a > b) return direction === 'asc' ? 1 : -1;
  return 0;
};

var providedPopoverContents = {
  json: function json(_ref) {
    var cellContentsElement = _ref.cellContentsElement;
    var formattedText = cellContentsElement.innerText; // attempt to pretty-print the json

    try {
      formattedText = JSON.stringify(JSON.parse(formattedText), null, 2);
    } catch (e) {} // eslint-disable-line no-empty


    return _react.default.createElement(_code.EuiCodeBlock, {
      isCopyable: true,
      transparentBackground: true,
      paddingSize: "none",
      language: "json"
    }, formattedText);
  }
};

var EuiDataGridBody = function EuiDataGridBody(props) {
  var columnWidths = props.columnWidths,
      defaultColumnWidth = props.defaultColumnWidth,
      _props$leadingControl = props.leadingControlColumns,
      leadingControlColumns = _props$leadingControl === void 0 ? [] : _props$leadingControl,
      _props$trailingContro = props.trailingControlColumns,
      trailingControlColumns = _props$trailingContro === void 0 ? [] : _props$trailingContro,
      columns = props.columns,
      schema = props.schema,
      schemaDetectors = props.schemaDetectors,
      popoverContents = props.popoverContents,
      focusedCell = props.focusedCell,
      onCellFocus = props.onCellFocus,
      rowCount = props.rowCount,
      renderCellValue = props.renderCellValue,
      inMemory = props.inMemory,
      inMemoryValues = props.inMemoryValues,
      interactiveCellId = props.interactiveCellId,
      pagination = props.pagination,
      sorting = props.sorting;
  var startRow = pagination ? pagination.pageIndex * pagination.pageSize : 0;
  var endRow = pagination ? (pagination.pageIndex + 1) * pagination.pageSize : rowCount;
  endRow = Math.min(endRow, rowCount);
  var visibleRowIndices = (0, _react.useMemo)(function () {
    var visibleRowIndices = [];

    for (var i = startRow; i < endRow; i++) {
      visibleRowIndices.push(i);
    }

    return visibleRowIndices;
  }, [startRow, endRow]);
  var rowMap = (0, _react.useMemo)(function () {
    var rowMap = {};

    if ((inMemory === null || inMemory === void 0 ? void 0 : inMemory.level) === 'sorting' && sorting != null && sorting.columns.length > 0) {
      var inMemoryRowIndices = Object.keys(inMemoryValues);
      var wrappedValues = [];

      for (var i = 0; i < inMemoryRowIndices.length; i++) {
        var inMemoryRow = inMemoryValues[inMemoryRowIndices[i]];
        wrappedValues.push({
          index: i,
          values: inMemoryRow
        });
      }

      wrappedValues.sort(function (a, b) {
        for (var _i = 0; _i < sorting.columns.length; _i++) {
          var column = sorting.columns[_i];
          var aValue = a.values[column.id];
          var bValue = b.values[column.id]; // get the comparator, based on schema

          var comparator = defaultComparator;

          if (schema.hasOwnProperty(column.id)) {
            var columnType = schema[column.id].columnType;

            for (var _i2 = 0; _i2 < schemaDetectors.length; _i2++) {
              var detector = schemaDetectors[_i2];

              if (detector.type === columnType && detector.hasOwnProperty('comparator')) {
                comparator = detector.comparator;
              }
            }
          }

          var result = comparator(aValue, bValue, column.direction); // only return if the columns are inequal, otherwise allow the next sort-by column to run

          if (result !== 0) return result;
        }

        return 0;
      });

      for (var _i3 = 0; _i3 < wrappedValues.length; _i3++) {
        rowMap[_i3] = wrappedValues[_i3].index;
      }
    }

    return rowMap;
  }, [sorting, inMemory, inMemoryValues, schema, schemaDetectors]);
  var mergedPopoverContents = (0, _react.useMemo)(function () {
    return _objectSpread({}, providedPopoverContents, {}, popoverContents);
  }, [popoverContents]);
  var rows = (0, _react.useMemo)(function () {
    return visibleRowIndices.map(function (rowIndex, i) {
      rowIndex = rowMap.hasOwnProperty(rowIndex) ? rowMap[rowIndex] : rowIndex;
      return _react.default.createElement(_data_grid_data_row.EuiDataGridDataRow, {
        key: rowIndex,
        leadingControlColumns: leadingControlColumns,
        trailingControlColumns: trailingControlColumns,
        columns: columns,
        schema: schema,
        popoverContents: mergedPopoverContents,
        columnWidths: columnWidths,
        defaultColumnWidth: defaultColumnWidth,
        focusedCellPositionInTheRow: focusedCell != null && i === focusedCell[1] ? focusedCell[0] : null,
        onCellFocus: onCellFocus,
        renderCellValue: renderCellValue,
        rowIndex: rowIndex,
        visibleRowIndex: i,
        interactiveCellId: interactiveCellId
      });
    });
  }, [visibleRowIndices, rowMap, leadingControlColumns, trailingControlColumns, columns, schema, mergedPopoverContents, columnWidths, defaultColumnWidth, focusedCell, onCellFocus, renderCellValue, interactiveCellId]);
  return _react.default.createElement(_react.Fragment, null, rows);
};

exports.EuiDataGridBody = EuiDataGridBody;
EuiDataGridBody.propTypes = {
  columnWidths: _propTypes.default.shape({}).isRequired,
  defaultColumnWidth: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
  leadingControlColumns: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Used as the React `key` when rendering content
       */
    id: _propTypes.default.string.isRequired,

    /**
       * Component to render in the column header
       */
    headerCellRender: _propTypes.default.elementType.isRequired,

    /**
       * Component to render for each row in the column
       */
    rowCellRender: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,

    /**
       * Width of the column, uses are unable to change this
       */
    width: _propTypes.default.number.isRequired
  }).isRequired),
  trailingControlColumns: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    headerCellRender: _propTypes.default.elementType.isRequired,
    rowCellRender: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,
    width: _propTypes.default.number.isRequired
  }).isRequired),
  columns: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * The unique identifier for this column
       */
    id: _propTypes.default.string.isRequired,

    /**
       * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
       */
    display: _propTypes.default.node,

    /**
       * A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
       */
    schema: _propTypes.default.string,

    /**
       * Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
       */
    isExpandable: _propTypes.default.bool,

    /**
       * Whether this column's width can be changed by the user, defaults to true
       */
    isResizable: _propTypes.default.bool,

    /**
       * Initial width (in pixels) of the column
       */
    initialWidth: _propTypes.default.number,

    /**
       * Whether this column is sortable
       */
    isSortable: _propTypes.default.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: _propTypes.default.oneOf(["asc", "desc"]),

    /**
       * Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.
       */
    displayAsText: _propTypes.default.string
  }).isRequired).isRequired,
  schema: _propTypes.default.shape({}).isRequired,
  schemaDetectors: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * The name of this data type, matches #EuiDataGridColumn / schema `schema`
       */
    type: _propTypes.default.string.isRequired,

    /**
       * The function given the text value of a cell and returns a score of [0...1] of how well the value matches this data type
       */
    detector: _propTypes.default.func.isRequired,

    /**
       * A custom comparator function when performing in-memory sorting on this data type, takes `(a: string, b: string, direction: 'asc' | 'desc) => -1 | 0 | 1`
       */
    comparator: _propTypes.default.func,

    /**
       * The icon used to visually represent this data type. Accepts any `EuiIcon IconType`.
       */
    icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,

    /**
       * The color associated with this data type; it's used to color the icon token
       */
    color: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["euiColorVis0", "euiColorVis1", "euiColorVis2", "euiColorVis3", "euiColorVis4", "euiColorVis5", "euiColorVis6", "euiColorVis7", "euiColorVis8", "euiColorVis9", "gray"]).isRequired, _propTypes.default.string.isRequired]).isRequired, _propTypes.default.string.isRequired]),

    /**
       * Text for how to represent an ascending sort of this data type, e.g. 'A -> Z'
       */
    sortTextAsc: _propTypes.default.node.isRequired,

    /**
       * Text for how to represent a descending sort of this data type, e.g. 'Z -> A'
       */
    sortTextDesc: _propTypes.default.node.isRequired,

    /**
       * Whether this column is sortable (defaults to true)
       */
    isSortable: _propTypes.default.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: _propTypes.default.oneOf(["asc", "desc"])
  }).isRequired).isRequired,
  popoverContents: _propTypes.default.shape({}),
  focusedCell: _propTypes.default.any,
  onCellFocus: _propTypes.default.func.isRequired,
  rowCount: _propTypes.default.number.isRequired,
  renderCellValue: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,
  inMemory: _propTypes.default.shape({
    /**
        Given the data flow Sorting->Pagination:
        Each step can be performed by service calls or in-memory by the grid.
        However, we cannot allow any service calls after an in-memory operation.
        E.g. if Pagination requires a service call the grid cannot perform
        in-memory Sorting. This means a single value representing the
        service / in-memory boundary can be used. Thus there are four states for in-memory's level:
        * "enhancements" - no in-memory operations, but use the available data to enhance the grid
        * "pagination" - only pagination is performed in-memory
        * "sorting" - sorting & pagination is performed in-memory
     */
    level: _propTypes.default.oneOf(["enhancements", "pagination", "sorting"]).isRequired,

    /**
       * An array of column ids for the in-memory processing to skip
       */
    skipColumns: _propTypes.default.arrayOf(_propTypes.default.string.isRequired)
  }),
  inMemoryValues: _propTypes.default.shape({}).isRequired,
  interactiveCellId: _propTypes.default.string.isRequired,
  pagination: _propTypes.default.shape({
    /**
       * The index of the current page, starts at 0 for the first page
       */
    pageIndex: _propTypes.default.number.isRequired,

    /**
       * How many rows should initially be shown per page
       */
    pageSize: _propTypes.default.number.isRequired,

    /**
       * An array of page sizes the user can select from.
       * Leave this prop undefined or use an empty array to hide "Rows per page" select button
       */
    pageSizeOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),

    /**
       * A callback for when the user changes the page size selection
       */
    onChangeItemsPerPage: _propTypes.default.func.isRequired,

    /**
       * A callback for when the current page index changes
       */
    onChangePage: _propTypes.default.func.isRequired
  }),
  sorting: _propTypes.default.shape({
    /**
       * A function that receives updated column sort details in response to user interactions in the toolbar controls
       */
    onSort: _propTypes.default.func.isRequired,

    /**
       * An array of the column ids currently being sorted and their sort direction. The array order determines the sort order. `{ id: 'A'; direction: 'asc' }`
       */
    columns: _propTypes.default.arrayOf(_propTypes.default.shape({
      id: _propTypes.default.string.isRequired,
      direction: _propTypes.default.oneOf(["asc", "desc"]).isRequired
    }).isRequired).isRequired
  })
};

try {
  EuiDataGridBody.__docgenInfo = {
    description: '',
    displayName: 'EuiDataGridBody',
    methods: [],
    props: {
      columnWidths: {
        defaultValue: null,
        description: '',
        name: 'columnWidths',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridColumnWidths'
        }
      },
      defaultColumnWidth: {
        defaultValue: null,
        description: '',
        name: 'defaultColumnWidth',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      leadingControlColumns: {
        defaultValue: null,
        description: '',
        name: 'leadingControlColumns',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      trailingControlColumns: {
        defaultValue: null,
        description: '',
        name: 'trailingControlColumns',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      columns: {
        defaultValue: null,
        description: '',
        name: 'columns',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridColumn[]'
        }
      },
      schema: {
        defaultValue: null,
        description: '',
        name: 'schema',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridSchema'
        }
      },
      schemaDetectors: {
        defaultValue: null,
        description: '',
        name: 'schemaDetectors',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridSchemaDetector[]'
        }
      },
      popoverContents: {
        defaultValue: null,
        description: '',
        name: 'popoverContents',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridPopoverContents'
        }
      },
      focusedCell: {
        defaultValue: null,
        description: '',
        name: 'focusedCell',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridFocusedCell'
        }
      },
      onCellFocus: {
        defaultValue: null,
        description: '',
        name: 'onCellFocus',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'Function'
        }
      },
      rowCount: {
        defaultValue: null,
        description: '',
        name: 'rowCount',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      renderCellValue: {
        defaultValue: null,
        description: '',
        name: 'renderCellValue',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: '((props: EuiDataGridCellValueElementProps) => ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)>) | (new (props: EuiDataGridCellValueElementProps) => Component<...>) | ((props: EuiDataGridCellValueEleme...'
        }
      },
      inMemory: {
        defaultValue: null,
        description: '',
        name: 'inMemory',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridInMemory'
        }
      },
      inMemoryValues: {
        defaultValue: null,
        description: '',
        name: 'inMemoryValues',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridInMemoryValues'
        }
      },
      interactiveCellId: {
        defaultValue: null,
        description: '',
        name: 'interactiveCellId',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      pagination: {
        defaultValue: null,
        description: '',
        name: 'pagination',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridPaginationProps'
        }
      },
      sorting: {
        defaultValue: null,
        description: '',
        name: 'sorting',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_body.tsx',
          name: 'EuiDataGridBodyProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridSorting'
        }
      }
    },
    extends: []
  };
} catch (e) {}