"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridDataRow = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _data_grid_cell = require("./data_grid_cell");

var _text = require("../text");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var DefaultColumnFormatter = function DefaultColumnFormatter(_ref) {
  var children = _ref.children;
  return _react.default.createElement(_text.EuiText, null, children);
};

var EuiDataGridDataRow = (0, _react.memo)(function (props) {
  var leadingControlColumns = props.leadingControlColumns,
      trailingControlColumns = props.trailingControlColumns,
      columns = props.columns,
      schema = props.schema,
      popoverContents = props.popoverContents,
      columnWidths = props.columnWidths,
      defaultColumnWidth = props.defaultColumnWidth,
      className = props.className,
      renderCellValue = props.renderCellValue,
      rowIndex = props.rowIndex,
      focusedCellPositionInTheRow = props.focusedCellPositionInTheRow,
      onCellFocus = props.onCellFocus,
      interactiveCellId = props.interactiveCellId,
      _dataTestSubj = props['data-test-subj'],
      visibleRowIndex = props.visibleRowIndex,
      rest = _objectWithoutProperties(props, ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "popoverContents", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "rowIndex", "focusedCellPositionInTheRow", "onCellFocus", "interactiveCellId", "data-test-subj", "visibleRowIndex"]);

  var classes = (0, _classnames.default)('euiDataGridRow', className);
  var dataTestSubj = (0, _classnames.default)('dataGridRow', _dataTestSubj);
  return _react.default.createElement("div", _extends({
    role: "row",
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (leadingColumn, i) {
    var id = leadingColumn.id,
        rowCellRender = leadingColumn.rowCellRender;
    return _react.default.createElement(_data_grid_cell.EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: i,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      onCellFocus: onCellFocus,
      isFocused: focusedCellPositionInTheRow === i,
      interactiveCellId: interactiveCellId,
      isExpandable: false,
      className: "euiDataGridRowCell--controlColumn"
    });
  }), columns.map(function (props, i) {
    var id = props.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var isExpandable = props.isExpandable !== undefined ? props.isExpandable : true;
    var popoverContent = popoverContents[columnType] || DefaultColumnFormatter;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return _react.default.createElement(_data_grid_cell.EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      popoverContent: popoverContent,
      width: width || undefined,
      renderCellValue: renderCellValue,
      onCellFocus: onCellFocus,
      isFocused: focusedCellPositionInTheRow === columnPosition,
      interactiveCellId: interactiveCellId,
      isExpandable: isExpandable
    });
  }), trailingControlColumns.map(function (leadingColumn, i) {
    var id = leadingColumn.id,
        rowCellRender = leadingColumn.rowCellRender;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return _react.default.createElement(_data_grid_cell.EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      onCellFocus: onCellFocus,
      isFocused: focusedCellPositionInTheRow === colIndex,
      interactiveCellId: interactiveCellId,
      isExpandable: false,
      className: "euiDataGridRowCell--controlColumn"
    });
  }));
});
exports.EuiDataGridDataRow = EuiDataGridDataRow;
EuiDataGridDataRow.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  rowIndex: _propTypes.default.number.isRequired,
  leadingControlColumns: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Used as the React `key` when rendering content
       */
    id: _propTypes.default.string.isRequired,

    /**
       * Component to render in the column header
       */
    headerCellRender: _propTypes.default.elementType.isRequired,

    /**
       * Component to render for each row in the column
       */
    rowCellRender: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,

    /**
       * Width of the column, uses are unable to change this
       */
    width: _propTypes.default.number.isRequired
  }).isRequired).isRequired,
  trailingControlColumns: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    headerCellRender: _propTypes.default.elementType.isRequired,
    rowCellRender: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,
    width: _propTypes.default.number.isRequired
  }).isRequired).isRequired,
  columns: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * The unique identifier for this column
       */
    id: _propTypes.default.string.isRequired,

    /**
       * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
       */
    display: _propTypes.default.node,

    /**
       * A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
       */
    schema: _propTypes.default.string,

    /**
       * Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
       */
    isExpandable: _propTypes.default.bool,

    /**
       * Whether this column's width can be changed by the user, defaults to true
       */
    isResizable: _propTypes.default.bool,

    /**
       * Initial width (in pixels) of the column
       */
    initialWidth: _propTypes.default.number,

    /**
       * Whether this column is sortable
       */
    isSortable: _propTypes.default.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: _propTypes.default.oneOf(["asc", "desc"]),

    /**
       * Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.
       */
    displayAsText: _propTypes.default.string
  }).isRequired).isRequired,
  schema: _propTypes.default.shape({}).isRequired,
  popoverContents: _propTypes.default.shape({}).isRequired,
  columnWidths: _propTypes.default.shape({}).isRequired,
  defaultColumnWidth: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
  focusedCellPositionInTheRow: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
  renderCellValue: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]).isRequired,
  onCellFocus: _propTypes.default.func.isRequired,
  interactiveCellId: _propTypes.default.string.isRequired,
  visibleRowIndex: _propTypes.default.number.isRequired
};

try {
  EuiDataGridDataRow.__docgenInfo = {
    description: '',
    displayName: 'EuiDataGridDataRow',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rowIndex: {
        defaultValue: null,
        description: '',
        name: 'rowIndex',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      leadingControlColumns: {
        defaultValue: null,
        description: '',
        name: 'leadingControlColumns',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      trailingControlColumns: {
        defaultValue: null,
        description: '',
        name: 'trailingControlColumns',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      columns: {
        defaultValue: null,
        description: '',
        name: 'columns',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridColumn[]'
        }
      },
      schema: {
        defaultValue: null,
        description: '',
        name: 'schema',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridSchema'
        }
      },
      popoverContents: {
        defaultValue: null,
        description: '',
        name: 'popoverContents',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridPopoverContents'
        }
      },
      columnWidths: {
        defaultValue: null,
        description: '',
        name: 'columnWidths',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridColumnWidths'
        }
      },
      defaultColumnWidth: {
        defaultValue: null,
        description: '',
        name: 'defaultColumnWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      focusedCellPositionInTheRow: {
        defaultValue: null,
        description: '',
        name: 'focusedCellPositionInTheRow',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      renderCellValue: {
        defaultValue: null,
        description: '',
        name: 'renderCellValue',
        parent: undefined,
        required: true,
        type: {
          name: '((props: EuiDataGridCellValueElementProps) => ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)>) | (new (props: EuiDataGridCellValueElementProps) => Component<...>) | ((props: EuiDataGridCellValueEleme...'
        }
      },
      onCellFocus: {
        defaultValue: null,
        description: '',
        name: 'onCellFocus',
        parent: undefined,
        required: true,
        type: {
          name: 'Function'
        }
      },
      interactiveCellId: {
        defaultValue: null,
        description: '',
        name: 'interactiveCellId',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      visibleRowIndex: {
        defaultValue: null,
        description: '',
        name: 'visibleRowIndex',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}