"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePicker = exports.euiDatePickerDefaultTimeFormat = exports.euiDatePickerDefaultDateFormat = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form = require("../form");

var _error_boundary = require("../error_boundary");

var _context = require("../context");

var _packages = require("../../../packages");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// eslint-disable-line import/no-unresolved
var euiDatePickerDefaultDateFormat = 'MM/DD/YYYY';
exports.euiDatePickerDefaultDateFormat = euiDatePickerDefaultDateFormat;
var euiDatePickerDefaultTimeFormat = 'hh:mm A';
exports.euiDatePickerDefaultTimeFormat = euiDatePickerDefaultTimeFormat;
var DatePicker = _packages.ReactDatePicker;

var EuiDatePicker =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiDatePicker, _Component);

  function EuiDatePicker() {
    _classCallCheck(this, EuiDatePicker);

    return _possibleConstructorReturn(this, _getPrototypeOf(EuiDatePicker).apply(this, arguments));
  }

  _createClass(EuiDatePicker, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          adjustDateOnChange = _this$props.adjustDateOnChange,
          calendarClassName = _this$props.calendarClassName,
          className = _this$props.className,
          customInput = _this$props.customInput,
          dateFormat = _this$props.dateFormat,
          dayClassName = _this$props.dayClassName,
          disabled = _this$props.disabled,
          excludeDates = _this$props.excludeDates,
          filterDate = _this$props.filterDate,
          fullWidth = _this$props.fullWidth,
          iconType = _this$props.iconType,
          injectTimes = _this$props.injectTimes,
          inline = _this$props.inline,
          inputRef = _this$props.inputRef,
          isInvalid = _this$props.isInvalid,
          isLoading = _this$props.isLoading,
          locale = _this$props.locale,
          maxDate = _this$props.maxDate,
          maxTime = _this$props.maxTime,
          minDate = _this$props.minDate,
          minTime = _this$props.minTime,
          onChange = _this$props.onChange,
          onClear = _this$props.onClear,
          openToDate = _this$props.openToDate,
          placeholder = _this$props.placeholder,
          popperClassName = _this$props.popperClassName,
          popoverPlacement = _this$props.popoverPlacement,
          selected = _this$props.selected,
          shadow = _this$props.shadow,
          shouldCloseOnSelect = _this$props.shouldCloseOnSelect,
          showIcon = _this$props.showIcon,
          showTimeSelect = _this$props.showTimeSelect,
          showTimeSelectOnly = _this$props.showTimeSelectOnly,
          timeFormat = _this$props.timeFormat,
          utcOffset = _this$props.utcOffset,
          rest = _objectWithoutProperties(_this$props, ["adjustDateOnChange", "calendarClassName", "className", "customInput", "dateFormat", "dayClassName", "disabled", "excludeDates", "filterDate", "fullWidth", "iconType", "injectTimes", "inline", "inputRef", "isInvalid", "isLoading", "locale", "maxDate", "maxTime", "minDate", "minTime", "onChange", "onClear", "openToDate", "placeholder", "popperClassName", "popoverPlacement", "selected", "shadow", "shouldCloseOnSelect", "showIcon", "showTimeSelect", "showTimeSelectOnly", "timeFormat", "utcOffset"]);

      var classes = (0, _classnames.default)('euiDatePicker', {
        'euiDatePicker--shadow': shadow,
        'euiDatePicker--inline': inline
      });
      var datePickerClasses = (0, _classnames.default)('euiDatePicker', 'euiFieldText', {
        'euiFieldText--fullWidth': fullWidth,
        'euiFieldText-isLoading': isLoading,
        'euiFieldText--withIcon': !inline && showIcon,
        'euiFieldText-isInvalid': isInvalid
      }, className);
      var optionalIcon;

      if (inline || customInput || !showIcon) {
        optionalIcon = undefined;
      } else if (iconType) {
        optionalIcon = iconType;
      } else if (showTimeSelectOnly) {
        optionalIcon = 'clock';
      } else {
        optionalIcon = 'calendar';
      } // In case the consumer did not alter the default date format but wants
      // to add the time select, we append the default time format


      var fullDateFormat = dateFormat;

      if (showTimeSelect && dateFormat === euiDatePickerDefaultDateFormat) {
        fullDateFormat = "".concat(dateFormat, " ").concat(timeFormat);
      } // EuiDatePicker only supports a subset of props from react-datepicker. Using any of
      // the unsupported props below will spit out an error.


      var PropNotSupported = function PropNotSupported() {
        throw new Error("You are using a prop from react-datepicker that EuiDatePicker\n        does not support. Please check the EUI documentation for more information.");
      };

      if ( // We don't want to show multiple months next to each other
      this.props.monthsShown || // There is no need to show week numbers
      this.props.showWeekNumbers || // Our css adapts to height, no need to fix it
      this.props.fixedHeight || // We force the month / year selection UI. No need to configure it
      this.props.dropdownMode || // Short month is uncessary. Our UI has plenty of room for full months
      this.props.useShortMonthInDropdown || // The today button is not needed. This should always be external to the calendar
      this.props.todayButton || // We hide the time caption, so there is no need to overwrite its text
      this.props.timeCaption || // We always want keyboard accessibility on
      this.props.disabledKeyboardNavigation || // This is easy enough to do. It can conflict with isLoading state
      this.props.isClearable || // There is no reason to launch the datepicker in its own modal. Can always build these ourselves
      this.props.withPortal) {
        return _react.default.createElement(_error_boundary.EuiErrorBoundary, null, _react.default.createElement(PropNotSupported, null));
      }

      return _react.default.createElement("span", null, _react.default.createElement("span", {
        className: classes
      }, _react.default.createElement(_form.EuiFormControlLayout, {
        icon: optionalIcon,
        fullWidth: fullWidth,
        clear: selected && onClear ? {
          onClick: onClear
        } : undefined,
        isLoading: isLoading
      }, _react.default.createElement(_form.EuiValidatableControl, {
        isInvalid: isInvalid
      }, _react.default.createElement(_context.EuiI18nConsumer, null, function (_ref) {
        var contextLocale = _ref.locale;
        return _react.default.createElement(DatePicker, _extends({
          adjustDateOnChange: adjustDateOnChange,
          calendarClassName: calendarClassName,
          className: datePickerClasses,
          customInput: customInput,
          dateFormat: fullDateFormat,
          dayClassName: dayClassName,
          disabled: disabled,
          excludeDates: excludeDates,
          filterDate: filterDate,
          injectTimes: injectTimes,
          inline: inline,
          locale: locale || contextLocale,
          maxDate: maxDate,
          maxTime: maxTime,
          minDate: minDate,
          minTime: minTime,
          onChange: onChange,
          openToDate: openToDate,
          placeholderText: placeholder,
          popperClassName: popperClassName,
          ref: inputRef,
          selected: selected,
          shouldCloseOnSelect: shouldCloseOnSelect,
          showMonthDropdown: true,
          showTimeSelect: showTimeSelect,
          showTimeSelectOnly: showTimeSelectOnly,
          showYearDropdown: true,
          timeFormat: timeFormat,
          utcOffset: utcOffset,
          yearDropdownItemNumber: 7,
          accessibleMode: true,
          popperPlacement: popoverPlacement
        }, rest));
      })))));
    }
  }]);

  return EuiDatePicker;
}(_react.Component);

exports.EuiDatePicker = EuiDatePicker;

_defineProperty(EuiDatePicker, "defaultProps", {
  adjustDateOnChange: true,
  dateFormat: euiDatePickerDefaultDateFormat,
  fullWidth: false,
  inputRef: function inputRef() {},
  isLoading: false,
  shadow: true,
  shouldCloseOnSelect: true,
  showIcon: true,
  showTimeSelect: false,
  timeFormat: euiDatePickerDefaultTimeFormat,
  popoverPlacement: 'bottom-start'
});

EuiDatePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Applies classes to the numbered days provided. Check docs for example.
     */
  dayClassName: _propTypes.default.func,

  /**
     * Makes the input full width
     */
  fullWidth: _propTypes.default.bool,

  /**
     * ref for the ReactDatePicker instance
     */
  inputRef: _propTypes.default.any.isRequired,

  /**
     * Provides styling to the input when invalid
     */
  isInvalid: _propTypes.default.bool,

  /**
     * Provides styling to the input when loading
     */
  isLoading: _propTypes.default.bool,

  /**
     * What to do when the input is cleared by the x icon
     */
  onClear: _propTypes.default.func,

  /**
     * Opens to this date (in moment format) on first press, regardless of selection
     */
  openToDate: _propTypes.default.any,

  /**
     * Shows only when no date is selected
     */
  placeholder: _propTypes.default.string,

  /**
     * Can turn the shadow off if using the inline prop
     */
  shadow: _propTypes.default.bool,

  /**
     * Show the icon in input
     */
  showIcon: _propTypes.default.bool,

  /**
     * Pass an icon type to change the default `calendar` or `clock` icon
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
    side: _propTypes.default.any,
    ref: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired])
  }).isRequired]),

  /**
     * Sets the placement of the popover. It accepts: `"bottom"`, `"bottom-end"`, `"bottom-start"`, `"left"`, `"left-end"`, `"left-start"`, `"right"`, `"right-end"`, `"right-start"`, `"top"`, `"top-end"`, `"top-start"`
     */
  popoverPlacement: _propTypes.default.any
};

try {
  EuiDatePicker.__docgenInfo = {
    description: '',
    displayName: 'EuiDatePicker',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: 'Added to the actual input of the calendar',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      dayClassName: {
        defaultValue: null,
        description: 'Applies classes to the numbered days provided. Check docs for example.',
        name: 'dayClassName',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => string'
        }
      },
      fullWidth: {
        defaultValue: {
          value: 'false'
        },
        description: 'Makes the input full width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputRef: {
        defaultValue: {
          value: '() => {}'
        },
        description: 'ref for the ReactDatePicker instance',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'Ref<Component<ReactDatePickerProps, any, any>>'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: 'Provides styling to the input when invalid',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: {
          value: 'false'
        },
        description: 'Provides styling to the input when loading',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onClear: {
        defaultValue: null,
        description: 'What to do when the input is cleared by the x icon',
        name: 'onClear',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      openToDate: {
        defaultValue: null,
        description: 'Opens to this date (in moment format) on first press, regardless of selection',
        name: 'openToDate',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      placeholder: {
        defaultValue: null,
        description: 'Shows only when no date is selected',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      shadow: {
        defaultValue: {
          value: 'true'
        },
        description: 'Can turn the shadow off if using the inline prop',
        name: 'shadow',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showIcon: {
        defaultValue: {
          value: 'true'
        },
        description: 'Show the icon in input',
        name: 'showIcon',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Pass an icon type to change the default `calendar` or `clock` icon',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'string | ComponentClass<{}, any> | FunctionComponent<{}> | (Pick<CommonProps & DisambiguateSet<Pick<ButtonHTMLAttributes<HTMLButtonElement>, "children" | ... 262 more ... | "value">, HTMLAttributes<...>> & HTMLAttributes<...> & { ...; }, "children" | ... 263 more ... | "value"> & { ...; }) | (Pick<...> & { ...; })'
        }
      },
      popoverPlacement: {
        defaultValue: {
          value: 'bottom-start'
        },
        description: 'Sets the placement of the popover. It accepts: `"bottom"`, `"bottom-end"`, `"bottom-start"`, `"left"`, `"left-end"`, `"left-start"`, `"right"`, `"right-end"`, `"right-start"`, `"top"`, `"top-end"`, `"top-start"`',
        name: 'popoverPlacement',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'popperPlacement',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"bottom-start"'
          }, {
            value: '"bottom-end"'
          }, {
            value: '"left-end"'
          }, {
            value: '"left-start"'
          }, {
            value: '"right-end"'
          }, {
            value: '"right-start"'
          }, {
            value: '"top-end"'
          }, {
            value: '"top-start"'
          }]
        }
      },
      adjustDateOnChange: {
        defaultValue: {
          value: 'true'
        },
        description: 'Whether changes to Year and Month (via dropdowns) should trigger `onChange`',
        name: 'adjustDateOnChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      accessibleMode: {
        defaultValue: null,
        description: '',
        name: 'accessibleMode',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      allowSameDay: {
        defaultValue: null,
        description: '',
        name: 'allowSameDay',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      autoComplete: {
        defaultValue: null,
        description: '',
        name: 'autoComplete',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      autoFocus: {
        defaultValue: null,
        description: '',
        name: 'autoFocus',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      calendarClassName: {
        defaultValue: null,
        description: 'Optional class added to the calendar portion of datepicker',
        name: 'calendarClassName',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      customInput: {
        defaultValue: null,
        description: 'Replaces the input with any node, like a button',
        name: 'customInput',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      customInputRef: {
        defaultValue: null,
        description: '',
        name: 'customInputRef',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      dateFormat: {
        defaultValue: {
          value: null
        },
        description: 'Accepts any moment format string',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string | string[]'
        }
      },
      dateFormatCalendar: {
        defaultValue: null,
        description: '',
        name: 'dateFormatCalendar',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabledKeyboardNavigation: {
        defaultValue: null,
        description: '',
        name: 'disabledKeyboardNavigation',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      dropdownMode: {
        defaultValue: null,
        description: '',
        name: 'dropdownMode',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"select" | "scroll"',
          value: [{
            value: '"select"'
          }, {
            value: '"scroll"'
          }]
        }
      },
      endDate: {
        defaultValue: null,
        description: '',
        name: 'endDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      excludeDates: {
        defaultValue: null,
        description: '',
        name: 'excludeDates',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      excludeTimes: {
        defaultValue: null,
        description: '',
        name: 'excludeTimes',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      filterDate: {
        defaultValue: null,
        description: '',
        name: 'filterDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => boolean'
        }
      },
      fixedHeight: {
        defaultValue: null,
        description: '',
        name: 'fixedHeight',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      forceShowMonthNavigation: {
        defaultValue: null,
        description: '',
        name: 'forceShowMonthNavigation',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      formatWeekNumber: {
        defaultValue: null,
        description: '',
        name: 'formatWeekNumber',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => ReactText'
        }
      },
      highlightDates: {
        defaultValue: null,
        description: '',
        name: 'highlightDates',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      includeDates: {
        defaultValue: null,
        description: '',
        name: 'includeDates',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      includeTimes: {
        defaultValue: null,
        description: '',
        name: 'includeTimes',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      inline: {
        defaultValue: null,
        description: '',
        name: 'inline',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      injectTimes: {
        defaultValue: null,
        description: 'Adds additional times to the time selector other then :30 increments',
        name: 'injectTimes',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      isClearable: {
        defaultValue: null,
        description: '',
        name: 'isClearable',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      locale: {
        defaultValue: null,
        description: 'Switches the locale / display. "en-us", "zn-ch"...etc',
        name: 'locale',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      maxDate: {
        defaultValue: null,
        description: 'The max date accepted (in moment format) as a selection',
        name: 'maxDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      maxTime: {
        defaultValue: null,
        description: 'The max time accepted (in moment format) as a selection',
        name: 'maxTime',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      minDate: {
        defaultValue: null,
        description: 'The min date accepted (in moment format) as a selection',
        name: 'minDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      minTime: {
        defaultValue: null,
        description: 'The min time accepted (in moment format) as a selection',
        name: 'minTime',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      monthsShown: {
        defaultValue: null,
        description: '',
        name: 'monthsShown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'What to do when the input changes',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment, event?: SyntheticEvent<any, Event>) => void'
        }
      },
      onChangeRaw: {
        defaultValue: null,
        description: '',
        name: 'onChangeRaw',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onClickOutside: {
        defaultValue: null,
        description: '',
        name: 'onClickOutside',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLDivElement, MouseEvent>) => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onKeyDown: {
        defaultValue: null,
        description: '',
        name: 'onKeyDown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: KeyboardEvent<HTMLDivElement>) => void'
        }
      },
      onMonthChange: {
        defaultValue: null,
        description: '',
        name: 'onMonthChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => void'
        }
      },
      onSelect: {
        defaultValue: null,
        description: '',
        name: 'onSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment, event?: SyntheticEvent<any, Event>) => void'
        }
      },
      onWeekSelect: {
        defaultValue: null,
        description: '',
        name: 'onWeekSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(firstDayOfWeek: Moment, weekNumber: ReactText, event?: SyntheticEvent<any, Event>) => void'
        }
      },
      onYearChange: {
        defaultValue: null,
        description: '',
        name: 'onYearChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => void'
        }
      },
      peekNextMonth: {
        defaultValue: null,
        description: '',
        name: 'peekNextMonth',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      placeholderText: {
        defaultValue: null,
        description: '',
        name: 'placeholderText',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      popperClassName: {
        defaultValue: null,
        description: 'Class applied to the popup, when inline is false',
        name: 'popperClassName',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      popperContainer: {
        defaultValue: null,
        description: '',
        name: 'popperContainer',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(props: { children: ReactNode[]; }) => ReactNode'
        }
      },
      popperPlacement: {
        defaultValue: null,
        description: '',
        name: 'popperPlacement',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'popperPlacement',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"bottom-start"'
          }, {
            value: '"bottom-end"'
          }, {
            value: '"left-end"'
          }, {
            value: '"left-start"'
          }, {
            value: '"right-end"'
          }, {
            value: '"right-start"'
          }, {
            value: '"top-end"'
          }, {
            value: '"top-start"'
          }]
        }
      },
      preventOpenOnFocus: {
        defaultValue: null,
        description: '',
        name: 'preventOpenOnFocus',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      required: {
        defaultValue: null,
        description: '',
        name: 'required',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      scrollableMonthYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'scrollableMonthYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      scrollableYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'scrollableYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      selected: {
        defaultValue: null,
        description: 'The selected datetime (in moment format)',
        name: 'selected',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      selectsEnd: {
        defaultValue: null,
        description: '',
        name: 'selectsEnd',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      selectsStart: {
        defaultValue: null,
        description: '',
        name: 'selectsStart',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      shouldCloseOnSelect: {
        defaultValue: {
          value: 'true'
        },
        description: 'Will close the popup on selection',
        name: 'shouldCloseOnSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showDisabledMonthNavigation: {
        defaultValue: null,
        description: '',
        name: 'showDisabledMonthNavigation',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showMonthDropdown: {
        defaultValue: null,
        description: '',
        name: 'showMonthDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showMonthYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'showMonthYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTimeSelect: {
        defaultValue: {
          value: 'false'
        },
        description: 'Show the time selection alongside the calendar',
        name: 'showTimeSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTimeSelectOnly: {
        defaultValue: null,
        description: 'Only show the time selector, not the calendar',
        name: 'showTimeSelectOnly',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showWeekNumbers: {
        defaultValue: null,
        description: '',
        name: 'showWeekNumbers',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'showYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      startDate: {
        defaultValue: null,
        description: '',
        name: 'startDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      startOpen: {
        defaultValue: null,
        description: '',
        name: 'startOpen',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      tabIndex: {
        defaultValue: null,
        description: '',
        name: 'tabIndex',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      timeCaption: {
        defaultValue: null,
        description: '',
        name: 'timeCaption',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      timeFormat: {
        defaultValue: {
          value: null
        },
        description: 'The format of the time within the selector, in moment notation',
        name: 'timeFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      timeIntervals: {
        defaultValue: null,
        description: '',
        name: 'timeIntervals',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      todayButton: {
        defaultValue: null,
        description: '',
        name: 'todayButton',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      useShortMonthInDropdown: {
        defaultValue: null,
        description: '',
        name: 'useShortMonthInDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      useWeekdaysShort: {
        defaultValue: null,
        description: '',
        name: 'useWeekdaysShort',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      weekLabel: {
        defaultValue: null,
        description: '',
        name: 'weekLabel',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      withPortal: {
        defaultValue: null,
        description: '',
        name: 'withPortal',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      yearDropdownItemNumber: {
        defaultValue: null,
        description: '',
        name: 'yearDropdownItemNumber',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}