"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  EuiDatePicker: true,
  EuiDatePickerRange: true
};
Object.defineProperty(exports, "EuiDatePicker", {
  enumerable: true,
  get: function get() {
    return _date_picker.EuiDatePicker;
  }
});
Object.defineProperty(exports, "EuiDatePickerRange", {
  enumerable: true,
  get: function get() {
    return _date_picker_range.EuiDatePickerRange;
  }
});

var _super_date_picker = require("./super_date_picker");

Object.keys(_super_date_picker).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _super_date_picker[key];
    }
  });
});

var _date_picker = require("./date_picker");

var _date_picker_range = require("./date_picker_range");

require("./types");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiDatePicker.__docgenInfo = {
    description: '',
    displayName: 'EuiDatePicker',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: 'Added to the actual input of the calendar',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      dayClassName: {
        defaultValue: null,
        description: 'Applies classes to the numbered days provided. Check docs for example.',
        name: 'dayClassName',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'Makes the input full width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputRef: {
        defaultValue: null,
        description: 'ref for the ReactDatePicker instance',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: true,
        type: {
          name: 'Ref<Component<ReactDatePickerProps, any, any>>'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: 'Provides styling to the input when invalid',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Provides styling to the input when loading',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onClear: {
        defaultValue: null,
        description: 'What to do when the input is cleared by the x icon',
        name: 'onClear',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      openToDate: {
        defaultValue: null,
        description: 'Opens to this date (in moment format) on first press, regardless of selection',
        name: 'openToDate',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      placeholder: {
        defaultValue: null,
        description: 'Shows only when no date is selected',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      shadow: {
        defaultValue: null,
        description: 'Can turn the shadow off if using the inline prop',
        name: 'shadow',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showIcon: {
        defaultValue: null,
        description: 'Show the icon in input',
        name: 'showIcon',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Pass an icon type to change the default `calendar` or `clock` icon',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'string | ComponentClass<{}, any> | FunctionComponent<{}> | (Pick<CommonProps & DisambiguateSet<Pick<ButtonHTMLAttributes<HTMLButtonElement>, "children" | ... 262 more ... | "value">, HTMLAttributes<...>> & HTMLAttributes<...> & { ...; }, "children" | ... 263 more ... | "value"> & { ...; }) | (Pick<...> & { ...; })'
        }
      },
      popoverPlacement: {
        defaultValue: null,
        description: 'Sets the placement of the popover. It accepts: `"bottom"`, `"bottom-end"`, `"bottom-start"`, `"left"`, `"left-end"`, `"left-start"`, `"right"`, `"right-end"`, `"right-start"`, `"top"`, `"top-end"`, `"top-start"`',
        name: 'popoverPlacement',
        parent: {
          fileName: 'eui/src/components/date_picker/date_picker.tsx',
          name: 'EuiExtendedDatePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'popperPlacement',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"bottom-start"'
          }, {
            value: '"bottom-end"'
          }, {
            value: '"left-end"'
          }, {
            value: '"left-start"'
          }, {
            value: '"right-end"'
          }, {
            value: '"right-start"'
          }, {
            value: '"top-end"'
          }, {
            value: '"top-start"'
          }]
        }
      },
      adjustDateOnChange: {
        defaultValue: null,
        description: 'Whether changes to Year and Month (via dropdowns) should trigger `onChange`',
        name: 'adjustDateOnChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      accessibleMode: {
        defaultValue: null,
        description: '',
        name: 'accessibleMode',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      allowSameDay: {
        defaultValue: null,
        description: '',
        name: 'allowSameDay',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      autoComplete: {
        defaultValue: null,
        description: '',
        name: 'autoComplete',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      autoFocus: {
        defaultValue: null,
        description: '',
        name: 'autoFocus',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      calendarClassName: {
        defaultValue: null,
        description: 'Optional class added to the calendar portion of datepicker',
        name: 'calendarClassName',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      customInput: {
        defaultValue: null,
        description: 'Replaces the input with any node, like a button',
        name: 'customInput',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      customInputRef: {
        defaultValue: null,
        description: '',
        name: 'customInputRef',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: 'Accepts any moment format string',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string | string[]'
        }
      },
      dateFormatCalendar: {
        defaultValue: null,
        description: '',
        name: 'dateFormatCalendar',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabledKeyboardNavigation: {
        defaultValue: null,
        description: '',
        name: 'disabledKeyboardNavigation',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      dropdownMode: {
        defaultValue: null,
        description: '',
        name: 'dropdownMode',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"select" | "scroll"',
          value: [{
            value: '"select"'
          }, {
            value: '"scroll"'
          }]
        }
      },
      endDate: {
        defaultValue: null,
        description: '',
        name: 'endDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      excludeDates: {
        defaultValue: null,
        description: '',
        name: 'excludeDates',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      excludeTimes: {
        defaultValue: null,
        description: '',
        name: 'excludeTimes',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      filterDate: {
        defaultValue: null,
        description: '',
        name: 'filterDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => boolean'
        }
      },
      fixedHeight: {
        defaultValue: null,
        description: '',
        name: 'fixedHeight',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      forceShowMonthNavigation: {
        defaultValue: null,
        description: '',
        name: 'forceShowMonthNavigation',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      formatWeekNumber: {
        defaultValue: null,
        description: '',
        name: 'formatWeekNumber',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => ReactText'
        }
      },
      highlightDates: {
        defaultValue: null,
        description: '',
        name: 'highlightDates',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      includeDates: {
        defaultValue: null,
        description: '',
        name: 'includeDates',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      includeTimes: {
        defaultValue: null,
        description: '',
        name: 'includeTimes',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      inline: {
        defaultValue: null,
        description: '',
        name: 'inline',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      injectTimes: {
        defaultValue: null,
        description: 'Adds additional times to the time selector other then :30 increments',
        name: 'injectTimes',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment[]'
        }
      },
      isClearable: {
        defaultValue: null,
        description: '',
        name: 'isClearable',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      locale: {
        defaultValue: null,
        description: 'Switches the locale / display. "en-us", "zn-ch"...etc',
        name: 'locale',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      maxDate: {
        defaultValue: null,
        description: 'The max date accepted (in moment format) as a selection',
        name: 'maxDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      maxTime: {
        defaultValue: null,
        description: 'The max time accepted (in moment format) as a selection',
        name: 'maxTime',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      minDate: {
        defaultValue: null,
        description: 'The min date accepted (in moment format) as a selection',
        name: 'minDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      minTime: {
        defaultValue: null,
        description: 'The min time accepted (in moment format) as a selection',
        name: 'minTime',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      monthsShown: {
        defaultValue: null,
        description: '',
        name: 'monthsShown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'What to do when the input changes',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment, event?: SyntheticEvent<any, Event>) => void'
        }
      },
      onChangeRaw: {
        defaultValue: null,
        description: '',
        name: 'onChangeRaw',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onClickOutside: {
        defaultValue: null,
        description: '',
        name: 'onClickOutside',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLDivElement, MouseEvent>) => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onKeyDown: {
        defaultValue: null,
        description: '',
        name: 'onKeyDown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(event: KeyboardEvent<HTMLDivElement>) => void'
        }
      },
      onMonthChange: {
        defaultValue: null,
        description: '',
        name: 'onMonthChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => void'
        }
      },
      onSelect: {
        defaultValue: null,
        description: '',
        name: 'onSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment, event?: SyntheticEvent<any, Event>) => void'
        }
      },
      onWeekSelect: {
        defaultValue: null,
        description: '',
        name: 'onWeekSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(firstDayOfWeek: Moment, weekNumber: ReactText, event?: SyntheticEvent<any, Event>) => void'
        }
      },
      onYearChange: {
        defaultValue: null,
        description: '',
        name: 'onYearChange',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(date: Moment) => void'
        }
      },
      peekNextMonth: {
        defaultValue: null,
        description: '',
        name: 'peekNextMonth',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      placeholderText: {
        defaultValue: null,
        description: '',
        name: 'placeholderText',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      popperClassName: {
        defaultValue: null,
        description: 'Class applied to the popup, when inline is false',
        name: 'popperClassName',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      popperContainer: {
        defaultValue: null,
        description: '',
        name: 'popperContainer',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: '(props: { children: ReactNode[]; }) => ReactNode'
        }
      },
      popperPlacement: {
        defaultValue: null,
        description: '',
        name: 'popperPlacement',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'popperPlacement',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"bottom-start"'
          }, {
            value: '"bottom-end"'
          }, {
            value: '"left-end"'
          }, {
            value: '"left-start"'
          }, {
            value: '"right-end"'
          }, {
            value: '"right-start"'
          }, {
            value: '"top-end"'
          }, {
            value: '"top-start"'
          }]
        }
      },
      preventOpenOnFocus: {
        defaultValue: null,
        description: '',
        name: 'preventOpenOnFocus',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      required: {
        defaultValue: null,
        description: '',
        name: 'required',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      scrollableMonthYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'scrollableMonthYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      scrollableYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'scrollableYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      selected: {
        defaultValue: null,
        description: 'The selected datetime (in moment format)',
        name: 'selected',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      selectsEnd: {
        defaultValue: null,
        description: '',
        name: 'selectsEnd',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      selectsStart: {
        defaultValue: null,
        description: '',
        name: 'selectsStart',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      shouldCloseOnSelect: {
        defaultValue: null,
        description: 'Will close the popup on selection',
        name: 'shouldCloseOnSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showDisabledMonthNavigation: {
        defaultValue: null,
        description: '',
        name: 'showDisabledMonthNavigation',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showMonthDropdown: {
        defaultValue: null,
        description: '',
        name: 'showMonthDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showMonthYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'showMonthYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTimeSelect: {
        defaultValue: null,
        description: 'Show the time selection alongside the calendar',
        name: 'showTimeSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTimeSelectOnly: {
        defaultValue: null,
        description: 'Only show the time selector, not the calendar',
        name: 'showTimeSelectOnly',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showWeekNumbers: {
        defaultValue: null,
        description: '',
        name: 'showWeekNumbers',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showYearDropdown: {
        defaultValue: null,
        description: '',
        name: 'showYearDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      startDate: {
        defaultValue: null,
        description: '',
        name: 'startDate',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'Moment'
        }
      },
      startOpen: {
        defaultValue: null,
        description: '',
        name: 'startOpen',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      tabIndex: {
        defaultValue: null,
        description: '',
        name: 'tabIndex',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      timeCaption: {
        defaultValue: null,
        description: '',
        name: 'timeCaption',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      timeFormat: {
        defaultValue: null,
        description: 'The format of the time within the selector, in moment notation',
        name: 'timeFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      timeIntervals: {
        defaultValue: null,
        description: '',
        name: 'timeIntervals',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      todayButton: {
        defaultValue: null,
        description: '',
        name: 'todayButton',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      useShortMonthInDropdown: {
        defaultValue: null,
        description: '',
        name: 'useShortMonthInDropdown',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      useWeekdaysShort: {
        defaultValue: null,
        description: '',
        name: 'useWeekdaysShort',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      weekLabel: {
        defaultValue: null,
        description: '',
        name: 'weekLabel',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      withPortal: {
        defaultValue: null,
        description: '',
        name: 'withPortal',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      yearDropdownItemNumber: {
        defaultValue: null,
        description: '',
        name: 'yearDropdownItemNumber',
        parent: {
          fileName: 'eui/src/components/date_picker/react-datepicker.d.ts',
          name: 'ReactDatePickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiDatePickerRange.__docgenInfo = {
    description: '',
    displayName: 'EuiDatePickerRange',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'Including any children will replace all innerds with the provided children',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      endDateControl: {
        defaultValue: null,
        description: 'The end date `EuiDatePicker` element',
        name: 'endDateControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Pass either an icon type or set to `false` to remove icon entirely',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'string | boolean | ComponentClass<{}, any> | FunctionComponent<{}>'
        }
      },
      isCustom: {
        defaultValue: null,
        description: 'Won\'t apply any additional props to start and end date components',
        name: 'isCustom',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      startDateControl: {
        defaultValue: null,
        description: 'The start date `EuiDatePicker` element',
        name: 'startDateControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiSuperDatePicker.__docgenInfo = {
    description: '',
    displayName: 'EuiSuperDatePicker',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      commonlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'commonlyUsedRanges',
        parent: undefined,
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      },
      customQuickSelectPanels: {
        defaultValue: null,
        description: '',
        name: 'customQuickSelectPanels',
        parent: undefined,
        required: false,
        type: {
          name: 'QuickSelectPanel[]'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: 'Specifies the formatted used when displaying dates and/or datetimes',
        name: 'dateFormat',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      end: {
        defaultValue: null,
        description: '',
        name: 'end',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      isAutoRefreshOnly: {
        defaultValue: null,
        description: 'Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.',
        name: 'isAutoRefreshOnly',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isPaused: {
        defaultValue: null,
        description: '',
        name: 'isPaused',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      locale: {
        defaultValue: null,
        description: 'Used to localize e.g. month names, passed to `moment`',
        name: 'locale',
        parent: undefined,
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      onRefresh: {
        defaultValue: null,
        description: 'Callback for when the refresh interval is fired.\nEuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied\nIf a promise is returned, the next refresh interval will not start until the promise has resolved.\nIf the promise rejects the refresh interval will stop and the error thrown',
        name: 'onRefresh',
        parent: undefined,
        required: false,
        type: {
          name: '(props: OnRefreshProps) => void'
        }
      },
      onRefreshChange: {
        defaultValue: null,
        description: 'Callback for when the refresh interval changes.\nSupply onRefreshChange to show refresh interval inputs in quick select popover',
        name: 'onRefreshChange',
        parent: undefined,
        required: false,
        type: {
          name: 'ApplyRefreshInterval'
        }
      },
      onTimeChange: {
        defaultValue: null,
        description: 'Callback for when the time changes.',
        name: 'onTimeChange',
        parent: undefined,
        required: true,
        type: {
          name: '(props: OnTimeChangeProps) => void'
        }
      },
      recentlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'recentlyUsedRanges',
        parent: undefined,
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      },
      refreshInterval: {
        defaultValue: null,
        description: 'Refresh interval in milliseconds',
        name: 'refreshInterval',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      showUpdateButton: {
        defaultValue: null,
        description: 'Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.',
        name: 'showUpdateButton',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      start: {
        defaultValue: null,
        description: '',
        name: 'start',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      timeFormat: {
        defaultValue: null,
        description: 'Specifies the formatted used when displaying times',
        name: 'timeFormat',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiSuperUpdateButton.__docgenInfo = {
    description: '',
    displayName: 'EuiSuperUpdateButton',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      needsUpdate: {
        defaultValue: null,
        description: '',
        name: 'needsUpdate',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: true,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      toolTipProps: {
        defaultValue: null,
        description: 'Passes props to `EuiToolTip`',
        name: 'toolTipProps',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: false,
        type: {
          name: 'Props'
        }
      },
      showTooltip: {
        defaultValue: null,
        description: 'Show the "Click to apply" tooltip',
        name: 'showTooltip',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/super_update_button.tsx',
          name: 'EuiSuperUpdateButtonProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiAbsoluteTab.__docgenInfo = {
    description: '',
    displayName: 'EuiAbsoluteTab',
    methods: [],
    props: {
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      timeFormat: {
        defaultValue: null,
        description: '',
        name: 'timeFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      locale: {
        defaultValue: null,
        description: '',
        name: 'locale',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: true,
        type: {
          name: '(date: string, event?: any) => void'
        }
      },
      roundUp: {
        defaultValue: null,
        description: '',
        name: 'roundUp',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"end" | "start"',
          value: [{
            value: '"end"'
          }, {
            value: '"start"'
          }]
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.tsx',
          name: 'EuiAbsoluteTabProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiDatePopoverButton.__docgenInfo = {
    description: '',
    displayName: 'EuiDatePopoverButton',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonProps: {
        defaultValue: null,
        description: '',
        name: 'buttonProps',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'ButtonHTMLAttributes<HTMLButtonElement>'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isOpen: {
        defaultValue: null,
        description: '',
        name: 'isOpen',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      needsUpdating: {
        defaultValue: null,
        description: '',
        name: 'needsUpdating',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      locale: {
        defaultValue: null,
        description: '',
        name: 'locale',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: '(date: string, event?: any) => void'
        }
      },
      onPopoverClose: {
        defaultValue: null,
        description: '',
        name: 'onPopoverClose',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      onPopoverToggle: {
        defaultValue: null,
        description: '',
        name: 'onPopoverToggle',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"end" | "start"',
          value: [{
            value: '"end"'
          }, {
            value: '"start"'
          }]
        }
      },
      roundUp: {
        defaultValue: null,
        description: '',
        name: 'roundUp',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      timeFormat: {
        defaultValue: null,
        description: '',
        name: 'timeFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.tsx',
          name: 'EuiDatePopoverButtonProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiDatePopoverContent.__docgenInfo = {
    description: '',
    displayName: 'EuiDatePopoverContent',
    methods: [],
    props: {
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: true,
        type: {
          name: '(date: string, event?: any) => void'
        }
      },
      roundUp: {
        defaultValue: null,
        description: '',
        name: 'roundUp',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      timeFormat: {
        defaultValue: null,
        description: '',
        name: 'timeFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      locale: {
        defaultValue: null,
        description: '',
        name: 'locale',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"end" | "start"',
          value: [{
            value: '"end"'
          }, {
            value: '"start"'
          }]
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.tsx',
          name: 'EuiDatePopoverContentProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiRelativeTab.__docgenInfo = {
    description: '',
    displayName: 'EuiRelativeTab',
    methods: [],
    props: {
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/relative_tab.tsx',
          name: 'EuiRelativeTabProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      locale: {
        defaultValue: null,
        description: '',
        name: 'locale',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/relative_tab.tsx',
          name: 'EuiRelativeTabProps'
        },
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/relative_tab.tsx',
          name: 'EuiRelativeTabProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/relative_tab.tsx',
          name: 'EuiRelativeTabProps'
        },
        required: true,
        type: {
          name: '(date: string, event?: any) => void'
        }
      },
      roundUp: {
        defaultValue: null,
        description: '',
        name: 'roundUp',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/relative_tab.tsx',
          name: 'EuiRelativeTabProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/date_popover/relative_tab.tsx',
          name: 'EuiRelativeTabProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"end" | "start"',
          value: [{
            value: '"end"'
          }, {
            value: '"start"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiCommonlyUsedTimeRanges.__docgenInfo = {
    description: '',
    displayName: 'EuiCommonlyUsedTimeRanges',
    methods: [],
    props: {
      applyTime: {
        defaultValue: null,
        description: '',
        name: 'applyTime',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/commonly_used_time_ranges.tsx',
          name: 'EuiCommonlyUsedTimeRangesProps'
        },
        required: true,
        type: {
          name: 'ApplyTime'
        }
      },
      commonlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'commonlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/commonly_used_time_ranges.tsx',
          name: 'EuiCommonlyUsedTimeRangesProps'
        },
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiQuickSelectPopover.__docgenInfo = {
    description: '',
    displayName: 'EuiQuickSelectPopover',
    methods: [],
    props: {
      applyRefreshInterval: {
        defaultValue: null,
        description: '',
        name: 'applyRefreshInterval',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: false,
        type: {
          name: 'ApplyRefreshInterval'
        }
      },
      applyTime: {
        defaultValue: null,
        description: '',
        name: 'applyTime',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'ApplyTime'
        }
      },
      commonlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'commonlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      },
      customQuickSelectPanels: {
        defaultValue: null,
        description: '',
        name: 'customQuickSelectPanels',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: false,
        type: {
          name: 'QuickSelectPanel[]'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      end: {
        defaultValue: null,
        description: '',
        name: 'end',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isAutoRefreshOnly: {
        defaultValue: null,
        description: '',
        name: 'isAutoRefreshOnly',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isPaused: {
        defaultValue: null,
        description: '',
        name: 'isPaused',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      recentlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'recentlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      },
      refreshInterval: {
        defaultValue: null,
        description: '',
        name: 'refreshInterval',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      start: {
        defaultValue: null,
        description: '',
        name: 'start',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.tsx',
          name: 'EuiQuickSelectPopoverProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiQuickSelect.__docgenInfo = {
    description: '',
    displayName: 'EuiQuickSelect',
    methods: [],
    props: {
      applyTime: {
        defaultValue: null,
        description: '',
        name: 'applyTime',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select.tsx',
          name: 'EuiQuickSelectProps'
        },
        required: true,
        type: {
          name: 'ApplyTime'
        }
      },
      start: {
        defaultValue: null,
        description: '',
        name: 'start',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select.tsx',
          name: 'EuiQuickSelectProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      end: {
        defaultValue: null,
        description: '',
        name: 'end',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select.tsx',
          name: 'EuiQuickSelectProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      prevQuickSelect: {
        defaultValue: null,
        description: '',
        name: 'prevQuickSelect',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select.tsx',
          name: 'EuiQuickSelectProps'
        },
        required: false,
        type: {
          name: 'QuickSelect'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiRecentlyUsed.__docgenInfo = {
    description: '',
    displayName: 'EuiRecentlyUsed',
    methods: [],
    props: {
      applyTime: {
        defaultValue: null,
        description: '',
        name: 'applyTime',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: true,
        type: {
          name: 'ApplyTime'
        }
      },
      commonlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'commonlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      recentlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'recentlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: false,
        type: {
          name: 'DurationRange[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiRefreshInterval.__docgenInfo = {
    description: '',
    displayName: 'EuiRefreshInterval',
    methods: [],
    props: {
      applyRefreshInterval: {
        defaultValue: null,
        description: '',
        name: 'applyRefreshInterval',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/refresh_interval.tsx',
          name: 'EuiRefreshIntervalProps'
        },
        required: false,
        type: {
          name: 'ApplyRefreshInterval'
        }
      },
      isPaused: {
        defaultValue: null,
        description: '',
        name: 'isPaused',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/refresh_interval.tsx',
          name: 'EuiRefreshIntervalProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      refreshInterval: {
        defaultValue: null,
        description: '',
        name: 'refreshInterval',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/refresh_interval.tsx',
          name: 'EuiRefreshIntervalProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}