"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDraggable = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactBeautifulDnd = require("react-beautiful-dnd");

var _classnames = _interopRequireDefault(require("classnames"));

var _droppable = require("./droppable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var spacingToClassNameMap = {
  none: null,
  s: 'euiDraggable--s',
  m: 'euiDraggable--m',
  l: 'euiDraggable--l'
};

var EuiDraggable = function EuiDraggable(_ref) {
  var _ref$customDragHandle = _ref.customDragHandle,
      customDragHandle = _ref$customDragHandle === void 0 ? false : _ref$customDragHandle,
      draggableId = _ref.draggableId,
      _ref$isDragDisabled = _ref.isDragDisabled,
      isDragDisabled = _ref$isDragDisabled === void 0 ? false : _ref$isDragDisabled,
      _ref$isRemovable = _ref.isRemovable,
      isRemovable = _ref$isRemovable === void 0 ? false : _ref$isRemovable,
      index = _ref.index,
      children = _ref.children,
      className = _ref.className,
      _ref$spacing = _ref.spacing,
      spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
      style = _ref.style,
      _ref$dataTestSubj = _ref['data-test-subj'],
      dataTestSubj = _ref$dataTestSubj === void 0 ? 'draggable' : _ref$dataTestSubj,
      rest = _objectWithoutProperties(_ref, ["customDragHandle", "draggableId", "isDragDisabled", "isRemovable", "index", "children", "className", "spacing", "style", "data-test-subj"]);

  var _useContext = (0, _react.useContext)(_droppable.EuiDroppableContext),
      cloneItems = _useContext.cloneItems;

  return _react.default.createElement(_reactBeautifulDnd.Draggable, _extends({
    draggableId: draggableId,
    index: index,
    isDragDisabled: isDragDisabled
  }, rest), function (provided, snapshot, rubric) {
    var classes = (0, _classnames.default)('euiDraggable', {
      'euiDraggable--hasClone': cloneItems,
      'euiDraggable--hasCustomDragHandle': customDragHandle,
      'euiDraggable--isDragging': snapshot.isDragging,
      'euiDraggable--withoutDropAnimation': isRemovable
    }, spacingToClassNameMap[spacing], className);
    var childClasses = (0, _classnames.default)('euiDraggable__item', {
      'euiDraggable__item--hasCustomDragHandle': customDragHandle,
      'euiDraggable__item--isDisabled': isDragDisabled,
      'euiDraggable__item--isDragging': snapshot.isDragging,
      'euiDraggable__item--isDropAnimating': snapshot.isDropAnimating
    });
    var DraggableElement = typeof children === 'function' ? children(provided, snapshot, rubric) : children; // as specified by `DraggableProps`

    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("div", _extends({}, provided.draggableProps, !customDragHandle ? provided.dragHandleProps : {}, {
      ref: provided.innerRef,
      "data-test-subj": dataTestSubj,
      className: classes,
      style: _objectSpread({}, style, {}, provided.draggableProps.style)
    }), (0, _react.cloneElement)(DraggableElement, {
      className: (0, _classnames.default)(DraggableElement.props.className, childClasses)
    })), cloneItems && snapshot.isDragging && _react.default.createElement("div", {
      className: (0, _classnames.default)(classes, 'euiDraggable--clone')
    }, DraggableElement));
  });
};

exports.EuiDraggable = EuiDraggable;
EuiDraggable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.any.isRequired]).isRequired,
  className: _propTypes.default.string,

  /**
     * Whether the `children` will provide and set up its own drag handle
     */
  customDragHandle: _propTypes.default.bool,

  /**
     * Whether the item is currently in a position to be removed
     */
  isRemovable: _propTypes.default.bool,

  /**
     * Adds padding to the draggable item
     */
  spacing: _propTypes.default.oneOf(["none", "s", "m", "l"]),
  style: _propTypes.default.any,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiDraggable.__docgenInfo = {
    description: '',
    displayName: 'EuiDraggable',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement | DraggableChildrenFn'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      customDragHandle: {
        defaultValue: {
          value: 'false'
        },
        description: 'Whether the `children` will provide and set up its own drag handle',
        name: 'customDragHandle',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isRemovable: {
        defaultValue: {
          value: 'false'
        },
        description: 'Whether the item is currently in a position to be removed',
        name: 'isRemovable',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      spacing: {
        defaultValue: {
          value: 'none'
        },
        description: 'Adds padding to the draggable item',
        name: 'spacing',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      index: {
        defaultValue: null,
        description: '',
        name: 'index',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      draggableId: {
        defaultValue: null,
        description: '',
        name: 'draggableId',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isDragDisabled: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'isDragDisabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disableInteractiveElementBlocking: {
        defaultValue: null,
        description: '',
        name: 'disableInteractiveElementBlocking',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      shouldRespectForcePress: {
        defaultValue: null,
        description: '',
        name: 'shouldRespectForcePress',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}