"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFacetButton", {
  enumerable: true,
  get: function get() {
    return _facet_button.EuiFacetButton;
  }
});
Object.defineProperty(exports, "EuiFacetGroup", {
  enumerable: true,
  get: function get() {
    return _facet_group.EuiFacetGroup;
  }
});

var _facet_button = require("./facet_button");

var _facet_group = require("./facet_group");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiFacetButton.__docgenInfo = {
    description: '',
    displayName: 'EuiFacetButton',
    methods: [],
    props: {
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLButtonElement) => void'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      icon: {
        defaultValue: null,
        description: 'Any node, but preferrably a `EuiIcon` or `EuiAvatar`',
        name: 'icon',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Adds/swaps for loading spinner & disables',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Changes visual of button to indicate it\'s currently selected',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      quantity: {
        defaultValue: null,
        description: 'Adds a notification indicator for displaying the quantity provided',
        name: 'quantity',
        parent: {
          fileName: 'eui/src/components/facet/facet_button.tsx',
          name: 'EuiFacetButtonProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFacetGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiFacetGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      layout: {
        defaultValue: null,
        description: 'Vertically in a column, or horizontally in one wrapping line',
        name: 'layout',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Distance between facet buttons.\nHorizontal layout always adds more distance horizontally between buttons.',
        name: 'gutterSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}