"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFlexGroup", {
  enumerable: true,
  get: function get() {
    return _flex_group.EuiFlexGroup;
  }
});
Object.defineProperty(exports, "EuiFlexGrid", {
  enumerable: true,
  get: function get() {
    return _flex_grid.EuiFlexGrid;
  }
});
Object.defineProperty(exports, "EuiFlexItem", {
  enumerable: true,
  get: function get() {
    return _flex_item.EuiFlexItem;
  }
});

var _flex_group = require("./flex_group");

var _flex_grid = require("./flex_grid");

var _flex_item = require("./flex_item");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiFlexGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      alignItems: {
        defaultValue: null,
        description: '',
        name: 'alignItems',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"baseline" | "center" | "stretch" | "flexStart" | "flexEnd"',
          value: [{
            value: '"baseline"'
          }, {
            value: '"center"'
          }, {
            value: '"stretch"'
          }, {
            value: '"flexStart"'
          }, {
            value: '"flexEnd"'
          }]
        }
      },
      component: {
        defaultValue: null,
        description: '',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'FlexGroupComponentType',
          value: [{
            value: '"span"'
          }, {
            value: '"div"'
          }]
        }
      },
      direction: {
        defaultValue: null,
        description: '',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"column" | "row" | "rowReverse" | "columnReverse"',
          value: [{
            value: '"column"'
          }, {
            value: '"row"'
          }, {
            value: '"rowReverse"'
          }, {
            value: '"columnReverse"'
          }]
        }
      },
      gutterSize: {
        defaultValue: null,
        description: '',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "xs" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      justifyContent: {
        defaultValue: null,
        description: '',
        name: 'justifyContent',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"center" | "flexStart" | "flexEnd" | "spaceBetween" | "spaceAround" | "spaceEvenly"',
          value: [{
            value: '"center"'
          }, {
            value: '"flexStart"'
          }, {
            value: '"flexEnd"'
          }, {
            value: '"spaceBetween"'
          }, {
            value: '"spaceAround"'
          }, {
            value: '"spaceEvenly"'
          }]
        }
      },
      responsive: {
        defaultValue: null,
        description: '',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      wrap: {
        defaultValue: null,
        description: '',
        name: 'wrap',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFlexGrid.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexGrid',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      columns: {
        defaultValue: null,
        description: 'Number of columns `1-4`, pass `0` for normal display',
        name: 'columns',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'FlexGridColumns'
        }
      },
      direction: {
        defaultValue: null,
        description: 'Flex layouts default to left-right then top-down (`row`).\nChange this prop to `column` to create a top-down then left-right display.\nOnly works with column count of `1-4`.',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"column" | "row"',
          value: [{
            value: '"column"'
          }, {
            value: '"row"'
          }]
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Space between flex items',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      responsive: {
        defaultValue: null,
        description: 'Force each item to be display block on smaller screens',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      component: {
        defaultValue: null,
        description: 'The tag to render',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'any HTML Element',
          raw: '"symbol" | "object" | "slot" | "style" | "title" | "form" | "text" | "s" | "filter" | "image" | "link" | "menu" | "stop" | "button" | "time" | "dialog" | "clipPath" | "mask" | "path" | ... 155 more ... | "view"',
          value: [{
            value: '"symbol"'
          }, {
            value: '"object"'
          }, {
            value: '"slot"'
          }, {
            value: '"style"'
          }, {
            value: '"title"'
          }, {
            value: '"form"'
          }, {
            value: '"text"'
          }, {
            value: '"s"'
          }, {
            value: '"filter"'
          }, {
            value: '"image"'
          }, {
            value: '"link"'
          }, {
            value: '"menu"'
          }, {
            value: '"stop"'
          }, {
            value: '"button"'
          }, {
            value: '"time"'
          }, {
            value: '"dialog"'
          }, {
            value: '"clipPath"'
          }, {
            value: '"mask"'
          }, {
            value: '"path"'
          }, {
            value: '"label"'
          }, {
            value: '"summary"'
          }, {
            value: '"legend"'
          }, {
            value: '"h1"'
          }, {
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"p"'
          }, {
            value: '"footer"'
          }, {
            value: '"span"'
          }, {
            value: '"pattern"'
          }, {
            value: '"pre"'
          }, {
            value: '"a"'
          }, {
            value: '"abbr"'
          }, {
            value: '"address"'
          }, {
            value: '"area"'
          }, {
            value: '"article"'
          }, {
            value: '"aside"'
          }, {
            value: '"audio"'
          }, {
            value: '"b"'
          }, {
            value: '"base"'
          }, {
            value: '"bdi"'
          }, {
            value: '"bdo"'
          }, {
            value: '"big"'
          }, {
            value: '"blockquote"'
          }, {
            value: '"body"'
          }, {
            value: '"br"'
          }, {
            value: '"canvas"'
          }, {
            value: '"caption"'
          }, {
            value: '"cite"'
          }, {
            value: '"code"'
          }, {
            value: '"col"'
          }, {
            value: '"colgroup"'
          }, {
            value: '"data"'
          }, {
            value: '"datalist"'
          }, {
            value: '"dd"'
          }, {
            value: '"del"'
          }, {
            value: '"details"'
          }, {
            value: '"dfn"'
          }, {
            value: '"div"'
          }, {
            value: '"dl"'
          }, {
            value: '"dt"'
          }, {
            value: '"em"'
          }, {
            value: '"embed"'
          }, {
            value: '"fieldset"'
          }, {
            value: '"figcaption"'
          }, {
            value: '"figure"'
          }, {
            value: '"head"'
          }, {
            value: '"header"'
          }, {
            value: '"hgroup"'
          }, {
            value: '"hr"'
          }, {
            value: '"html"'
          }, {
            value: '"i"'
          }, {
            value: '"iframe"'
          }, {
            value: '"img"'
          }, {
            value: '"input"'
          }, {
            value: '"ins"'
          }, {
            value: '"kbd"'
          }, {
            value: '"keygen"'
          }, {
            value: '"li"'
          }, {
            value: '"main"'
          }, {
            value: '"map"'
          }, {
            value: '"mark"'
          }, {
            value: '"menuitem"'
          }, {
            value: '"meta"'
          }, {
            value: '"meter"'
          }, {
            value: '"nav"'
          }, {
            value: '"noindex"'
          }, {
            value: '"noscript"'
          }, {
            value: '"ol"'
          }, {
            value: '"optgroup"'
          }, {
            value: '"option"'
          }, {
            value: '"output"'
          }, {
            value: '"param"'
          }, {
            value: '"picture"'
          }, {
            value: '"progress"'
          }, {
            value: '"q"'
          }, {
            value: '"rp"'
          }, {
            value: '"rt"'
          }, {
            value: '"ruby"'
          }, {
            value: '"samp"'
          }, {
            value: '"script"'
          }, {
            value: '"section"'
          }, {
            value: '"select"'
          }, {
            value: '"small"'
          }, {
            value: '"source"'
          }, {
            value: '"strong"'
          }, {
            value: '"sub"'
          }, {
            value: '"sup"'
          }, {
            value: '"table"'
          }, {
            value: '"template"'
          }, {
            value: '"tbody"'
          }, {
            value: '"td"'
          }, {
            value: '"textarea"'
          }, {
            value: '"tfoot"'
          }, {
            value: '"th"'
          }, {
            value: '"thead"'
          }, {
            value: '"tr"'
          }, {
            value: '"track"'
          }, {
            value: '"u"'
          }, {
            value: '"ul"'
          }, {
            value: '"var"'
          }, {
            value: '"video"'
          }, {
            value: '"wbr"'
          }, {
            value: '"webview"'
          }, {
            value: '"svg"'
          }, {
            value: '"animate"'
          }, {
            value: '"animateMotion"'
          }, {
            value: '"animateTransform"'
          }, {
            value: '"circle"'
          }, {
            value: '"defs"'
          }, {
            value: '"desc"'
          }, {
            value: '"ellipse"'
          }, {
            value: '"feBlend"'
          }, {
            value: '"feColorMatrix"'
          }, {
            value: '"feComponentTransfer"'
          }, {
            value: '"feComposite"'
          }, {
            value: '"feConvolveMatrix"'
          }, {
            value: '"feDiffuseLighting"'
          }, {
            value: '"feDisplacementMap"'
          }, {
            value: '"feDistantLight"'
          }, {
            value: '"feDropShadow"'
          }, {
            value: '"feFlood"'
          }, {
            value: '"feFuncA"'
          }, {
            value: '"feFuncB"'
          }, {
            value: '"feFuncG"'
          }, {
            value: '"feFuncR"'
          }, {
            value: '"feGaussianBlur"'
          }, {
            value: '"feImage"'
          }, {
            value: '"feMerge"'
          }, {
            value: '"feMergeNode"'
          }, {
            value: '"feMorphology"'
          }, {
            value: '"feOffset"'
          }, {
            value: '"fePointLight"'
          }, {
            value: '"feSpecularLighting"'
          }, {
            value: '"feSpotLight"'
          }, {
            value: '"feTile"'
          }, {
            value: '"feTurbulence"'
          }, {
            value: '"foreignObject"'
          }, {
            value: '"g"'
          }, {
            value: '"line"'
          }, {
            value: '"linearGradient"'
          }, {
            value: '"marker"'
          }, {
            value: '"metadata"'
          }, {
            value: '"mpath"'
          }, {
            value: '"polygon"'
          }, {
            value: '"polyline"'
          }, {
            value: '"radialGradient"'
          }, {
            value: '"rect"'
          }, {
            value: '"switch"'
          }, {
            value: '"textPath"'
          }, {
            value: '"tspan"'
          }, {
            value: '"use"'
          }, {
            value: '"view"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFlexItem.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      grow: {
        defaultValue: null,
        description: '',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/flex/flex_item.tsx',
          name: 'EuiFlexItemProps'
        },
        required: false,
        type: {
          name: 'FlexItemGrowSize'
        }
      },
      component: {
        defaultValue: null,
        description: '',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_item.tsx',
          name: 'EuiFlexItemProps'
        },
        required: false,
        type: {
          name: 'any HTML Element',
          raw: '"symbol" | "object" | "slot" | "style" | "title" | "form" | "text" | "s" | "filter" | "image" | "link" | "menu" | "stop" | "button" | "time" | "dialog" | "clipPath" | "mask" | "path" | ... 155 more ... | "view"',
          value: [{
            value: '"symbol"'
          }, {
            value: '"object"'
          }, {
            value: '"slot"'
          }, {
            value: '"style"'
          }, {
            value: '"title"'
          }, {
            value: '"form"'
          }, {
            value: '"text"'
          }, {
            value: '"s"'
          }, {
            value: '"filter"'
          }, {
            value: '"image"'
          }, {
            value: '"link"'
          }, {
            value: '"menu"'
          }, {
            value: '"stop"'
          }, {
            value: '"button"'
          }, {
            value: '"time"'
          }, {
            value: '"dialog"'
          }, {
            value: '"clipPath"'
          }, {
            value: '"mask"'
          }, {
            value: '"path"'
          }, {
            value: '"label"'
          }, {
            value: '"summary"'
          }, {
            value: '"legend"'
          }, {
            value: '"h1"'
          }, {
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"p"'
          }, {
            value: '"footer"'
          }, {
            value: '"span"'
          }, {
            value: '"pattern"'
          }, {
            value: '"pre"'
          }, {
            value: '"a"'
          }, {
            value: '"abbr"'
          }, {
            value: '"address"'
          }, {
            value: '"area"'
          }, {
            value: '"article"'
          }, {
            value: '"aside"'
          }, {
            value: '"audio"'
          }, {
            value: '"b"'
          }, {
            value: '"base"'
          }, {
            value: '"bdi"'
          }, {
            value: '"bdo"'
          }, {
            value: '"big"'
          }, {
            value: '"blockquote"'
          }, {
            value: '"body"'
          }, {
            value: '"br"'
          }, {
            value: '"canvas"'
          }, {
            value: '"caption"'
          }, {
            value: '"cite"'
          }, {
            value: '"code"'
          }, {
            value: '"col"'
          }, {
            value: '"colgroup"'
          }, {
            value: '"data"'
          }, {
            value: '"datalist"'
          }, {
            value: '"dd"'
          }, {
            value: '"del"'
          }, {
            value: '"details"'
          }, {
            value: '"dfn"'
          }, {
            value: '"div"'
          }, {
            value: '"dl"'
          }, {
            value: '"dt"'
          }, {
            value: '"em"'
          }, {
            value: '"embed"'
          }, {
            value: '"fieldset"'
          }, {
            value: '"figcaption"'
          }, {
            value: '"figure"'
          }, {
            value: '"head"'
          }, {
            value: '"header"'
          }, {
            value: '"hgroup"'
          }, {
            value: '"hr"'
          }, {
            value: '"html"'
          }, {
            value: '"i"'
          }, {
            value: '"iframe"'
          }, {
            value: '"img"'
          }, {
            value: '"input"'
          }, {
            value: '"ins"'
          }, {
            value: '"kbd"'
          }, {
            value: '"keygen"'
          }, {
            value: '"li"'
          }, {
            value: '"main"'
          }, {
            value: '"map"'
          }, {
            value: '"mark"'
          }, {
            value: '"menuitem"'
          }, {
            value: '"meta"'
          }, {
            value: '"meter"'
          }, {
            value: '"nav"'
          }, {
            value: '"noindex"'
          }, {
            value: '"noscript"'
          }, {
            value: '"ol"'
          }, {
            value: '"optgroup"'
          }, {
            value: '"option"'
          }, {
            value: '"output"'
          }, {
            value: '"param"'
          }, {
            value: '"picture"'
          }, {
            value: '"progress"'
          }, {
            value: '"q"'
          }, {
            value: '"rp"'
          }, {
            value: '"rt"'
          }, {
            value: '"ruby"'
          }, {
            value: '"samp"'
          }, {
            value: '"script"'
          }, {
            value: '"section"'
          }, {
            value: '"select"'
          }, {
            value: '"small"'
          }, {
            value: '"source"'
          }, {
            value: '"strong"'
          }, {
            value: '"sub"'
          }, {
            value: '"sup"'
          }, {
            value: '"table"'
          }, {
            value: '"template"'
          }, {
            value: '"tbody"'
          }, {
            value: '"td"'
          }, {
            value: '"textarea"'
          }, {
            value: '"tfoot"'
          }, {
            value: '"th"'
          }, {
            value: '"thead"'
          }, {
            value: '"tr"'
          }, {
            value: '"track"'
          }, {
            value: '"u"'
          }, {
            value: '"ul"'
          }, {
            value: '"var"'
          }, {
            value: '"video"'
          }, {
            value: '"wbr"'
          }, {
            value: '"webview"'
          }, {
            value: '"svg"'
          }, {
            value: '"animate"'
          }, {
            value: '"animateMotion"'
          }, {
            value: '"animateTransform"'
          }, {
            value: '"circle"'
          }, {
            value: '"defs"'
          }, {
            value: '"desc"'
          }, {
            value: '"ellipse"'
          }, {
            value: '"feBlend"'
          }, {
            value: '"feColorMatrix"'
          }, {
            value: '"feComponentTransfer"'
          }, {
            value: '"feComposite"'
          }, {
            value: '"feConvolveMatrix"'
          }, {
            value: '"feDiffuseLighting"'
          }, {
            value: '"feDisplacementMap"'
          }, {
            value: '"feDistantLight"'
          }, {
            value: '"feDropShadow"'
          }, {
            value: '"feFlood"'
          }, {
            value: '"feFuncA"'
          }, {
            value: '"feFuncB"'
          }, {
            value: '"feFuncG"'
          }, {
            value: '"feFuncR"'
          }, {
            value: '"feGaussianBlur"'
          }, {
            value: '"feImage"'
          }, {
            value: '"feMerge"'
          }, {
            value: '"feMergeNode"'
          }, {
            value: '"feMorphology"'
          }, {
            value: '"feOffset"'
          }, {
            value: '"fePointLight"'
          }, {
            value: '"feSpecularLighting"'
          }, {
            value: '"feSpotLight"'
          }, {
            value: '"feTile"'
          }, {
            value: '"feTurbulence"'
          }, {
            value: '"foreignObject"'
          }, {
            value: '"g"'
          }, {
            value: '"line"'
          }, {
            value: '"linearGradient"'
          }, {
            value: '"marker"'
          }, {
            value: '"metadata"'
          }, {
            value: '"mpath"'
          }, {
            value: '"polygon"'
          }, {
            value: '"polyline"'
          }, {
            value: '"radialGradient"'
          }, {
            value: '"rect"'
          }, {
            value: '"switch"'
          }, {
            value: '"textPath"'
          }, {
            value: '"tspan"'
          }, {
            value: '"use"'
          }, {
            value: '"view"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}