"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormControlLayoutDelimited = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _text = require("../../text");

var _form_control_layout = require("./form_control_layout");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiFormControlLayoutDelimited = function EuiFormControlLayoutDelimited(_ref) {
  var startControl = _ref.startControl,
      endControl = _ref.endControl,
      _ref$delimiter = _ref.delimiter,
      delimiter = _ref$delimiter === void 0 ? '→' : _ref$delimiter,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["startControl", "endControl", "delimiter", "className"]);

  var classes = (0, _classnames.default)('euiFormControlLayoutDelimited', className);
  return _react.default.createElement(_form_control_layout.EuiFormControlLayout, _extends({
    className: classes
  }, rest), addClassesToControl(startControl), _react.default.createElement(_text.EuiText, {
    className: "euiFormControlLayoutDelimited__delimeter",
    size: "s",
    color: "subdued"
  }, delimiter), addClassesToControl(endControl));
};

exports.EuiFormControlLayoutDelimited = EuiFormControlLayoutDelimited;
EuiFormControlLayoutDelimited.propTypes = {
  /**
     * Left side control
     */
  startControl: _propTypes.default.element.isRequired,

  /**
     * Right side control
     */
  endControl: _propTypes.default.element.isRequired,

  /**
     * The center content. Accepts a string to be wrapped in a subdued EuiText
     * or a single ReactElement
     */
  delimiter: _propTypes.default.node,
  className: _propTypes.default.string
};

function addClassesToControl(control) {
  return (0, _react.cloneElement)(control, {
    className: (0, _classnames.default)(control.props.className, 'euiFormControlLayoutDelimited__input')
  });
}

try {
  EuiFormControlLayoutDelimited.__docgenInfo = {
    description: '',
    displayName: 'EuiFormControlLayoutDelimited',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before children.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after children.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ComponentClass<{}, any> | FunctionComponent<{}> | (Pick<CommonProps & DisambiguateSet<Pick<ButtonHTMLAttributes<HTMLButtonElement>, "children" | ... 262 more ... | "value">, HTMLAttributes<...>> & HTMLAttributes<...> & { ...; }, "children" | ... 263 more ... | "value"> & { ...; }) | (Pick<...> & { ...; })'
        }
      },
      clear: {
        defaultValue: null,
        description: '',
        name: 'clear',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiFormControlLayoutClearButtonProps'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputId: {
        defaultValue: null,
        description: 'Connects the prepend and append labels to the input',
        name: 'inputId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      startControl: {
        defaultValue: null,
        description: 'Left side control',
        name: 'startControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      endControl: {
        defaultValue: null,
        description: 'Right side control',
        name: 'endControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      delimiter: {
        defaultValue: {
          value: '→'
        },
        description: 'The center content. Accepts a string to be wrapped in a subdued EuiText\nor a single ReactElement',
        name: 'delimiter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}