"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSuperSelect", {
  enumerable: true,
  get: function get() {
    return _super_select.EuiSuperSelect;
  }
});
Object.defineProperty(exports, "EuiSuperSelectControl", {
  enumerable: true,
  get: function get() {
    return _super_select_control.EuiSuperSelectControl;
  }
});

var _super_select = require("./super_select");

var _super_select_control = require("./super_select_control");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiSuperSelect.__docgenInfo = {
    description: '',
    displayName: 'EuiSuperSelect',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      options: {
        defaultValue: null,
        description: 'Pass an array of options that must at least include:\n`value`: storing unique value of item,\n`inputDisplay`: what shows inside the form input when selected\n`dropdownDisplay` (optional): what shows for the item in the dropdown',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiSuperSelectOption<T>[]'
        }
      },
      valueOfSelected: {
        defaultValue: null,
        description: '',
        name: 'valueOfSelected',
        parent: undefined,
        required: false,
        type: {
          name: 'T'
        }
      },
      itemClassName: {
        defaultValue: null,
        description: 'Classes for the context menu item',
        name: 'itemClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'You must pass an `onChange` function to handle the update of the value',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(value: T) => void'
        }
      },
      hasDividers: {
        defaultValue: null,
        description: 'Change to `true` if you want horizontal lines between options.\nThis is best used when options are multi-line.',
        name: 'hasDividers',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      itemLayoutAlign: {
        defaultValue: null,
        description: 'Change `EuiContextMenuItem` layout position of icon',
        name: 'itemLayoutAlign',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiContextMenuItemLayoutAlignment',
          value: [{
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"center"'
          }]
        }
      },
      popoverClassName: {
        defaultValue: null,
        description: 'Applied to the outermost wrapper (popover)',
        name: 'popoverClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isOpen: {
        defaultValue: null,
        description: 'Controls whether the options are shown. Default: false',
        name: 'isOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  __type.__docgenInfo = {
    description: '',
    displayName: '__type',
    methods: [],
    props: {
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'T'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'EuiSuperSelectOption<T>[]'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}