"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiI18n = useEuiI18n;
exports.EuiI18n = void 0;

var _react = _interopRequireWildcard(require("react"));

var _context = require("../context");

var _context2 = require("../context/context");

var _i18n_util = require("./i18n_util");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function errorOnMissingValues(token) {
  throw new Error("I18n mapping for token \"".concat(token, "\" is a formatting function but no values were provided."));
}

function lookupToken(token, i18nMapping, valueDefault, i18nMappingFunc, values) {
  var renderable = i18nMapping && i18nMapping[token] || valueDefault;

  if (typeof renderable === 'function') {
    if (values === undefined) {
      return errorOnMissingValues(token);
    } // @ts-ignore TypeScript complains that `DEFAULT` doesn't have a call signature but we verified `renderable` is a function


    return renderable(values);
  } else if (values === undefined || typeof renderable !== 'string') {
    if (i18nMappingFunc && typeof valueDefault === 'string') {
      renderable = i18nMappingFunc(valueDefault);
    } // there's a hole in the typings here as there is no guarantee that i18nMappingFunc
    // returned the same type of the default value, but we need to keep that assumption


    return renderable;
  }

  var children = (0, _i18n_util.processStringToChildren)(renderable, values, i18nMappingFunc);

  if (typeof children === 'string') {
    // likewise, `processStringToChildren` returns a string or ReactChild[] depending on
    // the type of `values`, so we will make the assumption that the default value is correct.
    return children;
  }

  var Component = function Component() {
    return _react.default.createElement(_react.Fragment, null, children);
  }; // same reasons as above, we can't promise the transforms match the default's type


  return _react.default.createElement(Component, values);
}

function isI18nTokensShape(x) {
  return x.tokens != null;
} // Must use the generics <T extends {}>
// If instead typed with React.FunctionComponent there isn't feedback given back to the dev
// when using a `values` object with a renderer callback.


var EuiI18n = function EuiI18n(props) {
  return _react.default.createElement(_context.EuiI18nConsumer, null, function (i18nConfig) {
    var mapping = i18nConfig.mapping,
        mappingFunc = i18nConfig.mappingFunc;

    if (isI18nTokensShape(props)) {
      return props.children(props.tokens.map(function (token, idx) {
        return lookupToken(token, mapping, props.defaults[idx], mappingFunc);
      }));
    }

    var tokenValue = lookupToken(props.token, mapping, props.default, mappingFunc, props.values);

    if (props.children) {
      return props.children(tokenValue);
    } else {
      return tokenValue;
    }
  });
}; // A single default could be a string, react child, or render function


exports.EuiI18n = EuiI18n;

function useEuiI18n() {
  var i18nConfig = (0, _react.useContext)(_context2.I18nContext);
  var mapping = i18nConfig.mapping,
      mappingFunc = i18nConfig.mappingFunc;

  for (var _len = arguments.length, props = new Array(_len), _key = 0; _key < _len; _key++) {
    props[_key] = arguments[_key];
  }

  if (typeof props[0] === 'string') {
    var _token = props[0],
        _defaultValue = props[1],
        _values = props[2];
    return lookupToken(_token, mapping, _defaultValue, mappingFunc, _values);
  } else {
    var _ref = props,
        _ref2 = _slicedToArray(_ref, 2),
        _tokens = _ref2[0],
        _defaultValues = _ref2[1];

    return _tokens.map(function (token, idx) {
      return lookupToken(token, mapping, _defaultValues[idx], mappingFunc);
    });
  }
}

try {
  EuiI18n.__docgenInfo = {
    description: '',
    displayName: 'EuiI18n',
    methods: [],
    props: {
      default: {
        defaultValue: null,
        description: '',
        name: 'default',
        parent: {
          fileName: 'eui/src/components/i18n/i18n.tsx',
          name: 'I18nTokenShape'
        },
        required: false,
        type: {
          name: 'DEFAULT'
        }
      },
      values: {
        defaultValue: null,
        description: '',
        name: 'values',
        parent: {
          fileName: 'eui/src/components/i18n/i18n.tsx',
          name: 'I18nTokenShape'
        },
        required: false,
        type: {
          name: 'T'
        }
      },
      token: {
        defaultValue: null,
        description: '',
        name: 'token',
        parent: {
          fileName: 'eui/src/components/i18n/i18n.tsx',
          name: 'I18nTokenShape'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      tokens: {
        defaultValue: null,
        description: '',
        name: 'tokens',
        parent: {
          fileName: 'eui/src/components/i18n/i18n.tsx',
          name: 'I18nTokensShape'
        },
        required: false,
        type: {
          name: 'string[]'
        }
      },
      defaults: {
        defaultValue: null,
        description: '',
        name: 'defaults',
        parent: {
          fileName: 'eui/src/components/i18n/i18n.tsx',
          name: 'I18nTokensShape'
        },
        required: false,
        type: {
          name: 'DEFAULTS'
        }
      }
    },
    extends: []
  };
} catch (e) {}