"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiIcon", {
  enumerable: true,
  get: function get() {
    return _icon.EuiIcon;
  }
});
Object.defineProperty(exports, "ICON_TYPES", {
  enumerable: true,
  get: function get() {
    return _icon.TYPES;
  }
});
Object.defineProperty(exports, "ICON_SIZES", {
  enumerable: true,
  get: function get() {
    return _icon.SIZES;
  }
});
Object.defineProperty(exports, "ICON_COLORS", {
  enumerable: true,
  get: function get() {
    return _icon.COLORS;
  }
});

var _icon = require("./icon");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiIcon.__docgenInfo = {
    description: '',
    displayName: 'EuiIcon',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '`Enum` is any of the named icons listed in the docs, `string` is usually a URL to an SVG file, and `elementType` is any React SVG component',
        name: 'type',
        parent: undefined,
        required: true,
        type: {
          name: 'IconType'
        }
      },
      color: {
        defaultValue: null,
        description: 'One of EUI\'s color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.\nNote that coloring only works if your SVG is removed of fill attributes.',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: null,
        description: 'Note that every size other than `original` assumes the provided SVG sits on a square viewbox.',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl" | "original" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"original"'
          }, {
            value: '"xxl"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'Descriptive title for naming the icon based on its use',
        name: 'title',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      titleId: {
        defaultValue: null,
        description: 'A unique identifier for the title element',
        name: 'titleId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onIconLoad: {
        defaultValue: null,
        description: 'Callback when the icon has been loaded & rendered',
        name: 'onIconLoad',
        parent: undefined,
        required: false,
        type: {
          name: '() => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}