"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderer = exports.parser = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _checkbox = require("../../form/checkbox");

var _markdown_context = require("../markdown_context");

var _accessibility = require("../../../services/accessibility");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var CheckboxParser = function CheckboxParser() {
  var Parser = this.Parser;
  var tokenizers = Parser.prototype.blockTokenizers;
  var methods = Parser.prototype.blockMethods;

  var tokenizeCheckbox = function tokenizeCheckbox(eat, value, silent) {
    /**
     * optional leading whitespace & single (dash or asterisk) mix
     * square brackets, optionally containing whitespace and `x`
     * optional whitespace
     * remainder of the line is consumed as the textbox label
     */
    var checkboxMatch = value.match(/^(\s*[-*]\s*)?\[([\sx]*)\](.+)/);
    if (checkboxMatch == null) return false;

    if (silent) {
      return true;
    }

    var _checkboxMatch = _slicedToArray(checkboxMatch, 4),
        match = _checkboxMatch[0],
        _checkboxMatch$ = _checkboxMatch[1],
        lead = _checkboxMatch$ === void 0 ? '' : _checkboxMatch$,
        checkboxStatus = _checkboxMatch[2],
        text = _checkboxMatch[3];

    var isChecked = checkboxStatus.indexOf('x') !== -1;
    var now = eat.now();
    var offset = match.length - text.length;
    now.column += offset;
    now.offset += offset;
    var children = this.tokenizeInline(text, now);
    return eat(match)({
      type: 'checkboxPlugin',
      lead: lead,
      label: text,
      isChecked: isChecked,
      children: children
    });
  };

  tokenizers.checkbox = tokenizeCheckbox;
  methods.splice(methods.indexOf('list'), 0, 'checkbox'); // Run it just before default `list` plugin to inject our own idea of checkboxes.
};

exports.parser = CheckboxParser;

var CheckboxMarkdownRenderer = function CheckboxMarkdownRenderer(_ref) {
  var position = _ref.position,
      lead = _ref.lead,
      label = _ref.label,
      isChecked = _ref.isChecked,
      children = _ref.children;

  var _useContext = (0, _react.useContext)(_markdown_context.EuiMarkdownContext),
      replaceNode = _useContext.replaceNode;

  return _react.default.createElement(_checkbox.EuiCheckbox, {
    id: (0, _accessibility.htmlIdGenerator)()(),
    checked: isChecked,
    label: children,
    onChange: function onChange() {
      replaceNode(position, "".concat(lead, "[").concat(isChecked ? ' ' : 'x', "]").concat(label));
    }
  });
};

exports.renderer = CheckboxMarkdownRenderer;
CheckboxMarkdownRenderer.propTypes = {
  type: _propTypes.default.oneOf(["checkboxPlugin"]).isRequired,
  lead: _propTypes.default.string.isRequired,
  label: _propTypes.default.string.isRequired,
  isChecked: _propTypes.default.bool.isRequired,
  position: _propTypes.default.shape({
    start: _propTypes.default.shape({
      line: _propTypes.default.number.isRequired,
      column: _propTypes.default.number.isRequired,
      offset: _propTypes.default.number.isRequired
    }).isRequired,
    end: _propTypes.default.shape({
      line: _propTypes.default.number.isRequired,
      column: _propTypes.default.number.isRequired,
      offset: _propTypes.default.number.isRequired
    }).isRequired
  }).isRequired
};

try {
  Attacher.__docgenInfo = {
    description: 'An attacher is the thing passed to `use`.\nIt configures the processor and in turn can receive options.\n\nAttachers can configure processors, such as by interacting with parsers and compilers, linking them to other processors, or by specifying how the syntax tree is handled.\n@param settings Configuration\n@typeParam S Plugin settings\n@typeParam P Processor settings\n@returns Optional Transformer.',
    displayName: 'Attacher',
    methods: [],
    props: {
      '0': {
        defaultValue: null,
        description: '',
        name: '0',
        parent: undefined,
        required: false,
        type: {
          name: 'Settings'
        }
      },
      length: {
        defaultValue: null,
        description: '',
        name: 'length',
        parent: undefined,
        required: true,
        type: {
          name: '0 | 1'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  CheckboxMarkdownRenderer.__docgenInfo = {
    description: '',
    displayName: 'CheckboxMarkdownRenderer',
    methods: [],
    props: {
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: '"checkboxPlugin"'
        }
      },
      lead: {
        defaultValue: null,
        description: '',
        name: 'lead',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isChecked: {
        defaultValue: null,
        description: '',
        name: 'isChecked',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiMarkdownAstNodePosition'
        }
      }
    },
    extends: []
  };
} catch (e) {}