"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPagination", {
  enumerable: true,
  get: function get() {
    return _pagination.EuiPagination;
  }
});
Object.defineProperty(exports, "EuiPaginationButton", {
  enumerable: true,
  get: function get() {
    return _pagination_button.EuiPaginationButton;
  }
});

var _pagination = require("./pagination");

var _pagination_button = require("./pagination_button");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiPagination.__docgenInfo = {
    description: '',
    displayName: 'EuiPagination',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      pageCount: {
        defaultValue: null,
        description: 'The total number of pages.',
        name: 'pageCount',
        parent: {
          fileName: 'eui/src/components/pagination/pagination.tsx',
          name: 'EuiPaginationProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      activePage: {
        defaultValue: null,
        description: 'The current page using a zero based index.\nSo if you set the activePage to 1, it will activate the second page.',
        name: 'activePage',
        parent: {
          fileName: 'eui/src/components/pagination/pagination.tsx',
          name: 'EuiPaginationProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      onPageClick: {
        defaultValue: null,
        description: '',
        name: 'onPageClick',
        parent: {
          fileName: 'eui/src/components/pagination/pagination.tsx',
          name: 'EuiPaginationProps'
        },
        required: false,
        type: {
          name: 'PageClickHandler'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'If true, will only show next/prev arrows instead of page numbers.',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/pagination/pagination.tsx',
          name: 'EuiPaginationProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPaginationButton.__docgenInfo = {
    description: '',
    displayName: 'EuiPaginationButton',
    methods: [],
    props: {
      color: {
        defaultValue: null,
        description: 'Any of our named colors',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiButtonEmptyColor',
          value: [{
            value: '"disabled"'
          }, {
            value: '"primary"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      flush: {
        defaultValue: null,
        description: 'Ensure the text of the button sits flush to the left or right side of its container',
        name: 'flush',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"submit" | "button"',
          value: [{
            value: '"submit"'
          }, {
            value: '"button"'
          }]
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: '(ref: HTMLAnchorElement | HTMLButtonElement) => void'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void) | (((event: MouseEvent<...>) => void) & ((event: MouseEvent<...>) => void)) | (((event: MouseEvent<...>) => void) & ((event: MouseEvent<...>) => void))'
        }
      },
      isActive: {
        defaultValue: null,
        description: '',
        name: 'isActive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isPlaceholder: {
        defaultValue: null,
        description: 'For ellipsis or other non-clickable buttons.',
        name: 'isPlaceholder',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hideOnMobile: {
        defaultValue: null,
        description: '',
        name: 'hideOnMobile',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      pageIndex: {
        defaultValue: null,
        description: '',
        name: 'pageIndex',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      totalPages: {
        defaultValue: null,
        description: '',
        name: 'totalPages',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}