"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPaginationButton = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _button = require("../button");

var _i18n = require("../i18n");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiPaginationButton = function EuiPaginationButton(_ref) {
  var className = _ref.className,
      isActive = _ref.isActive,
      isPlaceholder = _ref.isPlaceholder,
      hideOnMobile = _ref.hideOnMobile,
      pageIndex = _ref.pageIndex,
      totalPages = _ref.totalPages,
      rest = _objectWithoutProperties(_ref, ["className", "isActive", "isPlaceholder", "hideOnMobile", "pageIndex", "totalPages"]);

  var classes = (0, _classnames.default)('euiPaginationButton', className, {
    'euiPaginationButton-isActive': isActive,
    'euiPaginationButton-isPlaceholder': isPlaceholder,
    'euiPaginationButton--hideOnMobile': hideOnMobile
  });

  var props = _objectSpread({
    className: classes,
    size: 'xs',
    color: 'text',
    'data-test-subj': "pagination-button-".concat(pageIndex),
    isDisabled: isPlaceholder || isActive
  }, isActive && {
    'aria-current': true
  }, {}, rest['aria-controls'] && {
    href: "#".concat(rest['aria-controls'])
  }, {}, rest);

  var pageNumber = pageIndex + 1;
  return _react.default.createElement(_i18n.EuiI18n, {
    token: "euiPaginationButton.longPageString",
    default: "Page {page} of {totalPages}",
    values: {
      page: pageNumber,
      totalPages: totalPages
    }
  }, function (longPageString) {
    return _react.default.createElement(_i18n.EuiI18n, {
      token: "euiPaginationButton.shortPageString",
      default: "Page {page}",
      values: {
        page: pageNumber
      }
    }, function (shortPageString) {
      return _react.default.createElement(_button.EuiButtonEmpty, _extends({
        "aria-label": totalPages ? longPageString : shortPageString
      }, props), pageNumber);
    });
  });
};

exports.EuiPaginationButton = EuiPaginationButton;
EuiPaginationButton.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  isActive: _propTypes.default.bool,

  /**
     * For ellipsis or other non-clickable buttons.
     */

  /**
     * For ellipsis or other non-clickable buttons.
     */
  isPlaceholder: _propTypes.default.bool,
  hideOnMobile: _propTypes.default.bool,
  pageIndex: _propTypes.default.number.isRequired,
  totalPages: _propTypes.default.number
};

try {
  EuiPaginationButton.__docgenInfo = {
    description: '',
    displayName: 'EuiPaginationButton',
    methods: [],
    props: {
      color: {
        defaultValue: null,
        description: 'Any of our named colors',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiButtonEmptyColor',
          value: [{
            value: '"disabled"'
          }, {
            value: '"primary"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      flush: {
        defaultValue: null,
        description: 'Ensure the text of the button sits flush to the left or right side of its container',
        name: 'flush',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"submit" | "button"',
          value: [{
            value: '"submit"'
          }, {
            value: '"button"'
          }]
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: '(ref: HTMLAnchorElement | HTMLButtonElement) => void'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void) | (((event: MouseEvent<...>) => void) & ((event: MouseEvent<...>) => void)) | (((event: MouseEvent<...>) => void) & ((event: MouseEvent<...>) => void))'
        }
      },
      isActive: {
        defaultValue: null,
        description: '',
        name: 'isActive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isPlaceholder: {
        defaultValue: null,
        description: 'For ellipsis or other non-clickable buttons.',
        name: 'isPlaceholder',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hideOnMobile: {
        defaultValue: null,
        description: '',
        name: 'hideOnMobile',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      pageIndex: {
        defaultValue: null,
        description: '',
        name: 'pageIndex',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      totalPages: {
        defaultValue: null,
        description: '',
        name: 'totalPages',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}