"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPanel", {
  enumerable: true,
  get: function get() {
    return _panel.EuiPanel;
  }
});
Object.defineProperty(exports, "SIZES", {
  enumerable: true,
  get: function get() {
    return _panel.SIZES;
  }
});

var _panel = require("./panel");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiPanel.__docgenInfo = {
    description: '',
    displayName: 'EuiPanel',
    methods: [],
    props: {
      hasShadow: {
        defaultValue: null,
        description: 'If active, adds a deeper shadow to the panel',
        name: 'hasShadow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'Padding applied to the panel',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: 'When true the panel will grow to match `EuiFlexItem`',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      panelRef: {
        defaultValue: null,
        description: '',
        name: 'panelRef',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'Ref<HTMLDivElement>'
        }
      },
      betaBadgeLabel: {
        defaultValue: null,
        description: 'Add a badge to the panel to label it as "Beta" or other non-GA state',
        name: 'betaBadgeLabel',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      betaBadgeTooltipContent: {
        defaultValue: null,
        description: 'Add a description to the beta badge (will appear in a tooltip)',
        name: 'betaBadgeTooltipContent',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      betaBadgeTitle: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute otherwise the label will be used',
        name: 'betaBadgeTitle',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}