"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiProgress", {
  enumerable: true,
  get: function get() {
    return _progress.EuiProgress;
  }
});

var _progress = require("./progress");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiProgress.__docgenInfo = {
    description: '',
    displayName: 'EuiProgress',
    methods: [],
    props: {
      max: {
        defaultValue: null,
        description: '',
        name: 'max',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      valueText: {
        defaultValue: null,
        description: '',
        name: 'valueText',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      labelProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the determinate progress\'s label',
        name: 'labelProps',
        parent: undefined,
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement>'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"primary" | "secondary" | "danger" | "accent" | "subdued"',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"danger"'
          }, {
            value: '"accent"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Positions',
          value: [{
            value: '"static"'
          }, {
            value: '"fixed"'
          }, {
            value: '"absolute"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}