"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizableContainer = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _context = require("./context");

var _resizable_button = require("./resizable_button");

var _resizable_panel = require("./resizable_panel");

var _helpers = require("./helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var containerDirections = {
  vertical: 'vertical',
  horizontal: 'horizontal'
};
var initialState = {
  isDragging: false,
  currentResizerPos: -1,
  previousPanelId: null,
  nextPanelId: null,
  resizersSize: 0
};

var EuiResizableContainer = function EuiResizableContainer(_ref) {
  var _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
      children = _ref.children,
      className = _ref.className,
      onPanelWidthChange = _ref.onPanelWidthChange,
      rest = _objectWithoutProperties(_ref, ["direction", "children", "className", "onPanelWidthChange"]);

  var registryRef = (0, _react.useRef)(new _context.EuiResizablePanelRegistry());
  var containerRef = (0, _react.useRef)(null);

  var _useState = (0, _react.useState)(initialState),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var isHorizontal = direction === containerDirections.horizontal;
  var classes = (0, _classnames.default)('euiResizableContainer', {
    'euiResizableContainer--vertical': !isHorizontal,
    'euiResizableContainer--horizontal': isHorizontal
  }, className);

  var _useContainerCallback = (0, _helpers.useContainerCallbacks)({
    isHorizontal: isHorizontal,
    state: state,
    setState: setState,
    containerRef: containerRef,
    registryRef: registryRef,
    onPanelWidthChange: onPanelWidthChange
  }),
      onKeyDown = _useContainerCallback.onKeyDown,
      onMouseDown = _useContainerCallback.onMouseDown,
      onMouseMove = _useContainerCallback.onMouseMove;

  var EuiResizableButton = (0, _react.useCallback)((0, _resizable_button.euiResizableButtonWithControls)({
    onKeyDown: onKeyDown,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    isHorizontal: isHorizontal,
    registryRef: registryRef
  }), [onKeyDown, onMouseDown, isHorizontal, registryRef]);
  var EuiResizablePanel = (0, _react.useCallback)((0, _resizable_panel.euiResizablePanelWithControls)({
    isHorizontal: isHorizontal
  }), [isHorizontal]);
  var onMouseUp = (0, _react.useCallback)(function () {
    setState(initialState);
  }, []);
  return _react.default.createElement(_context.EuiResizablePanelContextProvider, {
    registry: registryRef.current
  }, _react.default.createElement("div", _extends({
    className: classes,
    ref: containerRef,
    onMouseMove: onMouseMove,
    onMouseUp: onMouseUp,
    onMouseLeave: onMouseUp,
    onTouchMove: onMouseMove,
    onTouchEnd: onMouseUp
  }, rest), children(EuiResizablePanel, EuiResizableButton)));
};

exports.EuiResizableContainer = EuiResizableContainer;
EuiResizableContainer.propTypes = {
  /**
     * Specify the container direction
     */
  direction: _propTypes.default.oneOf(["vertical", "horizontal"]),

  /**
     * Pure function which accepts Panel and Resizer components in arguments
     * and returns a component tree
     */
  children: _propTypes.default.func.isRequired,

  /**
     * Pure function which accepts an object where keys are IDs of panels, which sizes were changed,
     * and values are actual sizes in percents
     */
  onPanelWidthChange: _propTypes.default.func,
  style: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiResizableContainer.__docgenInfo = {
    description: '',
    displayName: 'EuiResizableContainer',
    methods: [],
    props: {
      direction: {
        defaultValue: {
          value: 'horizontal'
        },
        description: 'Specify the container direction',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      children: {
        defaultValue: null,
        description: 'Pure function which accepts Panel and Resizer components in arguments\nand returns a component tree',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: '(Panel: ComponentType<EuiResizablePanelProps>, Resizer: ComponentType<EuiResizableButtonProps>) => ReactNode'
        }
      },
      onPanelWidthChange: {
        defaultValue: null,
        description: 'Pure function which accepts an object where keys are IDs of panels, which sizes were changed,\nand values are actual sizes in percents',
        name: 'onPanelWidthChange',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: '({}: { [key: string]: number; }) => any'
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}