"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSearchBar", {
  enumerable: true,
  get: function get() {
    return _search_bar.EuiSearchBar;
  }
});
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function get() {
    return _search_bar.Query;
  }
});
Object.defineProperty(exports, "Ast", {
  enumerable: true,
  get: function get() {
    return _search_bar.Ast;
  }
});

var _search_bar = require("./search_bar");

require("./search_filters");

require("./filters/field_value_selection_filter");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiSearchBar.__docgenInfo = {
    description: '',
    displayName: 'EuiSearchBar',
    methods: [],
    props: {
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: '(args: ArgsWithQuery | ArgsWithError) => boolean | void'
        }
      },
      defaultQuery: {
        defaultValue: null,
        description: 'The initial query the bar will hold when first mounted',
        name: 'defaultQuery',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'QueryType'
        }
      },
      query: {
        defaultValue: null,
        description: 'If you wish to use the search bar as a controlled component, continuously pass the query\nvia this prop',
        name: 'query',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'QueryType'
        }
      },
      box: {
        defaultValue: null,
        description: 'Configures the search box. Set `placeholder` to change the placeholder text in the box and\n`incremental` to support incremental (as you type) search.',
        name: 'box',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'EuiFieldSearchProps & { schema?: boolean | SchemaType; }'
        }
      },
      filters: {
        defaultValue: null,
        description: 'An array of search filters.',
        name: 'filters',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'SearchFilterConfig[]'
        }
      },
      toolsLeft: {
        defaultValue: null,
        description: 'Tools which go to the left of the search bar.',
        name: 'toolsLeft',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'Tools'
        }
      },
      toolsRight: {
        defaultValue: null,
        description: 'Tools which go to the right of the search bar.',
        name: 'toolsRight',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'Tools'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: 'Date formatter to use when parsing date values',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/search_bar/search_bar.tsx',
          name: 'EuiSearchBarProps'
        },
        required: false,
        type: {
          name: 'object'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  Query.__docgenInfo = {
    description: 'This is the consumer interface for the query - it\'s effectively a wrapper construct around\nthe AST and some of its related utility functions (e.g. parsing, text representation, executing, etc...)\nIt is immutable - all mutating operations return a new (mutated) query instance.',
    displayName: 'Query',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}