"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableTemplateSitewide = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../../services");

var _selectable = require("../selectable");

var _popover = require("../../popover");

var _popover2 = require("../../popover/popover");

var _i18n = require("../../i18n");

var _selectable_message = require("../selectable_message");

var _loading = require("../../loading");

var _selectable_template_sitewide_option = require("./selectable_template_sitewide_option");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiSelectableTemplateSitewide = function EuiSelectableTemplateSitewide(_ref) {
  var children = _ref.children,
      className = _ref.className,
      options = _ref.options,
      popoverProps = _ref.popoverProps,
      popoverTitle = _ref.popoverTitle,
      popoverFooter = _ref.popoverFooter,
      searchProps = _ref.searchProps,
      listProps = _ref.listProps,
      isLoading = _ref.isLoading,
      rest = _objectWithoutProperties(_ref, ["children", "className", "options", "popoverProps", "popoverTitle", "popoverFooter", "searchProps", "listProps", "isLoading"]);

  /**
   * i18n text
   */
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiSelectableTemplateSitewide.searchPlaceholder'], ['Search for anything...']),
      _useEuiI18n2 = _slicedToArray(_useEuiI18n, 1),
      searchPlaceholder = _useEuiI18n2[0];
  /**
   * Internal states
   */


  var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      inputHasFocus = _useState2[0],
      setInputHasFocus = _useState2[1];
  /**
   * Popover helpers
   */


  var _useState3 = (0, _react.useState)(null),
      _useState4 = _slicedToArray(_useState3, 2),
      popoverRef = _useState4[0],
      setPopoverRef = _useState4[1];

  var _popoverProps = _objectSpread({}, popoverProps),
      _closePopover = _popoverProps.closePopover,
      panelRef = _popoverProps.panelRef,
      width = _popoverProps.width,
      popoverRest = _objectWithoutProperties(_popoverProps, ["closePopover", "panelRef", "width"]);

  var closePopover = function closePopover() {
    setInputHasFocus(false);
    _closePopover && _closePopover();
  }; // Width applied to the internal div


  var popoverWidth = width || 600;
  var setPanelRef = (0, _services.useCombinedRefs)([setPopoverRef, panelRef]);
  /**
   * Search helpers
   */

  var searchOnFocus = function searchOnFocus(e) {
    searchProps && searchProps.onFocus && searchProps.onFocus(e);
    setInputHasFocus(true);
  };

  var onSearchInput = function onSearchInput(e) {
    searchProps && searchProps.onInput && searchProps.onInput(e);
    setInputHasFocus(true);
  };

  var searchOnBlur = function searchOnBlur(e) {
    searchProps && searchProps.onBlur && searchProps.onBlur(e);

    if (!(popoverRef === null || popoverRef === void 0 ? void 0 : popoverRef.contains(e.relatedTarget))) {
      setInputHasFocus(false);
    }
  };
  /**
   * Classes
   */


  var classes = (0, _classnames.default)('euiSelectableTemplateSitewide', className);
  var searchClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__search', searchProps && searchProps.className);
  var listClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__list', listProps && listProps.className);
  /**
   * List options
   */

  var formattedOptions = (0, _selectable_template_sitewide_option.euiSelectableTemplateSitewideFormatOptions)(options);

  var loadingMessage = _react.default.createElement(_selectable_message.EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, _react.default.createElement(_loading.EuiLoadingSpinner, {
    size: "l"
  }), _react.default.createElement("br", null), _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
    token: "euiSelectableTemplateSitewide.loadingResults",
    default: "Loading results"
  })));

  var emptyMessage = _react.default.createElement(_selectable_message.EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
    token: "euiSelectableTemplateSitewide.noResults",
    default: "No results available"
  })));

  return _react.default.createElement(_selectable.EuiSelectable, _extends({
    isLoading: isLoading,
    options: formattedOptions,
    renderOption: _selectable_template_sitewide_option.euiSelectableTemplateSitewideRenderOptions,
    singleSelection: true,
    searchProps: _objectSpread({
      placeholder: searchPlaceholder,
      isClearable: true
    }, searchProps, {
      onFocus: searchOnFocus,
      onBlur: searchOnBlur,
      onInput: onSearchInput,
      className: searchClasses
    }),
    listProps: _objectSpread({
      rowHeight: 68,
      showIcons: false,
      onFocusBadge: {
        iconSide: 'right',
        children: _react.default.createElement(_i18n.EuiI18n, {
          token: "euiSelectableTemplateSitewide.onFocusBadgeGoTo",
          default: "Go to"
        })
      }
    }, listProps, {
      className: listClasses
    }),
    loadingMessage: loadingMessage,
    emptyMessage: emptyMessage,
    noMatchesMessage: emptyMessage
  }, rest, {
    className: classes,
    searchable: true
  }), function (list, search) {
    return _react.default.createElement(_popover2.EuiPopover, _extends({
      panelPaddingSize: "none",
      display: "block",
      isOpen: inputHasFocus
    }, popoverRest, {
      panelRef: setPanelRef,
      button: search,
      closePopover: closePopover
    }), _react.default.createElement("div", {
      style: {
        width: popoverWidth,
        maxWidth: '100%'
      }
    }, popoverTitle && _react.default.createElement(_popover.EuiPopoverTitle, null, popoverTitle), list, popoverFooter && _react.default.createElement(_popover.EuiPopoverFooter, null, popoverFooter)));
  });
};

exports.EuiSelectableTemplateSitewide = EuiSelectableTemplateSitewide;
EuiSelectableTemplateSitewide.propTypes = {
  /**
     * Extends the typical EuiSelectable #Options with the addition of pre-composed elements
     * such as `icon`, `avatar`and `meta`
     */
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Displayed on the left (`prepend`).
       * Object of `EuiIconProps` for display of the solution/application's logo
       */
    icon: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,

      /**
           * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
           * Note that coloring only works if your SVG is removed of fill attributes.
           */
      color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf(["default", "primary", "secondary", "success", "accent", "warning", "danger", "text", "subdued", "ghost"]).isRequired]),

      /**
           * Descriptive title for naming the icon based on its use
           */
      title: _propTypes.default.string,

      /**
           * A unique identifier for the title element
           */
      titleId: _propTypes.default.string,

      /**
           * Its value should be one or more element IDs
           */
      "aria-labelledby": _propTypes.default.string,

      /**
           * Callback when the icon has been loaded & rendered
           */
      onIconLoad: _propTypes.default.func
    }),

    /**
       * Displayed on the right (`append`).
       * Object of `EuiAvatarProps` for display of the space (default) or user
       */
    avatar: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,

      /**
           * Full name of avatar for title attribute and calculating initial if not provided
           */
      name: _propTypes.default.string.isRequired,

      /**
           * Accepts hex value `#FFFFFF`, `#000` otherwise a viz palette color will be assigned
           */
      color: _propTypes.default.string,

      /**
           * Custom initials (max 2 characters).
           * By default will take the first character (of each word).
           */
      initials: _propTypes.default.string,

      /**
           * Specify how many characters to show (max 2 allowed).
           * By default, will show based on number of words.
           */
      initialsLength: _propTypes.default.oneOf([1, 2]),

      /**
           * The type of avatar this is displaying
           */
      type: _propTypes.default.oneOf(["space", "user"]),
      imageUrl: _propTypes.default.string,
      size: _propTypes.default.oneOf(["none", "s", "m", "l", "xl"])
    }),

    /**
       * An array of inline #MetaData displayed beneath the label and separated by bullets.
       */
    meta: _propTypes.default.arrayOf(_propTypes.default.shape({
      /**
         * Required to display the metadata
         */
      text: _propTypes.default.string.isRequired,

      /**
         * Styles the metadata according to Elastic's schema.
         * Can be one of 'application', 'deployment', 'article', 'case', 'platform',
         * or a custom string to associate with your own schema.
         * Appends the string to the class name as `euiSelectableTemplateSitewide__optionMeta--[type]`
         */
      type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["application", "deployment", "article", "case", "platform"]), _propTypes.default.string.isRequired]),

      /**
         * Will wrap the meta tag in EuiHighlight to mark the portions that match the search text
         */
      highlightSearchString: _propTypes.default.bool,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string
    }).isRequired),

    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: _propTypes.default.string,

    /**
       * Optionally change the searchable term by passing a different string other than the `label`.
       * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
       */
    searchableLabel: _propTypes.default.string,

    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: _propTypes.default.string,

    /**
       * Leave `undefined` to indicate not selected,
       * 'on' to indicate inclusion and
       * 'off' to indicate exclusion
       */
    checked: _propTypes.default.oneOf(["on", "off", undefined]),
    disabled: _propTypes.default.bool,

    /**
       * Node to add between the selection icon and the label
       */
    prepend: _propTypes.default.node,

    /**
       * Node to add to the far right of the item
       */
    append: _propTypes.default.node,
    ref: _propTypes.default.func
  }).isRequired).isRequired,

  /**
     * Override some of the EuiPopover props housing the list.
     * The default width is `600`
     */
  popoverProps: _propTypes.default.shape({
    width: _propTypes.default.any
  }),

  /**
     * Optionally provide a title for the popover
     */
  popoverTitle: _propTypes.default.node,

  /**
     * Optionally provide a footer for the popover
     */
  popoverFooter: _propTypes.default.node
};

try {
  EuiSelectableTemplateSitewide.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableTemplateSitewide',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'Function that takes the `list` node and then\nthe `search` node (if `searchable` is applied)',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: '(list: ReactElement, search: ReactElement<...>) => ReactNode'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Show an loading indicator while you load and hook up your data',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back the altered `options` array with selected options as',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render function for each option.\nReturns `(option, searchValue)`',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: 'Sets the single selection policy of\n`false`: allows multiple selection\n`true`: only allows one selection\n`always`: can and must have only one selection',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      searchable: {
        defaultValue: null,
        description: 'Hooks up a search box to filter the list (boolean)',
        name: 'searchable',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      searchProps: {
        defaultValue: null,
        description: 'Passes props down to the `EuiFieldSearch`',
        name: 'searchProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<EuiSelectableSearchProps>'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allows marking options as `checked=\'off\'` as well as `\'on\'`',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listProps: {
        defaultValue: null,
        description: 'See #EuiSelectableOptionsList',
        name: 'listProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSelectableOptionsListPropsWithDefaults'
        }
      },
      loadingMessage: {
        defaultValue: null,
        description: 'Customize the loading message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'loadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      noMatchesMessage: {
        defaultValue: null,
        description: 'Customize the no matches message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'noMatchesMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      emptyMessage: {
        defaultValue: null,
        description: 'Customize the empty message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'emptyMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      options: {
        defaultValue: null,
        description: 'Extends the typical EuiSelectable #Options with the addition of pre-composed elements\nsuch as `icon`, `avatar`and `meta`',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiSelectableTemplateSitewideOption<{ [key: string]: any; }>[]'
        }
      },
      popoverProps: {
        defaultValue: null,
        description: 'Override some of the EuiPopover props housing the list.\nThe default width is `600`',
        name: 'popoverProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<Props> & { width?: ReactText; }'
        }
      },
      popoverTitle: {
        defaultValue: null,
        description: 'Optionally provide a title for the popover',
        name: 'popoverTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      popoverFooter: {
        defaultValue: null,
        description: 'Optionally provide a footer for the popover',
        name: 'popoverFooter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}