"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiStep", {
  enumerable: true,
  get: function get() {
    return _step.EuiStep;
  }
});
Object.defineProperty(exports, "EuiSteps", {
  enumerable: true,
  get: function get() {
    return _steps.EuiSteps;
  }
});
Object.defineProperty(exports, "EuiSubSteps", {
  enumerable: true,
  get: function get() {
    return _sub_steps.EuiSubSteps;
  }
});
Object.defineProperty(exports, "EuiStepsHorizontal", {
  enumerable: true,
  get: function get() {
    return _steps_horizontal.EuiStepsHorizontal;
  }
});
Object.defineProperty(exports, "EuiStepNumber", {
  enumerable: true,
  get: function get() {
    return _step_number.EuiStepNumber;
  }
});

var _step = require("./step");

var _steps = require("./steps");

var _sub_steps = require("./sub_steps");

var _steps_horizontal = require("./steps_horizontal");

var _step_number = require("./step_number");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiStep.__docgenInfo = {
    description: '',
    displayName: 'EuiStep',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      headingElement: {
        defaultValue: null,
        description: 'The HTML tag used for the title',
        name: 'headingElement',
        parent: {
          fileName: 'eui/src/components/steps/step.tsx',
          name: 'EuiStepInterface'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      step: {
        defaultValue: null,
        description: 'The number of the step in the list of steps',
        name: 'step',
        parent: {
          fileName: 'eui/src/components/steps/step.tsx',
          name: 'EuiStepInterface'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/steps/step.tsx',
          name: 'EuiStepInterface'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      status: {
        defaultValue: null,
        description: 'May replace the number provided in props.step with alternate styling.',
        name: 'status',
        parent: {
          fileName: 'eui/src/components/steps/step.tsx',
          name: 'EuiStepInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiStepStatus',
          value: [{
            value: '"disabled"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"complete"'
          }, {
            value: '"incomplete"'
          }]
        }
      },
      titleSize: {
        defaultValue: null,
        description: 'Title sizing equivalent to EuiTitle, but only `m`, `s` and `xs`. Defaults to `s`',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/steps/step.tsx',
          name: 'EuiStepInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSteps.__docgenInfo = {
    description: '',
    displayName: 'EuiSteps',
    methods: [],
    props: {
      steps: {
        defaultValue: null,
        description: 'An array of `EuiStep` objects excluding the `step` prop',
        name: 'steps',
        parent: {
          fileName: 'eui/src/components/steps/steps.tsx',
          name: 'EuiStepsProps'
        },
        required: true,
        type: {
          name: 'Pick<EuiStepProps, "children" | "tabIndex" | "color" | "className" | "aria-label" | "data-test-subj" | "onClick" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | ... 247 more ... | "status">[]'
        }
      },
      firstStepNumber: {
        defaultValue: null,
        description: 'The number the steps should begin from',
        name: 'firstStepNumber',
        parent: {
          fileName: 'eui/src/components/steps/steps.tsx',
          name: 'EuiStepsProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      headingElement: {
        defaultValue: null,
        description: 'The HTML tag used for the title',
        name: 'headingElement',
        parent: {
          fileName: 'eui/src/components/steps/steps.tsx',
          name: 'EuiStepsProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      titleSize: {
        defaultValue: null,
        description: 'Title sizing equivalent to EuiTitle, but only `m`, `s` and `xs`. Defaults to `s`',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/steps/steps.tsx',
          name: 'EuiStepsProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSubSteps.__docgenInfo = {
    description: '',
    displayName: 'EuiSubSteps',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiStepsHorizontal.__docgenInfo = {
    description: '',
    displayName: 'EuiStepsHorizontal',
    methods: [],
    props: {
      steps: {
        defaultValue: null,
        description: 'An array of `EuiStepHorizontal` objects excluding the `step` prop',
        name: 'steps',
        parent: {
          fileName: 'eui/src/components/steps/steps_horizontal.tsx',
          name: 'EuiStepsHorizontalProps'
        },
        required: true,
        type: {
          name: 'Pick<EuiStepHorizontalProps, "children" | "tabIndex" | "color" | "className" | "aria-label" | "data-test-subj" | "onClick" | "defaultChecked" | "defaultValue" | ... 249 more ... | "isComplete">[]'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiStepNumber.__docgenInfo = {
    description: '',
    displayName: 'EuiStepNumber',
    methods: [],
    props: {
      status: {
        defaultValue: null,
        description: 'May replace the number provided in props.number with alternate styling',
        name: 'status',
        parent: {
          fileName: 'eui/src/components/steps/step_number.tsx',
          name: 'EuiStepNumberProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiStepStatus',
          value: [{
            value: '"disabled"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"complete"'
          }, {
            value: '"incomplete"'
          }]
        }
      },
      number: {
        defaultValue: null,
        description: '',
        name: 'number',
        parent: {
          fileName: 'eui/src/components/steps/step_number.tsx',
          name: 'EuiStepNumberProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      isHollow: {
        defaultValue: null,
        description: 'Uses a border and removes the step number',
        name: 'isHollow',
        parent: {
          fileName: 'eui/src/components/steps/step_number.tsx',
          name: 'EuiStepNumberProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      titleSize: {
        defaultValue: null,
        description: 'Title sizing equivalent to EuiTitle, but only `m`, `s` and `xs`. Defaults to `s`',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/steps/step_number.tsx',
          name: 'EuiStepNumberProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}