"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStepsHorizontal = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _step_horizontal = require("./step_horizontal");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function renderHorizontalSteps(steps) {
  return steps.map(function (step, index) {
    return _react.default.createElement(_step_horizontal.EuiStepHorizontal, _extends({
      key: index,
      step: index + 1
    }, step));
  });
}

var EuiStepsHorizontal = function EuiStepsHorizontal(_ref) {
  var className = _ref.className,
      steps = _ref.steps,
      rest = _objectWithoutProperties(_ref, ["className", "steps"]);

  var classes = (0, _classnames.default)('euiStepsHorizontal', className);
  return _react.default.createElement("div", _extends({
    role: "tablist",
    className: classes
  }, rest), renderHorizontalSteps(steps));
};

exports.EuiStepsHorizontal = EuiStepsHorizontal;
EuiStepsHorizontal.propTypes = {
  /**
     * An array of `EuiStepHorizontal` objects excluding the `step` prop
     */
  steps: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiStepsHorizontal.__docgenInfo = {
    description: '',
    displayName: 'EuiStepsHorizontal',
    methods: [],
    props: {
      steps: {
        defaultValue: null,
        description: 'An array of `EuiStepHorizontal` objects excluding the `step` prop',
        name: 'steps',
        parent: {
          fileName: 'eui/src/components/steps/steps_horizontal.tsx',
          name: 'EuiStepsHorizontalProps'
        },
        required: true,
        type: {
          name: 'Pick<EuiStepHorizontalProps, "children" | "tabIndex" | "color" | "className" | "aria-label" | "data-test-subj" | "onClick" | "defaultChecked" | "defaultValue" | ... 249 more ... | "isComplete">[]'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}