"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiText", {
  enumerable: true,
  get: function get() {
    return _text.EuiText;
  }
});
Object.defineProperty(exports, "EuiTextColor", {
  enumerable: true,
  get: function get() {
    return _text_color.EuiTextColor;
  }
});
Object.defineProperty(exports, "EuiTextAlign", {
  enumerable: true,
  get: function get() {
    return _text_align.EuiTextAlign;
  }
});

var _text = require("./text");

var _text_color = require("./text_color");

var _text_align = require("./text_align");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiText.__docgenInfo = {
    description: '',
    displayName: 'EuiText',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      textAlign: {
        defaultValue: null,
        description: '',
        name: 'textAlign',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"secondary" | "warning" | "danger" | "ghost" | "default" | "accent" | "subdued"',
          value: [{
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"default"'
          }, {
            value: '"accent"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: '',
        name: 'grow',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTextColor.__docgenInfo = {
    description: '',
    displayName: 'EuiTextColor',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      component: {
        defaultValue: null,
        description: 'Determines the root element',
        name: 'component',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'FlexGroupComponentType',
          value: [{
            value: '"span"'
          }, {
            value: '"div"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTextAlign.__docgenInfo = {
    description: '',
    displayName: 'EuiTextAlign',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      textAlign: {
        defaultValue: null,
        description: '',
        name: 'textAlign',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}