"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiToken", {
  enumerable: true,
  get: function get() {
    return _token.EuiToken;
  }
});
Object.defineProperty(exports, "TOKEN_SIZES", {
  enumerable: true,
  get: function get() {
    return _token.SIZES;
  }
});
Object.defineProperty(exports, "TOKEN_SHAPES", {
  enumerable: true,
  get: function get() {
    return _token.SHAPES;
  }
});
Object.defineProperty(exports, "TOKEN_COLORS", {
  enumerable: true,
  get: function get() {
    return _token.COLORS;
  }
});

var _token = require("./token");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiToken.__docgenInfo = {
    description: '',
    displayName: 'EuiToken',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'An EUI icon type',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: true,
        type: {
          name: 'IconType'
        }
      },
      color: {
        defaultValue: null,
        description: 'For best results use one of the vis color names (or \'gray\').\nOr supply your own color (can be used with dark or no fill only).\nDefault: `gray`',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      shape: {
        defaultValue: null,
        description: 'Outer shape surrounding the icon\nDefault: `circle`',
        name: 'shape',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'TokenShape',
          value: [{
            value: '"square"'
          }, {
            value: '"circle"'
          }, {
            value: '"rectangle"'
          }]
        }
      },
      fill: {
        defaultValue: null,
        description: '`light` for lightened color with border, `dark` for solid, or `none`\nDefault: `light`',
        name: 'fill',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'Background',
          value: [{
            value: '"none"'
          }, {
            value: '"light"'
          }, {
            value: '"dark"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Size of the token',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'The icon\'s title. Required for accessibility',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-labelledby': {
        defaultValue: null,
        description: 'Identifies the element (or elements) that labels the current element.\n@see aria-describedby.',
        name: 'aria-labelledby',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-describedby': {
        defaultValue: null,
        description: 'Identifies the element (or elements) that describes the object.\n@see aria-labelledby',
        name: 'aria-describedby',
        parent: {
          fileName: 'eui/src/components/token/token.tsx',
          name: 'TokenProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}