"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBreakpoint = getBreakpoint;
exports.BREAKPOINT_KEYS = exports.BREAKPOINTS = void 0;

var _common = require("../components/common");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var BREAKPOINTS = {
  xl: 1200,
  l: 992,
  m: 768,
  s: 575,
  xs: 0
};
exports.BREAKPOINTS = BREAKPOINTS;
var BREAKPOINT_KEYS = (0, _common.keysOf)(BREAKPOINTS);
/**
 * Given the current `width` and an object of `EuiBreakpoints`,
 * this function returns the string that is the name of the breakpoint key
 * that is less than or equal to the width
 *
 * @param {number} width Can either be the full window width or any width
 * @param {EuiBreakpoints} breakpoints An object with keys for sizing and values for minimu width
 * @returns {string | undefined} Name of the breakpoint key or `undefined` if a key doesn't exist
 */

exports.BREAKPOINT_KEYS = BREAKPOINT_KEYS;

function getBreakpoint(width) {
  var breakpoints = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : BREAKPOINTS;
  // Find the breakpoint (key) whose value is <= windowWidth starting with largest first
  return (0, _common.keysOf)(BREAKPOINTS).find(function (key) {
    return breakpoints[key] <= width;
  });
}

try {
  getBreakpoint.__docgenInfo = {
    description: 'Given the current `width` and an object of `EuiBreakpoints`,\nthis function returns the string that is the name of the breakpoint key\nthat is less than or equal to the width\n@param width Can either be the full window width or any width\n@param breakpoints An object with keys for sizing and values for minimu width\n@returns Name of the breakpoint key or `undefined` if a key doesn\'t exist',
    displayName: 'getBreakpoint',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}