"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "calculatePopoverPosition", {
  enumerable: true,
  get: function get() {
    return _calculate_popover_position.calculatePopoverPosition;
  }
});
Object.defineProperty(exports, "findPopoverPosition", {
  enumerable: true,
  get: function get() {
    return _popover_positioning.findPopoverPosition;
  }
});
Object.defineProperty(exports, "getElementZIndex", {
  enumerable: true,
  get: function get() {
    return _popover_positioning.getElementZIndex;
  }
});

var _calculate_popover_position = require("./calculate_popover_position");

var _popover_positioning = require("./popover_positioning");

require("./types");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  calculatePopoverPosition.__docgenInfo = {
    description: 'Determine the best position for a popover that avoids clipping by the window view port.\n@param anchorBounds - getBoundingClientRect() of the node the popover is tethered to (e.g. a button).\n@param popoverBounds - getBoundingClientRect() of the popover node (e.g. the tooltip).\n@param requestedPosition - Position the user wants. One of ["top", "right", "bottom", "left"]\n@param buffer - The space between the wrapper and the popover. Also the minimum space between the\npopover and the window.\n@param positions - List of acceptable positions. Defaults to ["top", "right", "bottom", "left"].\n@returns With properties position (one of ["top", "right", "bottom", "left"]), left, top, width, and height.',
    displayName: 'calculatePopoverPosition',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  findPopoverPosition.__docgenInfo = {
    description: 'Calculates the absolute positioning (relative to document.body) to place a popover element\n@param anchor Element to anchor the popover to\n@param popover Element containing the popover content\n@param position Position the user wants. One of ["top", "right", "bottom", "left"]\n@param forcePosition If true, use only the provided `position` value and don\'t try any other position\n@param align Cross-axis alignment. One of ["top", "right", "bottom", "left"]\n@param buffer Minimum distance between the popover and the bounding container\n@param offset Distance between the popover and the anchor\n@param allowCrossAxis Whether to allow the popover to be positioned on the cross-axis\n@param container Element the popover must be constrained to fit within\n@param arrowConfig If\npresent, describes the size & constraints for an arrow element, and the\nfunction return value will include an `arrow` param with position details\n@returns absolute page coordinates for the\npopover, and the placement\'s relation to the anchor or undefined\nthere\'s no room.',
    displayName: 'findPopoverPosition',
    methods: [],
    props: {
      anchor: {
        defaultValue: null,
        description: '',
        name: 'anchor',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: true,
        type: {
          name: 'HTMLElement'
        }
      },
      popover: {
        defaultValue: null,
        description: '',
        name: 'popover',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: true,
        type: {
          name: 'HTMLElement'
        }
      },
      align: {
        defaultValue: null,
        description: '',
        name: 'align',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: true,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      forcePosition: {
        defaultValue: null,
        description: '',
        name: 'forcePosition',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      buffer: {
        defaultValue: null,
        description: '',
        name: 'buffer',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      offset: {
        defaultValue: null,
        description: '',
        name: 'offset',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      allowCrossAxis: {
        defaultValue: null,
        description: '',
        name: 'allowCrossAxis',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      container: {
        defaultValue: null,
        description: '',
        name: 'container',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'HTMLElement'
        }
      },
      arrowConfig: {
        defaultValue: null,
        description: '',
        name: 'arrowConfig',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: '{ arrowWidth: number; arrowBuffer: number; }'
        }
      },
      returnBoundingBox: {
        defaultValue: null,
        description: '',
        name: 'returnBoundingBox',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  getElementZIndex.__docgenInfo = {
    description: 'Returns the top-most defined z-index in the element\'s ancestor hierarchy\nrelative to the `target` element; if no z-index is defined, returns 0\n@param element\n@param cousin\n@returns',
    displayName: 'getElementZIndex',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}