"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiKeyboardAccessible", {
  enumerable: true,
  get: function get() {
    return _keyboard_accessible.EuiKeyboardAccessible;
  }
});
Object.defineProperty(exports, "EuiScreenReaderOnly", {
  enumerable: true,
  get: function get() {
    return _screen_reader.EuiScreenReaderOnly;
  }
});
Object.defineProperty(exports, "EuiSkipLink", {
  enumerable: true,
  get: function get() {
    return _skip_link.EuiSkipLink;
  }
});

var _keyboard_accessible = require("./keyboard_accessible");

var _screen_reader = require("./screen_reader");

var _skip_link = require("./skip_link");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiKeyboardAccessible.__docgenInfo = {
    description: '',
    displayName: 'EuiKeyboardAccessible',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s children',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/accessibility/keyboard_accessible.ts',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactElement<...> | ReactNodeArray | ReactPortal'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiScreenReaderOnly.__docgenInfo = {
    description: '',
    displayName: 'EuiScreenReaderOnly',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactElement to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/accessibility/screen_reader.tsx',
          name: 'EuiScreenReaderOnlyProps'
        },
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      showOnFocus: {
        defaultValue: null,
        description: 'For keyboard navigation, force content to display visually upon focus.',
        name: 'showOnFocus',
        parent: {
          fileName: 'eui/src/components/accessibility/screen_reader.tsx',
          name: 'EuiScreenReaderOnlyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSkipLink.__docgenInfo = {
    description: '',
    displayName: 'EuiSkipLink',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      position: {
        defaultValue: null,
        description: 'Change the display position of the element when focused.\nIf \'fixed\', the link will be fixed to the top left of the viewport',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/accessibility/skip_link.tsx',
          name: 'EuiSkipLinkInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'Positions',
          value: [{
            value: '"static"'
          }, {
            value: '"fixed"'
          }, {
            value: '"absolute"'
          }]
        }
      },
      destinationId: {
        defaultValue: null,
        description: 'Typically an anchor id (e.g. `a11yMainContent`), the value provided\nwill be prepended with a hash `#` and used as the link `href`',
        name: 'destinationId',
        parent: {
          fileName: 'eui/src/components/accessibility/skip_link.tsx',
          name: 'EuiSkipLinkInterface'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      tabIndex: {
        defaultValue: null,
        description: 'When position is fixed, this is forced to `0`',
        name: 'tabIndex',
        parent: {
          fileName: 'eui/src/components/accessibility/skip_link.tsx',
          name: 'EuiSkipLinkInterface'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      fill: {
        defaultValue: null,
        description: 'Make button a solid color for prominence',
        name: 'fill',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      color: {
        defaultValue: null,
        description: 'Any of our named colors. `text` color is set for deprecation',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Use size `s` in confined spaces',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'Extends the button to 100% width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: undefined,
        required: false,
        type: {
          name: '((instance: HTMLButtonElement) => void) | RefObject<HTMLButtonElement> | ((instance: HTMLAnchorElement) => void) | RefObject<...>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}