"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomItemAction = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var CustomItemAction =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(CustomItemAction, _Component);

  function CustomItemAction(props) {
    var _this;

    (0, _classCallCheck2.default)(this, CustomItemAction);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(CustomItemAction).call(this, props));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "mounted", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function () {
      if (_this.mounted) {
        _this.setState({
          hasFocus: true
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function () {
      if (_this.mounted) {
        _this.setState({
          hasFocus: false
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hasFocus", function () {
      return _this.state.hasFocus;
    });
    _this.state = {
      hasFocus: false
    }; // while generally considered an anti-pattern, here we require
    // to do that as the onFocus/onBlur events of the action controls
    // may trigger while this component is unmounted. An alternative
    // (at least the workarounds suggested by react is to unregister
    // the onFocus/onBlur listeners from the action controls... this
    // unfortunately will lead to unecessarily complex code... so we'll
    // stick to this approach for now)

    _this.mounted = false;
    return _this;
  }

  (0, _createClass2.default)(CustomItemAction, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.mounted = true;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.mounted = false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          action = _this$props.action,
          enabled = _this$props.enabled,
          item = _this$props.item,
          className = _this$props.className;
      var tool = action.render(item, enabled);
      var clonedTool = (0, _react.cloneElement)(tool, {
        onFocus: this.onFocus,
        onBlur: this.onBlur
      });
      var style = this.hasFocus() ? {
        opacity: 1
      } : undefined;
      return _react.default.createElement("div", {
        style: style,
        className: className
      }, clonedTool);
    }
  }]);
  return CustomItemAction;
}(_react.Component);

exports.CustomItemAction = CustomItemAction;
CustomItemAction.propTypes = {
  action: _propTypes.default.any.isRequired,
  enabled: _propTypes.default.bool.isRequired,
  item: _propTypes.default.any.isRequired,
  className: _propTypes.default.string.isRequired,
  index: _propTypes.default.number
};

try {
  CustomItemAction.__docgenInfo = {
    description: '',
    displayName: 'CustomItemAction',
    methods: [],
    props: {
      action: {
        defaultValue: null,
        description: '',
        name: 'action',
        parent: {
          fileName: 'eui/src/components/basic_table/custom_item_action.tsx',
          name: 'CustomItemActionProps'
        },
        required: true,
        type: {
          name: 'CustomItemAction<T>'
        }
      },
      enabled: {
        defaultValue: null,
        description: '',
        name: 'enabled',
        parent: {
          fileName: 'eui/src/components/basic_table/custom_item_action.tsx',
          name: 'CustomItemActionProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      item: {
        defaultValue: null,
        description: '',
        name: 'item',
        parent: {
          fileName: 'eui/src/components/basic_table/custom_item_action.tsx',
          name: 'CustomItemActionProps'
        },
        required: true,
        type: {
          name: 'T'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/basic_table/custom_item_action.tsx',
          name: 'CustomItemActionProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      index: {
        defaultValue: null,
        description: '',
        name: 'index',
        parent: {
          fileName: 'eui/src/components/basic_table/custom_item_action.tsx',
          name: 'CustomItemActionProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}