"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationBar = exports.defaults = void 0;

var _react = _interopRequireWildcard(require("react"));

var _spacer = require("../spacer");

var _table = require("../table");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var defaults = {
  pageSizeOptions: [10, 25, 50]
};
exports.defaults = defaults;

var PaginationBar = function PaginationBar(_ref) {
  var pagination = _ref.pagination,
      ariaControls = _ref['aria-controls'],
      onPageSizeChange = _ref.onPageSizeChange,
      onPageChange = _ref.onPageChange;
  var pageSizeOptions = pagination.pageSizeOptions ? pagination.pageSizeOptions : defaults.pageSizeOptions;
  var pageCount = Math.ceil(pagination.totalItemCount / pagination.pageSize);
  (0, _react.useEffect)(function () {
    if (pageCount < pagination.pageIndex + 1) {
      onPageChange(pageCount - 1);
    }
  }, [pageCount, onPageChange, pagination]);
  return _react.default.createElement("div", null, _react.default.createElement(_spacer.EuiSpacer, {
    size: "m"
  }), _react.default.createElement(_table.EuiTablePagination, {
    activePage: pagination.pageIndex,
    hidePerPageOptions: pagination.hidePerPageOptions,
    itemsPerPage: pagination.pageSize,
    itemsPerPageOptions: pageSizeOptions,
    pageCount: pageCount,
    onChangeItemsPerPage: onPageSizeChange,
    onChangePage: onPageChange,
    "aria-controls": ariaControls
  }));
};

exports.PaginationBar = PaginationBar;

try {
  PaginationBar.__docgenInfo = {
    description: '',
    displayName: 'PaginationBar',
    methods: [],
    props: {
      pagination: {
        defaultValue: null,
        description: '',
        name: 'pagination',
        parent: {
          fileName: 'eui/src/components/basic_table/pagination_bar.tsx',
          name: 'PaginationBarProps'
        },
        required: true,
        type: {
          name: 'Pagination'
        }
      },
      'aria-controls': {
        defaultValue: null,
        description: 'id of the table being controlled',
        name: 'aria-controls',
        parent: {
          fileName: 'eui/src/components/basic_table/pagination_bar.tsx',
          name: 'PaginationBarProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onPageSizeChange: {
        defaultValue: null,
        description: '',
        name: 'onPageSizeChange',
        parent: {
          fileName: 'eui/src/components/basic_table/pagination_bar.tsx',
          name: 'PaginationBarProps'
        },
        required: true,
        type: {
          name: 'ItemsPerPageChangeHandler'
        }
      },
      onPageChange: {
        defaultValue: null,
        description: '',
        name: 'onPageChange',
        parent: {
          fileName: 'eui/src/components/basic_table/pagination_bar.tsx',
          name: 'PaginationBarProps'
        },
        required: true,
        type: {
          name: 'PageChangeHandler'
        }
      }
    },
    extends: []
  };
} catch (e) {}