"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiBreadcrumbs", {
  enumerable: true,
  get: function get() {
    return _breadcrumbs.EuiBreadcrumbs;
  }
});

var _breadcrumbs = require("./breadcrumbs");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiBreadcrumbs.__docgenInfo = {
    description: '',
    displayName: 'EuiBreadcrumbs',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      responsive: {
        defaultValue: null,
        description: 'Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.\nPass a custom #EuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.\nOmitting or passing a `0` value will show all breadcrumbs.\n\nPass `false` to turn this behavior off.\n\nDefault: `{ xs: 1, s: 2, m: 4 }`',
        name: 'responsive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | EuiBreadcrumbResponsiveMaxCount'
        }
      },
      truncate: {
        defaultValue: null,
        description: 'Forces all breadcrumbs to single line and\ntruncates each breadcrumb to a particular width,\nexcept for the last item',
        name: 'truncate',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      max: {
        defaultValue: null,
        description: 'Collapses the inner items past the maximum set here\ninto a single ellipses item',
        name: 'max',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      breadcrumbs: {
        defaultValue: null,
        description: 'The array of individual #EuiBreadcrumb items',
        name: 'breadcrumbs',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiBreadcrumb[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}