"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiButtonGroup", {
  enumerable: true,
  get: function get() {
    return _button_group.EuiButtonGroup;
  }
});

var _button_group = require("./button_group");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiButtonGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'EuiButtonGroupOption[]'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: true,
        type: {
          name: '(id: string, value?: any) => void'
        }
      },
      buttonSize: {
        defaultValue: null,
        description: 'Typical sizing is `s`. Medium `m` size should be reserved for major features.\n`compressed` is meant to be used alongside and within compressed forms.',
        name: 'buttonSize',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'GroupButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"compressed"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isFullWidth: {
        defaultValue: null,
        description: '',
        name: 'isFullWidth',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isIconOnly: {
        defaultValue: null,
        description: '',
        name: 'isIconOnly',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      idSelected: {
        defaultValue: null,
        description: '',
        name: 'idSelected',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      legend: {
        defaultValue: null,
        description: '',
        name: 'legend',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"single" | "multi"',
          value: [{
            value: '"single"'
          }, {
            value: '"multi"'
          }]
        }
      },
      idToSelectedMap: {
        defaultValue: null,
        description: '',
        name: 'idToSelectedMap',
        parent: {
          fileName: 'eui/src/components/button/button_group/button_group.tsx',
          name: 'EuiButtonGroupProps'
        },
        required: false,
        type: {
          name: 'EuiButtonGroupIdToSelectedMap'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}