"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonToggle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _toggle = require("../../toggle");

var _button = require("../button");

var _render_to_text = require("../../inner_text/render_to_text");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiButtonToggle = function EuiButtonToggle(_ref) {
  var className = _ref.className,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'primary' : _ref$color,
      isDisabled = _ref.isDisabled,
      isEmpty = _ref.isEmpty,
      isIconOnly = _ref.isIconOnly,
      isSelected = _ref.isSelected,
      label = _ref.label,
      name = _ref.name,
      onChange = _ref.onChange,
      toggleClassName = _ref.toggleClassName,
      type = _ref.type,
      value = _ref.value,
      dataTestSubj = _ref['data-test-subj'],
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "color", "isDisabled", "isEmpty", "isIconOnly", "isSelected", "label", "name", "onChange", "toggleClassName", "type", "value", "data-test-subj"]);
  var classes = (0, _classnames.default)('euiButtonToggle', {
    'euiButtonToggle--isIconOnly': isIconOnly,
    'euiButtonToggle--isEmpty': isEmpty
  }, className);
  var wrapperClasses = (0, _classnames.default)('euiButtonToggle__wrapper', {
    'euiButtonToggle--isDisabled': isDisabled
  }, toggleClassName);
  var buttonContent = isIconOnly ? '' : label;
  var labelText = (0, _render_to_text.useRenderToText)(label, typeof label === 'string' ? label : '');
  return _react.default.createElement(_toggle.EuiToggle, {
    className: wrapperClasses,
    inputClassName: "euiButtonToggle__input",
    checked: isSelected,
    isDisabled: isDisabled,
    label: labelText,
    name: name,
    onChange: onChange,
    type: type,
    title: labelText,
    value: value,
    "data-test-subj": dataTestSubj
  }, _react.default.createElement(_button.EuiButton, (0, _extends2.default)({
    tabIndex: -1 // prevents double focus from input to button
    ,
    className: classes,
    color: color,
    disabled: isDisabled,
    size: isIconOnly ? 's' : undefined // only force small if it's the icon only version

  }, rest), buttonContent));
};

exports.EuiButtonToggle = EuiButtonToggle;
EuiButtonToggle.propTypes = {
  /**
     * Simulates a `EuiButtonEmpty`
     */

  /**
     * Simulates a `EuiButtonEmpty`
     */
  isEmpty: _propTypes.default.bool,

  /**
     * Hides the label from the button content and only displays the icon
     */

  /**
     * Hides the label from the button content and only displays the icon
     */
  isIconOnly: _propTypes.default.bool,

  /**
     * Initial state of the toggle
     */

  /**
     * Initial state of the toggle
     */
  isSelected: _propTypes.default.bool,

  /**
     * Button label, which is also passed to `EuiToggle` as the input's label
     */

  /**
     * Button label, which is also passed to `EuiToggle` as the input's label
     */
  label: _propTypes.default.node.isRequired,

  /**
     * Classnames to add to `EuiToggle` instead of the `EuiButton`
     */

  /**
     * Classnames to add to `EuiToggle` instead of the `EuiButton`
     */
  toggleClassName: _propTypes.default.string,

  /**
     * Is the button a single action or part of a group (multi)?
     * Used primarily for `EuiButtonGroup`
     */
  type: _propTypes.default.oneOf(["single", "multi"]),
  onChange: _propTypes.default.any,

  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,

  /**
     * Any of our named colors. `text` color is set for deprecation
     */
  color: _propTypes.default.oneOf(["primary", "secondary", "warning", "danger", "ghost", "text"]),

  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.oneOf(["s", "m"]),

  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,

  /**
     * Extends the button to 100% width
     */
  fullWidth: _propTypes.default.bool,

  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  isLoading: _propTypes.default.bool,

  /**
     * Object of props passed to the <span/> wrapping the button's content
     */
  contentProps: _propTypes.default.any,
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
  iconSide: _propTypes.default.oneOf(["left", "right"]),

  /**
     * Object of props passed to the <span/> wrapping the content's text/children only (not icon)
     */
  textProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }),
  className: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  "aria-label": _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  href: _propTypes.default.string,
  name: _propTypes.default.string,
  onClick: _propTypes.default.func,
  value: _propTypes.default.string
};

try {
  EuiButtonToggle.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonToggle',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isEmpty: {
        defaultValue: null,
        description: 'Simulates a `EuiButtonEmpty`',
        name: 'isEmpty',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isIconOnly: {
        defaultValue: null,
        description: 'Hides the label from the button content and only displays the icon',
        name: 'isIconOnly',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Initial state of the toggle',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      label: {
        defaultValue: null,
        description: 'Button label, which is also passed to `EuiToggle` as the input\'s label',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      toggleClassName: {
        defaultValue: null,
        description: 'Classnames to add to `EuiToggle` instead of the `EuiButton`',
        name: 'toggleClassName',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: 'Is the button a single action or part of a group (multi)?\nUsed primarily for `EuiButtonGroup`',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"single" | "multi"',
          value: [{
            value: '"single"'
          }, {
            value: '"multi"'
          }]
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: '(((event: ChangeEvent<HTMLInputElement>) => void) & ((event: FormEvent<HTMLButtonElement>) => void)) | (((event: ChangeEvent<HTMLInputElement>) => void) & ((event: FormEvent<...>) => void))'
        }
      },
      fill: {
        defaultValue: null,
        description: 'Make button a solid color for prominence',
        name: 'fill',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      color: {
        defaultValue: {
          value: 'primary'
        },
        description: 'Any of our named colors. `text` color is set for deprecation',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Use size `s` in confined spaces',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'Extends the button to 100% width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}