"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNav = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _utils = require("../color_picker/utils");

var _services = require("../../services");

var _focus_trap = require("../focus_trap");

var _overlay_mask = require("../overlay_mask");

var _button = require("../button");

var _i18n = require("../i18n");

var _accessibility = require("../accessibility");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$isDocked = _ref.isDocked,
      isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      button = _ref.button,
      _ref$showButtonIfDock = _ref.showButtonIfDocked,
      showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
      _ref$dockedBreakpoint = _ref.dockedBreakpoint,
      dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 992 : _ref$dockedBreakpoint,
      _ref$showCloseButton = _ref.showCloseButton,
      showCloseButton = _ref$showCloseButton === void 0 ? true : _ref$showCloseButton,
      closeButtonProps = _ref.closeButtonProps,
      onClose = _ref.onClose,
      id = _ref.id,
      maskProps = _ref.maskProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "showCloseButton", "closeButtonProps", "onClose", "id", "maskProps"]);

  var _useState = (0, _react.useState)(id || (0, _services.htmlIdGenerator)()('euiCollapsibleNav')),
      _useState2 = (0, _slicedToArray2.default)(_useState, 1),
      flyoutID = _useState2[0];

  var _useState3 = (0, _react.useState)(window.innerWidth >= dockedBreakpoint),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      windowIsLargeEnoughToDock = _useState4[0],
      setWindowIsLargeEnoughToDock = _useState4[1];

  var navIsDocked = isDocked && windowIsLargeEnoughToDock;
  var functionToCallOnWindowResize = (0, _utils.throttle)(function () {
    if (window.innerWidth < dockedBreakpoint) {
      setWindowIsLargeEnoughToDock(false);
    } else {
      setWindowIsLargeEnoughToDock(true);
    } // reacts every 50ms to resize changes and always gets the final update

  }, 50); // Watch for docked status and appropriately add/remove body classes and resize handlers

  (0, _react.useEffect)(function () {
    window.addEventListener('resize', functionToCallOnWindowResize);

    if (navIsDocked) {
      document.body.classList.add('euiBody--collapsibleNavIsDocked');
    } else if (isOpen) {
      document.body.classList.add('euiBody--collapsibleNavIsOpen');
    }

    return function () {
      document.body.classList.remove('euiBody--collapsibleNavIsDocked');
      document.body.classList.remove('euiBody--collapsibleNavIsOpen');
      window.removeEventListener('resize', functionToCallOnWindowResize);
    };
  }, [navIsDocked, functionToCallOnWindowResize, isOpen]);

  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      collapse();
    }
  };

  var collapse = function collapse() {
    // Skip collapsing if it is docked
    if (navIsDocked) {
      return;
    } else {
      onClose && onClose();
    }
  };

  var classes = (0, _classnames.default)('euiCollapsibleNav', {
    'euiCollapsibleNav--isDocked': navIsDocked
  }, className);
  var optionalOverlay;

  if (!navIsDocked) {
    optionalOverlay = _react.default.createElement(_overlay_mask.EuiOverlayMask, (0, _extends2.default)({
      onClick: collapse,
      headerZindexLocation: "below"
    }, maskProps));
  } // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false


  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && (0, _react.cloneElement)(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    className: (0, _classnames.default)(button.props.className, 'euiCollapsibleNav__toggle')
  });

  var closeButton = showCloseButton && _react.default.createElement(_accessibility.EuiScreenReaderOnly, {
    showOnFocus: true
  }, _react.default.createElement(_button.EuiButtonEmpty, (0, _extends2.default)({
    onClick: collapse,
    size: "xs",
    textProps: {
      className: 'euiCollapsibleNav__closeButtonText'
    },
    iconType: "cross"
  }, closeButtonProps, {
    className: (0, _classnames.default)('euiCollapsibleNav__closeButton', closeButtonProps && closeButtonProps.className)
  }), _react.default.createElement(_i18n.EuiI18n, {
    token: "euiCollapsibleNav.closeButtonLabel",
    default: "close"
  })));

  var flyout = _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_services.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), optionalOverlay, _react.default.createElement(_focus_trap.EuiFocusTrap, {
    disabled: navIsDocked,
    clickOutsideDisables: true
  }, _react.default.createElement("nav", (0, _extends2.default)({
    id: flyoutID,
    className: classes
  }, rest), children, closeButton)));

  return _react.default.createElement(_react.default.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};

exports.EuiCollapsibleNav = EuiCollapsibleNav;
EuiCollapsibleNav.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node,

  /**
       * Keeps navigation flyout visible and push `<body>` content via padding
       */
  isDocked: _propTypes.default.bool,

  /**
       * Pixel value for customizing the minimum window width for enabling docking
       */
  dockedBreakpoint: _propTypes.default.number,

  /**
       * Shows the navigation flyout
       */
  isOpen: _propTypes.default.bool,

  /**
       * Button for controlling visible state of the nav
       */
  button: _propTypes.default.element,

  /**
       * Keeps the display of toggle button when in docked state
       */
  showButtonIfDocked: _propTypes.default.bool,

  /**
       * Keeps the display of floating close button.
       * If `false`, you must then keep the `button` displayed at all breakpoints.
       */
  showCloseButton: _propTypes.default.bool,

  /**
       * Extend the props of the close button, an EuiButtonEmpty
       */
  closeButtonProps: _propTypes.default.shape({
    href: _propTypes.default.string,
    onClick: _propTypes.default.func,

    /**
       * Any of our named colors
       */

    /**
       * Any of our named colors
       */
    color: _propTypes.default.oneOf(["primary", "danger", "disabled", "text", "ghost"]),
    size: _propTypes.default.oneOf(["xs", "s", "l"]),

    /**
       * Ensure the text of the button sits flush to the left or right side of its container
       */

    /**
       * Ensure the text of the button sits flush to the left or right side of its container
       */
    flush: _propTypes.default.oneOf(["left", "right"]),

    /**
       * `disabled` is also allowed
       */

    /**
       * `disabled` is also allowed
       */
    isDisabled: _propTypes.default.bool,

    /**
       * Force disables the button and changes the icon to a loading spinner
       */

    /**
       * Force disables the button and changes the icon to a loading spinner
       */
    isLoading: _propTypes.default.bool,
    target: _propTypes.default.string,
    rel: _propTypes.default.string,
    type: _propTypes.default.oneOf(["button", "submit"]),
    buttonRef: _propTypes.default.func,

    /**
       * Object of props passed to the <span/> wrapping the button's content
       */
    contentProps: _propTypes.default.any,
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    iconSide: _propTypes.default.oneOf(["left", "right"]),

    /**
       * Object of props passed to the <span/> wrapping the content's text/children only (not icon)
       */
    textProps: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string
    }),
    className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
    "aria-label": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
    "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string])
  }),
  onClose: _propTypes.default.func,

  /**
       * Adjustments to the EuiOverlayMask
       */
  maskProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Function that applies to clicking the mask itself and not the children
       */
    onClick: _propTypes.default.func,

    /**
       * ReactNode to render as this component's content
       */
    children: _propTypes.default.node,

    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: _propTypes.default.oneOf(["above", "below"])
  })
};

try {
  EuiCollapsibleNav.__docgenInfo = {
    description: '',
    displayName: 'EuiCollapsibleNav',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      isDocked: {
        defaultValue: {
          value: 'false'
        },
        description: 'Keeps navigation flyout visible and push `<body>` content via padding',
        name: 'isDocked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      dockedBreakpoint: {
        defaultValue: {
          value: '992'
        },
        description: 'Pixel value for customizing the minimum window width for enabling docking',
        name: 'dockedBreakpoint',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      isOpen: {
        defaultValue: {
          value: 'false'
        },
        description: 'Shows the navigation flyout',
        name: 'isOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      button: {
        defaultValue: null,
        description: 'Button for controlling visible state of the nav',
        name: 'button',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      showButtonIfDocked: {
        defaultValue: {
          value: 'false'
        },
        description: 'Keeps the display of toggle button when in docked state',
        name: 'showButtonIfDocked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showCloseButton: {
        defaultValue: {
          value: 'true'
        },
        description: 'Keeps the display of floating close button.\nIf `false`, you must then keep the `button` displayed at all breakpoints.',
        name: 'showCloseButton',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      closeButtonProps: {
        defaultValue: null,
        description: 'Extend the props of the close button, an EuiButtonEmpty',
        name: 'closeButtonProps',
        parent: undefined,
        required: false,
        type: {
          name: '(DisambiguateSet<PropsForAnchor<CommonEuiButtonEmptyProps, {}>, PropsForButton<CommonEuiButtonEmptyProps, {}>> & CommonEuiButtonEmptyProps & { ...; } & ButtonHTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & AnchorHTMLAttributes<...>)'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: undefined,
        required: false,
        type: {
          name: '() => void'
        }
      },
      maskProps: {
        defaultValue: null,
        description: 'Adjustments to the EuiOverlayMask',
        name: 'maskProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiOverlayMaskProps'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}