"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiColorPicker", {
  enumerable: true,
  get: function get() {
    return _color_picker.EuiColorPicker;
  }
});
Object.defineProperty(exports, "EuiColorPickerSwatch", {
  enumerable: true,
  get: function get() {
    return _color_picker_swatch.EuiColorPickerSwatch;
  }
});
Object.defineProperty(exports, "EuiHue", {
  enumerable: true,
  get: function get() {
    return _hue.EuiHue;
  }
});
Object.defineProperty(exports, "EuiSaturation", {
  enumerable: true,
  get: function get() {
    return _saturation.EuiSaturation;
  }
});
Object.defineProperty(exports, "EuiColorStops", {
  enumerable: true,
  get: function get() {
    return _color_stops.EuiColorStops;
  }
});
Object.defineProperty(exports, "EuiColorPalettePicker", {
  enumerable: true,
  get: function get() {
    return _color_palette_picker.EuiColorPalettePicker;
  }
});

var _color_picker = require("./color_picker");

var _color_picker_swatch = require("./color_picker_swatch");

var _hue = require("./hue");

var _saturation = require("./saturation");

var _color_stops = require("./color_stops");

var _color_palette_picker = require("./color_palette_picker");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiColorPicker.__docgenInfo = {
    description: '',
    displayName: 'EuiColorPicker',
    methods: [],
    props: {
      button: {
        defaultValue: null,
        description: 'Custom element to use instead of text input',
        name: 'button',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'Use the compressed style for EuiFieldText',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      display: {
        defaultValue: null,
        description: '',
        name: 'display',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiColorPickerDisplay',
          value: [{
            value: '"inline"'
          }, {
            value: '"default"'
          }]
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: 'Custom validation flag',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      mode: {
        defaultValue: null,
        description: 'Choose between swatches with gradient picker (default), swatches only, gradient picker only, or secondary input only.',
        name: 'mode',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiColorPickerMode',
          value: [{
            value: '"default"'
          }, {
            value: '"swatch"'
          }, {
            value: '"picker"'
          }, {
            value: '"secondaryInput"'
          }]
        }
      },
      popoverZIndex: {
        defaultValue: null,
        description: 'Custom z-index for the popover',
        name: 'popoverZIndex',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      swatches: {
        defaultValue: null,
        description: 'Array of hex strings (3 or 6 character) to use as swatch options. Defaults to EUI visualization colors',
        name: 'swatches',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'string[]'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input. It only shows when the `display` is set to `default`.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input. It only shows when the `display` is set to `default`.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      showAlpha: {
        defaultValue: null,
        description: 'Whether to render the alpha channel (opacity) value range slider.',
        name: 'showAlpha',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      format: {
        defaultValue: null,
        description: 'Will format the text input in the provided format when possible (hue and saturation selection)\nExceptions: Manual text input and swatches will display as-authored\nDefault is to display the last format entered by the user',
        name: 'format',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"hex" | "rgba"',
          value: [{
            value: '"hex"'
          }, {
            value: '"rgba"'
          }]
        }
      },
      secondaryInputDisplay: {
        defaultValue: null,
        description: 'Placement option for a secondary color value input.',
        name: 'secondaryInputDisplay',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"none" | "top" | "bottom"',
          value: [{
            value: '"none"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      isClearable: {
        defaultValue: null,
        description: 'Add a button to the primary input to clear its value.',
        name: 'isClearable',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      placeholder: {
        defaultValue: null,
        description: 'Text to replace the default \'Transparent\' placeholder for unset color values.',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'EuiColorPickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      color: {
        defaultValue: null,
        description: 'hex (string)\nRGB (as comma separated string)\nRGBa (as comma separated string)\nEmpty string will register as \'transparent\'',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'text (string, as entered or selected)\nhex (8-digit hex if alpha < 1, otherwise 6-digit hex)\nRGBa (as array; values of NaN if color is invalid)\nisValid (boolean signifying if the input text is a valid color)',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: true,
        type: {
          name: '(text: string, output: EuiColorPickerOutput) => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/color_picker/color_picker.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: false,
        type: {
          name: '() => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiColorPickerSwatch.__docgenInfo = {
    description: '',
    displayName: 'EuiColorPickerSwatch',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHue.__docgenInfo = {
    description: '',
    displayName: 'EuiHue',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hex: {
        defaultValue: null,
        description: '',
        name: 'hex',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      hue: {
        defaultValue: null,
        description: '',
        name: 'hue',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: undefined,
        required: true,
        type: {
          name: '(hue: number) => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSaturation.__docgenInfo = {
    description: '',
    displayName: 'EuiSaturation',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/color_picker/saturation.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: false,
        type: {
          name: '[number, number, number]'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/color_picker/saturation.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: true,
        type: {
          name: '(color: [number, number, number]) => void'
        }
      },
      hex: {
        defaultValue: null,
        description: '',
        name: 'hex',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiColorStops.__docgenInfo = {
    description: '',
    displayName: 'EuiColorStops',
    methods: [],
    props: {
      addColor: {
        defaultValue: null,
        description: '',
        name: 'addColor',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      colorStops: {
        defaultValue: null,
        description: '',
        name: 'colorStops',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: true,
        type: {
          name: 'ColorStop[]'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: true,
        type: {
          name: '(stops?: ColorStop[], isInvalid?: boolean) => void'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      invalid: {
        defaultValue: null,
        description: '',
        name: 'invalid',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      max: {
        defaultValue: null,
        description: '',
        name: 'max',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      min: {
        defaultValue: null,
        description: '',
        name: 'min',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      stopType: {
        defaultValue: null,
        description: '',
        name: 'stopType',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"fixed" | "gradient"',
          value: [{
            value: '"fixed"'
          }, {
            value: '"gradient"'
          }]
        }
      },
      mode: {
        defaultValue: null,
        description: '',
        name: 'mode',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiColorPickerMode',
          value: [{
            value: '"default"'
          }, {
            value: '"swatch"'
          }, {
            value: '"picker"'
          }, {
            value: '"secondaryInput"'
          }]
        }
      },
      swatches: {
        defaultValue: null,
        description: '',
        name: 'swatches',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'string[]'
        }
      },
      showAlpha: {
        defaultValue: null,
        description: '',
        name: 'showAlpha',
        parent: {
          fileName: 'eui/src/components/color_picker/color_stops/color_stops.tsx',
          name: 'EuiColorStopsProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiColorPalettePicker.__docgenInfo = {
    description: '',
    displayName: 'EuiColorPalettePicker',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'You must pass an `onChange` function to handle the update of the value',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(value: string) => void'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isOpen: {
        defaultValue: null,
        description: 'Controls whether the options are shown. Default: false',
        name: 'isOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/form/super_select/super_select_control.tsx',
          name: 'EuiSuperSelectControlProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      valueOfSelected: {
        defaultValue: null,
        description: '',
        name: 'valueOfSelected',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      itemClassName: {
        defaultValue: null,
        description: 'Classes for the context menu item',
        name: 'itemClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      popoverClassName: {
        defaultValue: null,
        description: 'Applied to the outermost wrapper (popover)',
        name: 'popoverClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      selectionDisplay: {
        defaultValue: null,
        description: 'Specify what should be displayed after a selection: a `palette` or `title`',
        name: 'selectionDisplay',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"title" | "palette"',
          value: [{
            value: '"title"'
          }, {
            value: '"palette"'
          }]
        }
      },
      palettes: {
        defaultValue: null,
        description: 'An array of one of the following objects: #EuiColorPalettePickerPaletteText, #EuiColorPalettePickerPaletteFixed, #EuiColorPalettePickerPaletteGradient',
        name: 'palettes',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiColorPalettePickerPaletteProps[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}