"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSaturation = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _predicate = require("../../services/predicate");

var _accessibility = require("../accessibility");

var _i18n = require("../i18n");

var _utils = require("./utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var EuiSaturation = (0, _react.forwardRef)(function (_ref, ref) {
  var className = _ref.className,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? [1, 0, 0] : _ref$color,
      _ref$dataTestSubj = _ref['data-test-subj'],
      dataTestSubj = _ref$dataTestSubj === void 0 ? 'euiSaturation' : _ref$dataTestSubj,
      hex = _ref.hex,
      id = _ref.id,
      onChange = _ref.onChange,
      _ref$tabIndex = _ref.tabIndex,
      tabIndex = _ref$tabIndex === void 0 ? 0 : _ref$tabIndex,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "color", "data-test-subj", "hex", "id", "onChange", "tabIndex"]);

  var _useState = (0, _react.useState)({
    left: 0,
    top: 0
  }),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      indicator = _useState2[0],
      setIndicator = _useState2[1];

  var _useState3 = (0, _react.useState)([]),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      lastColor = _useState4[0],
      setlastColor = _useState4[1];

  var boxRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    // Mimics `componentDidMount` and `componentDidUpdate`
    var _color = (0, _slicedToArray2.default)(color, 3),
        s = _color[1],
        v = _color[2];

    if (!(0, _predicate.isNil)(boxRef.current) && lastColor.join() !== color.join()) {
      var _boxRef$current$getBo = boxRef.current.getBoundingClientRect(),
          height = _boxRef$current$getBo.height,
          width = _boxRef$current$getBo.width;

      setIndicator({
        left: s * width,
        top: (1 - v) * height
      });
    }
  }, [color, lastColor]);

  var calculateColor = function calculateColor(_ref2) {
    var top = _ref2.top,
        height = _ref2.height,
        left = _ref2.left,
        width = _ref2.width;

    var _color2 = (0, _slicedToArray2.default)(color, 1),
        h = _color2[0];

    var s = left / width;
    var v = 1 - top / height;
    return [h, s, v];
  };

  var handleUpdate = function handleUpdate(box) {
    var left = box.left,
        top = box.top;
    setIndicator({
      left: left,
      top: top
    });
    var newColor = calculateColor(box);
    setlastColor(newColor);
    onChange(newColor);
  };

  var handleChange = function handleChange(location) {
    if ((0, _predicate.isNil)(boxRef) || (0, _predicate.isNil)(boxRef.current)) {
      return;
    }

    var box = (0, _utils.getEventPosition)(location, boxRef.current);
    handleUpdate(box);
  };

  var _useMouseMove = (0, _utils.useMouseMove)(handleChange, boxRef.current),
      _useMouseMove2 = (0, _slicedToArray2.default)(_useMouseMove, 2),
      handleMouseDown = _useMouseMove2[0],
      handleInteraction = _useMouseMove2[1];

  var handleKeyDown = function handleKeyDown(event) {
    if ((0, _predicate.isNil)(boxRef) || (0, _predicate.isNil)(boxRef.current)) {
      return;
    }

    var _boxRef$current$getBo2 = boxRef.current.getBoundingClientRect(),
        height = _boxRef$current$getBo2.height,
        width = _boxRef$current$getBo2.width;

    var left = indicator.left,
        top = indicator.top;
    var heightScale = height / 100;
    var widthScale = width / 100;
    var newLeft = left;
    var newTop = top;

    switch (event.key) {
      case _services.keys.ARROW_DOWN:
        event.preventDefault();
        newTop = top < height ? top + heightScale : height;
        break;

      case _services.keys.ARROW_LEFT:
        event.preventDefault();
        newLeft = left > 0 ? left - widthScale : 0;
        break;

      case _services.keys.ARROW_UP:
        event.preventDefault();
        newTop = top > 0 ? top - heightScale : 0;
        break;

      case _services.keys.ARROW_RIGHT:
        event.preventDefault();
        newLeft = left < width ? left + widthScale : width;
        break;

      default:
        return;
    }

    var newPosition = {
      left: newLeft,
      top: newTop
    };
    setIndicator(newPosition);
    var newColor = calculateColor(_objectSpread({
      width: width,
      height: height
    }, newPosition));
    onChange(newColor);
  };

  var classes = (0, _classnames.default)('euiSaturation', className);
  return _react.default.createElement(_i18n.EuiI18n, {
    token: "euiSaturation.roleDescription",
    default: "HSV color mode saturation and value selection"
  }, function (roleDescription) {
    return (// Unsure why this element causes errors as `tabIndex` and focus/interactivity (by extension) are accounted for.
      // eslint-disable-next-line jsx-a11y/aria-activedescendant-has-tabindex, jsx-a11y/no-noninteractive-element-interactions
      _react.default.createElement("div", (0, _extends2.default)({
        role: "application",
        "aria-roledescription": roleDescription,
        "aria-describedby": "".concat(id, "-saturationDescription"),
        "aria-activedescendant": "".concat(id, "-saturationIndicator"),
        onMouseDown: handleMouseDown,
        onTouchStart: handleInteraction,
        onTouchMove: handleInteraction,
        onKeyDown: handleKeyDown,
        ref: ref,
        tabIndex: tabIndex,
        className: classes,
        "data-test-subj": dataTestSubj,
        style: {
          background: "hsl(".concat(color[0], ", 100%, 50%)")
        }
      }, rest), _react.default.createElement(_accessibility.EuiScreenReaderOnly, null, _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
        token: "euiSaturation.screenReaderAnnouncement",
        default: "Use the arrow keys to navigate the square color gradient. The coordinates resulting from each key press will be used to calculate HSV color mode 'saturation' and 'value' numbers, in the range of 0 to 1. Left and right decrease and increase (respectively) the 'saturation' value. Up and down decrease and increase (respectively) the 'value' value."
      }))), _react.default.createElement(_accessibility.EuiScreenReaderOnly, null, _react.default.createElement("p", {
        "aria-live": "polite"
      }, hex)), _react.default.createElement("div", {
        className: "euiSaturation__lightness",
        ref: boxRef
      }, _react.default.createElement("div", {
        className: "euiSaturation__saturation"
      })), _react.default.createElement("div", {
        id: "".concat(id, "-saturationIndicator"),
        className: "euiSaturation__indicator",
        style: _objectSpread({}, indicator)
      }))
    );
  });
});
exports.EuiSaturation = EuiSaturation;
EuiSaturation.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  color: _propTypes.default.any,
  onChange: _propTypes.default.func.isRequired,
  hex: _propTypes.default.string
};
EuiSaturation.displayName = 'EuiSaturation';

try {
  EuiSaturation.__docgenInfo = {
    description: '',
    displayName: 'EuiSaturation',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/color_picker/saturation.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: false,
        type: {
          name: '[number, number, number]'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/color_picker/saturation.tsx',
          name: 'HTMLDivElementOverrides'
        },
        required: true,
        type: {
          name: '(color: [number, number, number]) => void'
        }
      },
      hex: {
        defaultValue: null,
        description: '',
        name: 'hex',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}