"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxInput = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactInputAutosize = _interopRequireDefault(require("react-input-autosize"));

var _accessibility = require("../../accessibility");

var _form_control_layout = require("../../form/form_control_layout");

var _combo_box_pill = require("./combo_box_pill");

var _services = require("../../../services");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiComboBoxInput =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiComboBoxInput, _Component);

  function EuiComboBoxInput() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiComboBoxInput);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiComboBoxInput)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      hasFocus: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updatePosition", function () {
      // Wait a beat for the DOM to update, since we depend on DOM elements' bounds.
      requestAnimationFrame(function () {
        _this.props.updatePosition();
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function (event) {
      _this.props.onFocus(event);

      _this.setState({
        hasFocus: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function (event) {
      if (_this.props.onBlur) {
        _this.props.onBlur(event);
      }

      _this.setState({
        hasFocus: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "inputOnChange", function (event) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          searchValue = _this$props.searchValue;

      if (onChange) {
        onChange(event.target.value);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "inputRefCallback", function (ref) {
      var autoSizeInputRef = _this.props.autoSizeInputRef;

      if (autoSizeInputRef) {
        autoSizeInputRef(ref);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiComboBoxInput, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var searchValue = prevProps.searchValue; // We need to update the position of everything if the user enters enough input to change
      // the size of the input.

      if (searchValue !== this.props.searchValue) {
        this.updatePosition();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          compressed = _this$props2.compressed,
          focusedOptionId = _this$props2.focusedOptionId,
          fullWidth = _this$props2.fullWidth,
          hasSelectedOptions = _this$props2.hasSelectedOptions,
          id = _this$props2.id,
          inputRef = _this$props2.inputRef,
          isDisabled = _this$props2.isDisabled,
          isListOpen = _this$props2.isListOpen,
          noIcon = _this$props2.noIcon,
          onClear = _this$props2.onClear,
          onClick = _this$props2.onClick,
          onCloseListClick = _this$props2.onCloseListClick,
          onOpenListClick = _this$props2.onOpenListClick,
          onRemoveOption = _this$props2.onRemoveOption,
          placeholder = _this$props2.placeholder,
          rootId = _this$props2.rootId,
          searchValue = _this$props2.searchValue,
          selectedOptions = _this$props2.selectedOptions,
          singleSelectionProp = _this$props2.singleSelection,
          toggleButtonRef = _this$props2.toggleButtonRef,
          value = _this$props2.value,
          prepend = _this$props2.prepend,
          append = _this$props2.append;
      var singleSelection = Boolean(singleSelectionProp);
      var asPlainText = singleSelectionProp && (0, _typeof2.default)(singleSelectionProp) === 'object' && singleSelectionProp.asPlainText || false;
      var pills = selectedOptions ? selectedOptions.map(function (option) {
        var label = option.label,
            color = option.color,
            onClick = option.onClick,
            rest = (0, _objectWithoutProperties2.default)(option, ["label", "color", "onClick"]);
        var pillOnClose = isDisabled || singleSelection || onClick ? undefined : onRemoveOption;
        return _react.default.createElement(_combo_box_pill.EuiComboBoxPill, (0, _extends2.default)({
          option: option,
          onClose: pillOnClose,
          key: label.toLowerCase(),
          color: color,
          onClick: onClick,
          onClickAriaLabel: onClick ? 'Change' : undefined,
          asPlainText: asPlainText
        }, rest), label);
      }) : null;
      var removeOptionMessage;
      var removeOptionMessageId;

      if (this.state.hasFocus) {
        var readPlaceholder = placeholder ? "".concat(placeholder, ".") : '';
        var removeOptionMessageContent = "Combo box. Selected. ".concat(searchValue ? "".concat(searchValue, ". Selected. ") : '').concat(selectedOptions && selectedOptions.length > 0 ? "".concat(value, ". Press Backspace to delete ").concat(selectedOptions[selectedOptions.length - 1].label, ". ") : '', "Combo box input. ").concat(readPlaceholder, " Type some text or, to display a list of choices, press Down Arrow. ") + 'To exit the list of choices, press Escape.';
        removeOptionMessageId = (0, _services.htmlIdGenerator)()(); // aria-live="assertive" will read this message aloud immediately once it enters the DOM.
        // We'll render to the DOM when the input gains focus and remove it when the input loses focus.
        // We'll use aria-hidden to prevent default aria information from being read by the screen
        // reader.

        removeOptionMessage = _react.default.createElement(_accessibility.EuiScreenReaderOnly, null, _react.default.createElement("span", {
          "aria-live": "assertive",
          id: removeOptionMessageId
        }, removeOptionMessageContent));
      }

      var placeholderMessage;

      if (placeholder && selectedOptions && !selectedOptions.length && !searchValue) {
        placeholderMessage = _react.default.createElement("p", {
          className: "euiComboBoxPlaceholder"
        }, placeholder);
      }

      var clickProps = {};

      if (!isDisabled && onClear && hasSelectedOptions) {
        clickProps.clear = {
          'data-test-subj': 'comboBoxClearButton',
          onClick: onClear
        };
      }

      var icon;

      if (!noIcon) {
        icon = {
          'aria-label': isListOpen ? 'Close list of options' : 'Open list of options',
          'data-test-subj': 'comboBoxToggleListButton',
          disabled: isDisabled,
          onClick: isListOpen && !isDisabled ? onCloseListClick : onOpenListClick,
          ref: toggleButtonRef,
          side: 'right',
          type: 'arrowDown'
        };
      }

      var wrapClasses = (0, _classnames.default)('euiComboBox__inputWrap', {
        'euiComboBox__inputWrap--compressed': compressed,
        'euiComboBox__inputWrap--fullWidth': fullWidth,
        'euiComboBox__inputWrap--noWrap': singleSelection,
        'euiComboBox__inputWrap-isClearable': onClear,
        'euiComboBox__inputWrap--inGroup': prepend || append
      });
      return _react.default.createElement(_form_control_layout.EuiFormControlLayout, (0, _extends2.default)({
        icon: icon
      }, clickProps, {
        compressed: compressed,
        fullWidth: fullWidth,
        prepend: prepend,
        append: append
      }), _react.default.createElement("div", {
        className: wrapClasses,
        "data-test-subj": "comboBoxInput",
        onClick: onClick,
        tabIndex: -1 // becomes onBlur event's relatedTarget, otherwise relatedTarget is null when clicking on this div

      }, !singleSelection || !searchValue ? pills : null, placeholderMessage, _react.default.createElement(_reactInputAutosize.default, {
        "aria-activedescendant": focusedOptionId,
        "aria-controls": isListOpen ? rootId('listbox') : '',
        className: "euiComboBox__input",
        "data-test-subj": "comboBoxSearchInput",
        disabled: isDisabled,
        id: id,
        inputRef: inputRef,
        onBlur: this.onBlur,
        onChange: this.inputOnChange,
        onFocus: this.onFocus,
        ref: this.inputRefCallback,
        role: "textbox",
        style: {
          fontSize: 14
        },
        value: searchValue
      }), removeOptionMessage));
    }
  }]);
  return EuiComboBoxInput;
}(_react.Component);

exports.EuiComboBoxInput = EuiComboBoxInput;
EuiComboBoxInput.propTypes = {
  autoSizeInputRef: _propTypes.default.any,
  compressed: _propTypes.default.bool.isRequired,
  focusedOptionId: _propTypes.default.string,
  fullWidth: _propTypes.default.bool,
  hasSelectedOptions: _propTypes.default.bool.isRequired,
  id: _propTypes.default.string,
  inputRef: _propTypes.default.any,
  isDisabled: _propTypes.default.bool,
  isListOpen: _propTypes.default.bool.isRequired,
  noIcon: _propTypes.default.bool.isRequired,
  onBlur: _propTypes.default.any,
  onChange: _propTypes.default.func,
  onClear: _propTypes.default.func,
  onClick: _propTypes.default.func,
  onCloseListClick: _propTypes.default.func.isRequired,
  onFocus: _propTypes.default.any.isRequired,
  onOpenListClick: _propTypes.default.func.isRequired,
  onRemoveOption: _propTypes.default.func,
  placeholder: _propTypes.default.string,
  rootId: _propTypes.default.any.isRequired,
  searchValue: _propTypes.default.string.isRequired,
  selectedOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any
  }).isRequired),
  singleSelection: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    asPlainText: _propTypes.default.bool
  }).isRequired]),
  toggleButtonRef: _propTypes.default.any,
  updatePosition: _propTypes.default.func.isRequired,
  value: _propTypes.default.string,
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiComboBoxInput.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxInput',
    methods: [],
    props: {
      autoSizeInputRef: {
        defaultValue: null,
        description: '',
        name: 'autoSizeInputRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(instance: AutosizeInput & HTMLInputElement) => void'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      focusedOptionId: {
        defaultValue: null,
        description: '',
        name: 'focusedOptionId',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasSelectedOptions: {
        defaultValue: null,
        description: '',
        name: 'hasSelectedOptions',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLInputElement) => void'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isListOpen: {
        defaultValue: null,
        description: '',
        name: 'isListOpen',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      noIcon: {
        defaultValue: null,
        description: '',
        name: 'noIcon',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(searchValue: string) => void'
        }
      },
      onClear: {
        defaultValue: null,
        description: '',
        name: 'onClear',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      onCloseListClick: {
        defaultValue: null,
        description: '',
        name: 'onCloseListClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '() => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onOpenListClick: {
        defaultValue: null,
        description: '',
        name: 'onOpenListClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '() => void'
        }
      },
      onRemoveOption: {
        defaultValue: null,
        description: '',
        name: 'onRemoveOption',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      placeholder: {
        defaultValue: null,
        description: '',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rootId: {
        defaultValue: null,
        description: '',
        name: 'rootId',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '(idSuffix?: string) => string'
        }
      },
      searchValue: {
        defaultValue: null,
        description: '',
        name: 'searchValue',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      selectedOptions: {
        defaultValue: null,
        description: '',
        name: 'selectedOptions',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: '',
        name: 'singleSelection',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'boolean | EuiComboBoxSingleSelectionShape'
        }
      },
      toggleButtonRef: {
        defaultValue: null,
        description: '',
        name: 'toggleButtonRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLButtonElement | HTMLSpanElement) => void'
        }
      },
      updatePosition: {
        defaultValue: null,
        description: '',
        name: 'updatePosition',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'UpdatePositionHandler'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      prepend: {
        defaultValue: null,
        description: '',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: '',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}