"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxOption = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../../services");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiComboBoxOption =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiComboBoxOption, _Component);

  function EuiComboBoxOption() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiComboBoxOption);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiComboBoxOption)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClick", function () {
      var _this$props = _this.props,
          onClick = _this$props.onClick,
          option = _this$props.option,
          disabled = _this$props.disabled;

      if (disabled) {
        return;
      }

      onClick(option);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeyDown", function (event) {
      if (event.key === _services.keys.ENTER || event.key === _services.keys.SPACE) {
        event.preventDefault();
        event.stopPropagation();
        var _this$props2 = _this.props,
            onEnterKey = _this$props2.onEnterKey,
            option = _this$props2.option,
            disabled = _this$props2.disabled;

        if (disabled) {
          return;
        }

        onEnterKey(option);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiComboBoxOption, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          children = _this$props3.children,
          className = _this$props3.className,
          disabled = _this$props3.disabled,
          isFocused = _this$props3.isFocused,
          onClick = _this$props3.onClick,
          onEnterKey = _this$props3.onEnterKey,
          option = _this$props3.option,
          optionRef = _this$props3.optionRef,
          rest = (0, _objectWithoutProperties2.default)(_this$props3, ["children", "className", "disabled", "isFocused", "onClick", "onEnterKey", "option", "optionRef"]);
      var classes = (0, _classnames.default)('euiComboBoxOption', className, {
        'euiComboBoxOption-isDisabled': disabled,
        'euiComboBoxOption-isFocused': isFocused
      });
      var label = option.label;
      return _react.default.createElement("button", (0, _extends2.default)({
        "aria-disabled": disabled,
        "aria-selected": isFocused,
        className: classes,
        onClick: this.onClick,
        onKeyDown: this.onKeyDown,
        ref: optionRef,
        role: "option",
        title: label,
        type: "button"
      }, rest), children);
    }
  }]);
  return EuiComboBoxOption;
}(_react.Component);

exports.EuiComboBoxOption = EuiComboBoxOption;
EuiComboBoxOption.propTypes = {
  children: _propTypes.default.node,
  className: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  isFocused: _propTypes.default.bool.isRequired,
  onClick: _propTypes.default.func.isRequired,
  onEnterKey: _propTypes.default.func.isRequired,
  option: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any
  }).isRequired,
  optionRef: _propTypes.default.any,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiComboBoxOption.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxOption',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isFocused: {
        defaultValue: null,
        description: '',
        name: 'isFocused',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      onEnterKey: {
        defaultValue: null,
        description: '',
        name: 'onEnterKey',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      option: {
        defaultValue: null,
        description: '',
        name: 'option',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>'
        }
      },
      optionRef: {
        defaultValue: null,
        description: '',
        name: 'optionRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLButtonElement) => void'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}