"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiContextMenuItem = exports.LAYOUT_ALIGN = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon = require("../icon");

var _tool_tip = require("../tool_tip");

var _services = require("../../services");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var layoutAlignToClassNames = {
  center: null,
  top: 'euiContextMenu__itemLayout--top',
  bottom: 'euiContextMenu__itemLayout--bottom'
};
var LAYOUT_ALIGN = (0, _common.keysOf)(layoutAlignToClassNames);
exports.LAYOUT_ALIGN = LAYOUT_ALIGN;

var EuiContextMenuItem =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiContextMenuItem, _Component);

  function EuiContextMenuItem() {
    (0, _classCallCheck2.default)(this, EuiContextMenuItem);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiContextMenuItem).apply(this, arguments));
  }

  (0, _createClass2.default)(EuiContextMenuItem, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          hasPanel = _this$props.hasPanel,
          icon = _this$props.icon,
          buttonRef = _this$props.buttonRef,
          disabled = _this$props.disabled,
          _this$props$layoutAli = _this$props.layoutAlign,
          layoutAlign = _this$props$layoutAli === void 0 ? 'center' : _this$props$layoutAli,
          toolTipTitle = _this$props.toolTipTitle,
          toolTipContent = _this$props.toolTipContent,
          _this$props$toolTipPo = _this$props.toolTipPosition,
          toolTipPosition = _this$props$toolTipPo === void 0 ? 'right' : _this$props$toolTipPo,
          href = _this$props.href,
          target = _this$props.target,
          rel = _this$props.rel,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className", "hasPanel", "icon", "buttonRef", "disabled", "layoutAlign", "toolTipTitle", "toolTipContent", "toolTipPosition", "href", "target", "rel"]);
      var iconInstance;

      if (icon) {
        switch ((0, _typeof2.default)(icon)) {
          case 'string':
            iconInstance = _react.default.createElement(_icon.EuiIcon, {
              type: icon,
              size: "m",
              className: "euiContextMenu__icon"
            });
            break;

          default:
            // Assume it's already an instance of an icon.
            iconInstance = (0, _react.cloneElement)(icon, {
              className: 'euiContextMenu__icon'
            });
        }
      }

      var arrow;

      if (hasPanel) {
        arrow = _react.default.createElement(_icon.EuiIcon, {
          type: "arrowRight",
          size: "m",
          className: "euiContextMenu__arrow"
        });
      }

      var classes = (0, _classnames.default)('euiContextMenuItem', className, {
        'euiContextMenuItem-isDisabled': disabled
      });
      var layoutClasses = (0, _classnames.default)('euiContextMenu__itemLayout', layoutAlignToClassNames[layoutAlign]);

      var buttonInner = _react.default.createElement("span", {
        className: layoutClasses
      }, iconInstance, _react.default.createElement("span", {
        className: "euiContextMenuItem__text"
      }, children), arrow);

      var button; // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
      // this is a button and piggyback off its disabled styles.

      if (href && !disabled) {
        var secureRel = (0, _services.getSecureRelForTarget)({
          href: href,
          target: target,
          rel: rel
        });
        button = _react.default.createElement("a", (0, _extends2.default)({
          className: classes,
          href: href,
          target: target,
          rel: secureRel,
          ref: buttonRef
        }, rest), buttonInner);
      } else {
        button = _react.default.createElement("button", (0, _extends2.default)({
          disabled: disabled,
          className: classes,
          type: "button",
          ref: buttonRef
        }, rest), buttonInner);
      }

      if (toolTipContent) {
        return _react.default.createElement(_tool_tip.EuiToolTip, {
          title: toolTipTitle ? toolTipTitle : null,
          content: toolTipContent,
          anchorClassName: "eui-displayBlock",
          position: toolTipPosition
        }, button);
      } else {
        return button;
      }
    }
  }]);
  return EuiContextMenuItem;
}(_react.Component);

exports.EuiContextMenuItem = EuiContextMenuItem;
EuiContextMenuItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  icon: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.string.isRequired, _propTypes.default.any.isRequired]),
  hasPanel: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onClick: _propTypes.default.func,
  buttonRef: _propTypes.default.any,

  /**
     * Required if using a tooltip. Add an optional tooltip on hover
     */
  toolTipContent: _propTypes.default.node,

  /**
     * Optional title for the tooltip
     */
  toolTipTitle: _propTypes.default.node,

  /**
     * Dictates the position of the tooltip.
     */
  toolTipPosition: _propTypes.default.oneOf(["top", "right", "bottom", "left"]),
  href: _propTypes.default.string,
  target: _propTypes.default.string,
  rel: _propTypes.default.string,

  /**
     * How to align icon with content of button
     */
  layoutAlign: _propTypes.default.oneOf(["center", "top", "bottom"])
};

try {
  EuiContextMenuItem.__docgenInfo = {
    description: '',
    displayName: 'EuiContextMenuItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'EuiContextMenuItemIcon'
        }
      },
      hasPanel: {
        defaultValue: null,
        description: '',
        name: 'hasPanel',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: '(event: any) => void'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'Ref<HTMLButtonElement>'
        }
      },
      toolTipContent: {
        defaultValue: null,
        description: 'Required if using a tooltip. Add an optional tooltip on hover',
        name: 'toolTipContent',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      toolTipTitle: {
        defaultValue: null,
        description: 'Optional title for the tooltip',
        name: 'toolTipTitle',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      toolTipPosition: {
        defaultValue: null,
        description: 'Dictates the position of the tooltip.',
        name: 'toolTipPosition',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      layoutAlign: {
        defaultValue: null,
        description: 'How to align icon with content of button',
        name: 'layoutAlign',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiContextMenuItemLayoutAlignment',
          value: [{
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"center"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}