"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderCell = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _accessibility = require("../../services/accessibility");

var _classnames2 = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _data_grid_column_resizer = require("./data_grid_column_resizer");

var _accessibility2 = require("../accessibility");

var _tabbable = _interopRequireDefault(require("tabbable"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiDataGridHeaderCell = function EuiDataGridHeaderCell(props) {
  var column = props.column,
      index = props.index,
      columnWidths = props.columnWidths,
      schema = props.schema,
      defaultColumnWidth = props.defaultColumnWidth,
      setColumnWidth = props.setColumnWidth,
      sorting = props.sorting,
      focusedCell = props.focusedCell,
      setFocusedCell = props.setFocusedCell,
      headerIsInteractive = props.headerIsInteractive,
      className = props.className;
  var id = column.id,
      display = column.display;
  var width = columnWidths[id] || defaultColumnWidth;
  var ariaProps = {};
  var screenReaderId;
  var sortString;

  if (sorting) {
    var sortedColumnIds = new Set(sorting.columns.map(function (_ref) {
      var id = _ref.id;
      return id;
    }));

    if (sorting.columns.length === 1 && sortedColumnIds.has(id)) {
      var sortDirection = sorting.columns[0].direction;
      var sortValue = 'other';

      if (sortDirection === 'asc') {
        sortValue = 'ascending';
      } else if (sortDirection === 'desc') {
        sortValue = 'descending';
      }

      ariaProps['aria-sort'] = sortValue;
    } else if (sorting.columns.length >= 2 && sortedColumnIds.has(id)) {
      sortString = sorting.columns.map(function (col) {
        return "Sorted by ".concat(col.id, " ").concat(col.direction);
      }).join(' then ');
      screenReaderId = (0, _accessibility.htmlIdGenerator)()();
      ariaProps['aria-describedby'] = screenReaderId;
    }
  }

  var columnType = schema[id] ? schema[id].columnType : null;
  var classes = (0, _classnames2.default)('euiDataGridHeaderCell', (0, _defineProperty2.default)({}, "euiDataGridHeaderCell--".concat(columnType), columnType), className);
  var headerRef = (0, _react.useRef)(null);
  var isFocused = focusedCell != null && focusedCell[0] === index && focusedCell[1] === -1;

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isCellEntered = _useState2[0],
      setIsCellEntered = _useState2[1];

  var enableInteractives = (0, _react.useCallback)(function () {
    if (headerRef.current) {
      var interactiveElements = headerRef.current.querySelectorAll('[data-euigrid-tab-managed]');

      for (var i = 0; i < interactiveElements.length; i++) {
        interactiveElements[i].setAttribute('tabIndex', '0');
      }
    }
  }, []);
  var disableInteractives = (0, _react.useCallback)(function () {
    if (headerRef.current) {
      var tababbles = (0, _tabbable.default)(headerRef.current);

      if (tababbles.length > 1) {
        console.warn("EuiDataGridHeaderCell expects at most 1 tabbable element, ".concat(tababbles.length, " found instead"));
      }

      for (var i = 0; i < tababbles.length; i++) {
        var element = tababbles[i];
        element.setAttribute('data-euigrid-tab-managed', 'true');
        element.setAttribute('tabIndex', '-1');
      }
    }
  }, []);
  (0, _react.useEffect)(function () {
    if (headerRef.current) {
      if (isCellEntered) {
        enableInteractives();
        var tabbables = (0, _tabbable.default)(headerRef.current);

        if (tabbables.length > 0) {
          tabbables[0].focus();
        }
      } else {
        disableInteractives();
      }
    }
  }, [disableInteractives, enableInteractives, isCellEntered]);
  (0, _react.useEffect)(function () {
    if (headerRef.current) {
      // focusin bubbles while focus does not, and this needs to react to children gaining focus
      var onFocusIn = function onFocusIn(e) {
        if (headerIsInteractive === false) {
          // header is not interactive, avoid focusing
          requestAnimationFrame(function () {
            return headerRef.current.blur();
          });
          e.preventDefault();
          return false;
        } else {
          // take the focus
          if (focusedCell == null || focusedCell[0] !== index || focusedCell[1] !== -1) {
            setFocusedCell([index, -1]);
          } else if (headerRef.current) {
            // this cell already had the grid's focus, so re-enable interactives
            enableInteractives();
            setIsCellEntered(true); // if there is only one interactive element shift focus to the interactive element

            var tabbables = (0, _tabbable.default)(headerRef.current);

            if (tabbables.length === 1) {
              tabbables[0].focus();
            }
          }
        }
      }; // focusout bubbles while blur does not, and this needs to react to the children losing focus


      var onFocusOut = function onFocusOut() {
        // wait for the next element to receive focus, then update interactives' state
        requestAnimationFrame(function () {
          if (headerRef.current) {
            if (headerRef.current.contains(document.activeElement) === false) {
              setIsCellEntered(false);
            }
          }
        });
      };

      var onKeyUp = function onKeyUp(event) {
        switch (event.key) {
          case _services.keys.ENTER:
            {
              event.preventDefault();
              setIsCellEntered(true);
              break;
            }

          case _services.keys.ESCAPE:
            {
              event.preventDefault(); // move focus to cell

              setIsCellEntered(false);
              headerRef.current.focus();
              break;
            }

          case _services.keys.F2:
            {
              event.preventDefault();

              if (document.activeElement === headerRef.current) {
                // move focus into cell's interactives
                setIsCellEntered(true);
              } else {
                // move focus to cell
                setIsCellEntered(false);
                headerRef.current.focus();
              }

              break;
            }
        }
      };

      if (isFocused) {
        var interactives = headerRef.current.querySelectorAll('[data-euigrid-tab-managed]');

        if (interactives.length === 1) {
          setIsCellEntered(true);
        } else {
          headerRef.current.focus();
        }
      } else {
        setIsCellEntered(false);
      }

      var headerNode = headerRef.current; // @ts-ignore-next line TS doesn't have focusin

      headerNode.addEventListener('focusin', onFocusIn);
      headerNode.addEventListener('focusout', onFocusOut);
      headerNode.addEventListener('keyup', onKeyUp);
      return function () {
        // @ts-ignore-next line TS doesn't have focusin
        headerNode.removeEventListener('focusin', onFocusIn);
        headerNode.removeEventListener('focusout', onFocusOut);
        headerNode.removeEventListener('keyup', onKeyUp);
      };
    }
  }, [enableInteractives, headerIsInteractive, isFocused, setIsCellEntered, focusedCell, setFocusedCell, index]);
  return _react.default.createElement("div", (0, _extends2.default)({
    role: "columnheader"
  }, ariaProps, {
    ref: headerRef,
    tabIndex: isFocused && !isCellEntered ? 0 : -1,
    className: classes,
    "data-test-subj": "dataGridHeaderCell-".concat(id),
    style: width != null ? {
      width: "".concat(width, "px")
    } : {}
  }), column.isResizable !== false && width != null ? _react.default.createElement(_data_grid_column_resizer.EuiDataGridColumnResizer, {
    columnId: id,
    columnWidth: width,
    setColumnWidth: setColumnWidth
  }) : null, _react.default.createElement("div", {
    className: "euiDataGridHeaderCell__content"
  }, display || id), sorting && sorting.columns.length >= 2 && _react.default.createElement(_accessibility2.EuiScreenReaderOnly, null, _react.default.createElement("div", {
    id: screenReaderId
  }, sortString)));
};

exports.EuiDataGridHeaderCell = EuiDataGridHeaderCell;
EuiDataGridHeaderCell.propTypes = {
  column: _propTypes.default.shape({
    /**
       * The unique identifier for this column
       */
    id: _propTypes.default.string.isRequired,

    /**
       * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
       */
    display: _propTypes.default.node,

    /**
       * A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
       */
    schema: _propTypes.default.string,

    /**
       * Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
       */
    isExpandable: _propTypes.default.bool,

    /**
       * Whether this column's width can be changed by the user, defaults to true
       */
    isResizable: _propTypes.default.bool,

    /**
       * Initial width (in pixels) of the column
       */
    initialWidth: _propTypes.default.number,

    /**
       * Whether this column is sortable
       */
    isSortable: _propTypes.default.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: _propTypes.default.oneOf(["asc", "desc"]),

    /**
       * Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.
       */
    displayAsText: _propTypes.default.string
  }).isRequired,
  index: _propTypes.default.number.isRequired,
  className: _propTypes.default.string
};

try {
  EuiDataGridHeaderCell.__docgenInfo = {
    description: '',
    displayName: 'EuiDataGridHeaderCell',
    methods: [],
    props: {
      column: {
        defaultValue: null,
        description: '',
        name: 'column',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_cell.tsx',
          name: 'EuiDataGridHeaderCellProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridColumn'
        }
      },
      index: {
        defaultValue: null,
        description: '',
        name: 'index',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_cell.tsx',
          name: 'EuiDataGridHeaderCellProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_cell.tsx',
          name: 'EuiDataGridHeaderCellProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      sorting: {
        defaultValue: null,
        description: '',
        name: 'sorting',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridSorting'
        }
      },
      schema: {
        defaultValue: null,
        description: '',
        name: 'schema',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridSchema'
        }
      },
      trailingControlColumns: {
        defaultValue: null,
        description: '',
        name: 'trailingControlColumns',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      columnWidths: {
        defaultValue: null,
        description: '',
        name: 'columnWidths',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: true,
        type: {
          name: 'EuiDataGridColumnWidths'
        }
      },
      defaultColumnWidth: {
        defaultValue: null,
        description: '',
        name: 'defaultColumnWidth',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      focusedCell: {
        defaultValue: null,
        description: '',
        name: 'focusedCell',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: false,
        type: {
          name: 'EuiDataGridFocusedCell'
        }
      },
      setColumnWidth: {
        defaultValue: null,
        description: '',
        name: 'setColumnWidth',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: true,
        type: {
          name: '(columnId: string, width: number) => void'
        }
      },
      setFocusedCell: {
        defaultValue: null,
        description: '',
        name: 'setFocusedCell',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: true,
        type: {
          name: 'Function'
        }
      },
      headerIsInteractive: {
        defaultValue: null,
        description: '',
        name: 'headerIsInteractive',
        parent: {
          fileName: 'eui/src/components/datagrid/data_grid_header_row.tsx',
          name: 'EuiDataGridHeaderRowPropsSpecificProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}