"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  EuiDataGrid: true
};
Object.defineProperty(exports, "EuiDataGrid", {
  enumerable: true,
  get: function get() {
    return _data_grid.EuiDataGrid;
  }
});

require("./column_sorting_draggable");

var _data_grid = require("./data_grid");

require("./data_grid_body");

require("./data_grid_cell");

require("./data_grid_column_resizer");

require("./data_grid_data_row");

require("./data_grid_header_row");

require("./data_grid_header_cell");

require("./data_grid_control_header_cell");

require("./data_grid_inmemory_renderer");

require("./data_grid_schema");

var _data_grid_types = require("./data_grid_types");

Object.keys(_data_grid_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _data_grid_types[key];
    }
  });
});

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiDataGrid.__docgenInfo = {
    description: '',
    displayName: 'EuiDataGrid',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      pagination: {
        defaultValue: null,
        description: 'A #EuiDataGridPagination object. Omit to disable pagination completely.',
        name: 'pagination',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridPaginationProps'
        }
      },
      columns: {
        defaultValue: null,
        description: 'An array of #EuiDataGridColumn objects. Lists the columns available and the schema and settings tied to it.',
        name: 'columns',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridColumn[]'
        }
      },
      sorting: {
        defaultValue: null,
        description: 'A #EuiDataGridSorting oject that provides the sorted columns along with their direction. Omit to disable, but you\'ll likely want to also turn off the user sorting controls through the `toolbarVisibility` prop.',
        name: 'sorting',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridSorting'
        }
      },
      schemaDetectors: {
        defaultValue: null,
        description: 'An array of custom #EuiDataGridSchemaDetector objects. You can inject custom schemas to the grid to define the classnames applied',
        name: 'schemaDetectors',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridSchemaDetector[]'
        }
      },
      leadingControlColumns: {
        defaultValue: null,
        description: 'An array of #EuiDataGridControlColumn objects. Used to define ancillary columns on the left side of the data grid.',
        name: 'leadingControlColumns',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      trailingControlColumns: {
        defaultValue: null,
        description: 'An array of #EuiDataGridControlColumn objects. Used to define ancillary columns on the right side of the data grid.',
        name: 'trailingControlColumns',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridControlColumn[]'
        }
      },
      columnVisibility: {
        defaultValue: null,
        description: 'An array of #EuiDataGridColumnVisibility objects. Defines which columns are visible in the grid and the order they are displayed.',
        name: 'columnVisibility',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiDataGridColumnVisibility'
        }
      },
      popoverContents: {
        defaultValue: null,
        description: 'An object mapping #EuiDataGridColumn `schema`s to a custom popover formatting component which receives #EuiDataGridPopoverContent props',
        name: 'popoverContents',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridPopoverContents'
        }
      },
      rowCount: {
        defaultValue: null,
        description: 'The total number of rows in the dataset (used by e.g. pagination to know how many pages to list)',
        name: 'rowCount',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      renderCellValue: {
        defaultValue: null,
        description: 'A function called to render a cell\'s value. Behind the scenes it is treated as a React component\nallowing hooks, context, and other React concepts to be used. The function receives a #CellValueElement\nas its only argument.',
        name: 'renderCellValue',
        parent: undefined,
        required: true,
        type: {
          name: '((props: EuiDataGridCellValueElementProps) => ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)>) | (new (props: EuiDataGridCellValueElementProps) => Component<...>) | ((props: EuiDataGridCellValueEleme...'
        }
      },
      gridStyle: {
        defaultValue: null,
        description: 'Defines the look and feel for the grid. Accepts a partial #EuiDataGridStyle object. Settings provided may be overwritten or merged with user defined preferences if toolbarVisibility density controls are available.',
        name: 'gridStyle',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridStyle'
        }
      },
      toolbarVisibility: {
        defaultValue: null,
        description: 'Accepts either a boolean or #EuiDataGridToolbarVisibilityOptions object. When used as a boolean, defines the display of the toolbar entire. WHen passed an object allows you to turn off individual controls within the toolbar as well as add additional buttons.',
        name: 'toolbarVisibility',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | EuiDataGridToolBarVisibilityOptions'
        }
      },
      inMemory: {
        defaultValue: null,
        description: 'A #EuiDataGridInMemory object to definite the level of high order schema-detection and sorting logic to use on your data. *Try to set when possible*. When ommited, disables all enhancements and assumes content is flat strings.',
        name: 'inMemory',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridInMemory'
        }
      },
      onColumnResize: {
        defaultValue: null,
        description: 'A callback for when a column\'s size changes. Callback receives `{ columnId: string, width: number }`.',
        name: 'onColumnResize',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiDataGridOnColumnResizeHandler'
        }
      },
      minSizeForControls: {
        defaultValue: null,
        description: 'Defines a minimum width for the grid to show all controls in its header.',
        name: 'minSizeForControls',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}