"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRecentlyUsed = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _pretty_duration = require("../pretty_duration");

var _flex = require("../../../flex");

var _title = require("../../../title");

var _spacer = require("../../../spacer");

var _link = require("../../../link");

var _text = require("../../../text");

var _horizontal_rule = require("../../../horizontal_rule");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiRecentlyUsed = function EuiRecentlyUsed(_ref) {
  var applyTime = _ref.applyTime,
      commonlyUsedRanges = _ref.commonlyUsedRanges,
      dateFormat = _ref.dateFormat,
      _ref$recentlyUsedRang = _ref.recentlyUsedRanges,
      recentlyUsedRanges = _ref$recentlyUsedRang === void 0 ? [] : _ref$recentlyUsedRang;

  if (recentlyUsedRanges.length === 0) {
    return null;
  }

  var links = recentlyUsedRanges.map(function (_ref2) {
    var start = _ref2.start,
        end = _ref2.end;

    var applyRecentlyUsed = function applyRecentlyUsed() {
      applyTime({
        start: start,
        end: end
      });
    };

    return _react.default.createElement(_flex.EuiFlexItem, {
      grow: false,
      key: "".concat(start, "-").concat(end)
    }, _react.default.createElement(_link.EuiLink, {
      onClick: applyRecentlyUsed
    }, (0, _pretty_duration.prettyDuration)(start, end, commonlyUsedRanges, dateFormat)));
  });
  return _react.default.createElement(_react.Fragment, null, _react.default.createElement(_title.EuiTitle, {
    size: "xxxs"
  }, _react.default.createElement("span", null, "Recently used date ranges")), _react.default.createElement(_spacer.EuiSpacer, {
    size: "s"
  }), _react.default.createElement(_text.EuiText, {
    size: "s",
    className: "euiQuickSelectPopover__section"
  }, _react.default.createElement(_flex.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, links)), _react.default.createElement(_horizontal_rule.EuiHorizontalRule, {
    margin: "s"
  }));
};

exports.EuiRecentlyUsed = EuiRecentlyUsed;
EuiRecentlyUsed.propTypes = {
  applyTime: _propTypes.default.func.isRequired,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  dateFormat: _propTypes.default.string.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired)
};
EuiRecentlyUsed.displayName = 'EuiRecentlyUsed';

try {
  EuiRecentlyUsed.__docgenInfo = {
    description: '',
    displayName: 'EuiRecentlyUsed',
    methods: [],
    props: {
      applyTime: {
        defaultValue: null,
        description: '',
        name: 'applyTime',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: true,
        type: {
          name: 'ApplyTime'
        }
      },
      commonlyUsedRanges: {
        defaultValue: null,
        description: '',
        name: 'commonlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: true,
        type: {
          name: 'DurationRange[]'
        }
      },
      dateFormat: {
        defaultValue: null,
        description: '',
        name: 'dateFormat',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      recentlyUsedRanges: {
        defaultValue: {
          value: '[]'
        },
        description: '',
        name: 'recentlyUsedRanges',
        parent: {
          fileName: 'eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used.tsx',
          name: 'EuiRecentlyUsedProps'
        },
        required: false,
        type: {
          name: 'DurationRange[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}