"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "prettyDuration", {
  enumerable: true,
  get: function get() {
    return _pretty_duration.prettyDuration;
  }
});
Object.defineProperty(exports, "commonDurationRanges", {
  enumerable: true,
  get: function get() {
    return _pretty_duration.commonDurationRanges;
  }
});
exports.EuiSuperDatePicker = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _pretty_duration = require("./pretty_duration");

var _pretty_interval = require("./pretty_interval");

var _datemath = _interopRequireDefault(require("@elastic/datemath"));

var _super_update_button = require("./super_update_button");

var _quick_select_popover = require("./quick_select_popover/quick_select_popover");

var _date_popover_button = require("./date_popover/date_popover_button");

var _date_picker_range = require("../date_picker_range");

var _form = require("../../form");

var _flex = require("../../flex");

var _async_interval = require("./async_interval");

var _i18n = require("../../i18n");

var _context = require("../../context");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// eslint-disable-line import/named
function isRangeInvalid(start, end) {
  if (start === 'now' && end === 'now') {
    return true;
  }

  var startMoment = _datemath.default.parse(start);

  var endMoment = _datemath.default.parse(end, {
    roundUp: true
  });

  if (!startMoment || !endMoment || !startMoment.isValid() || !endMoment.isValid()) {
    return true;
  }

  if (startMoment.isAfter(endMoment)) {
    return true;
  }

  return false;
}

var EuiSuperDatePicker =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiSuperDatePicker, _Component);

  function EuiSuperDatePicker() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiSuperDatePicker);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiSuperDatePicker)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "asyncInterval", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      prevProps: {
        start: _this.props.start,
        end: _this.props.end
      },
      start: _this.props.start,
      end: _this.props.end,
      isInvalid: isRangeInvalid(_this.props.start, _this.props.end),
      hasChanged: false,
      showPrettyDuration: (0, _pretty_duration.showPrettyDuration)(_this.props.start, _this.props.end, _this.props.commonlyUsedRanges),
      isStartDatePopoverOpen: false,
      isEndDatePopoverOpen: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setTime", function (_ref) {
      var end = _ref.end,
          start = _ref.start;
      var isInvalid = isRangeInvalid(start, end);

      _this.setState({
        start: start,
        end: end,
        isInvalid: isInvalid,
        hasChanged: true
      });

      if (!_this.props.showUpdateButton) {
        _this.props.onTimeChange({
          start: start,
          end: end,
          isQuickSelection: false,
          isInvalid: isInvalid
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "componentDidMount", function () {
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "componentDidUpdate", function () {
      _this.stopInterval();

      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "componentWillUnmount", function () {
      _this.stopInterval();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setStart", function (start) {
      _this.setTime({
        start: start,
        end: _this.state.end
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setEnd", function (end) {
      _this.setTime({
        start: _this.state.start,
        end: end
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "applyTime", function () {
      _this.props.onTimeChange({
        start: _this.state.start,
        end: _this.state.end,
        isQuickSelection: false,
        isInvalid: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "applyQuickTime", function (_ref2) {
      var start = _ref2.start,
          end = _ref2.end;

      _this.setState({
        showPrettyDuration: (0, _pretty_duration.showPrettyDuration)(start, end, _pretty_duration.commonDurationRanges)
      });

      _this.props.onTimeChange({
        start: start,
        end: end,
        isQuickSelection: true,
        isInvalid: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hidePrettyDuration", function () {
      _this.setState({
        showPrettyDuration: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStartDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isStartDatePopoverOpen: !prevState.isStartDatePopoverOpen
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStartDatePopoverClose", function () {
      _this.setState({
        isStartDatePopoverOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEndDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isEndDatePopoverOpen: !prevState.isEndDatePopoverOpen
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEndDatePopoverClose", function () {
      _this.setState({
        isEndDatePopoverOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRefreshChange", function (_ref3) {
      var refreshInterval = _ref3.refreshInterval,
          isPaused = _ref3.isPaused;

      _this.stopInterval();

      if (!isPaused) {
        _this.startInterval(refreshInterval);
      }

      if (_this.props.onRefreshChange) {
        _this.props.onRefreshChange({
          refreshInterval: refreshInterval,
          isPaused: isPaused
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "stopInterval", function () {
      if (_this.asyncInterval) {
        _this.asyncInterval.stop();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "startInterval", function (refreshInterval) {
      var onRefresh = _this.props.onRefresh;

      if (onRefresh) {
        var handler = function handler() {
          var _this$props = _this.props,
              start = _this$props.start,
              end = _this$props.end;
          onRefresh({
            start: start,
            end: end,
            refreshInterval: refreshInterval
          });
        };

        _this.asyncInterval = new _async_interval.AsyncInterval(handler, refreshInterval);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderDatePickerRange", function () {
      var _this$state = _this.state,
          end = _this$state.end,
          hasChanged = _this$state.hasChanged,
          isEndDatePopoverOpen = _this$state.isEndDatePopoverOpen,
          isInvalid = _this$state.isInvalid,
          isStartDatePopoverOpen = _this$state.isStartDatePopoverOpen,
          showPrettyDuration = _this$state.showPrettyDuration,
          start = _this$state.start;
      var _this$props2 = _this.props,
          commonlyUsedRanges = _this$props2.commonlyUsedRanges,
          dateFormat = _this$props2.dateFormat,
          isAutoRefreshOnly = _this$props2.isAutoRefreshOnly,
          isDisabled = _this$props2.isDisabled,
          isPaused = _this$props2.isPaused,
          locale = _this$props2.locale,
          refreshInterval = _this$props2.refreshInterval,
          timeFormat = _this$props2.timeFormat,
          utcOffset = _this$props2.utcOffset;

      if (isAutoRefreshOnly) {
        return _react.default.createElement(_date_picker_range.EuiDatePickerRange, {
          className: "euiDatePickerRange--inGroup",
          iconType: false,
          isCustom: true,
          startDateControl: _react.default.createElement("div", null),
          endDateControl: _react.default.createElement("div", null),
          readOnly: true
        }, _react.default.createElement("span", {
          className: "euiSuperDatePicker__prettyFormat"
        }, (0, _pretty_interval.prettyInterval)(Boolean(isPaused), refreshInterval)));
      }

      if (showPrettyDuration && !isStartDatePopoverOpen && !isEndDatePopoverOpen) {
        return _react.default.createElement(_date_picker_range.EuiDatePickerRange, {
          className: "euiDatePickerRange--inGroup",
          iconType: false,
          isCustom: true,
          startDateControl: _react.default.createElement("div", null),
          endDateControl: _react.default.createElement("div", null)
        }, _react.default.createElement("button", {
          className: (0, _classnames.default)('euiSuperDatePicker__prettyFormat', {
            'euiSuperDatePicker__prettyFormat--disabled': isDisabled
          }),
          "data-test-subj": "superDatePickerShowDatesButton",
          disabled: isDisabled,
          onClick: _this.hidePrettyDuration
        }, (0, _pretty_duration.prettyDuration)(start, end, commonlyUsedRanges, dateFormat), _react.default.createElement("span", {
          className: "euiSuperDatePicker__prettyFormatLink"
        }, _react.default.createElement(_i18n.EuiI18n, {
          token: "euiSuperDatePicker.showDatesButtonLabel",
          default: "Show dates"
        }))));
      }

      return _react.default.createElement(_context.EuiI18nConsumer, null, function (_ref4) {
        var contextLocale = _ref4.locale;
        return _react.default.createElement(_date_picker_range.EuiDatePickerRange, {
          className: "euiDatePickerRange--inGroup",
          iconType: false,
          isCustom: true,
          startDateControl: _react.default.createElement(_date_popover_button.EuiDatePopoverButton, {
            className: "euiSuperDatePicker__startPopoverButton",
            position: "start",
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: isDisabled,
            onChange: _this.setStart,
            value: start,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            isOpen: _this.state.isStartDatePopoverOpen,
            onPopoverToggle: _this.onStartDatePopoverToggle,
            onPopoverClose: _this.onStartDatePopoverClose
          }),
          endDateControl: _react.default.createElement(_date_popover_button.EuiDatePopoverButton, {
            position: "end",
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: isDisabled,
            onChange: _this.setEnd,
            value: end,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            roundUp: true,
            isOpen: _this.state.isEndDatePopoverOpen,
            onPopoverToggle: _this.onEndDatePopoverToggle,
            onPopoverClose: _this.onEndDatePopoverClose
          })
        });
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClickUpdateButton", function () {
      if (!_this.state.hasChanged && _this.props.onRefresh) {
        var _this$props3 = _this.props,
            start = _this$props3.start,
            end = _this$props3.end,
            refreshInterval = _this$props3.refreshInterval;

        _this.props.onRefresh({
          start: start,
          end: end,
          refreshInterval: refreshInterval
        });
      } else {
        _this.applyTime();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderUpdateButton", function () {
      if (!_this.props.showUpdateButton || _this.props.isAutoRefreshOnly) {
        return;
      }

      return _react.default.createElement(_flex.EuiFlexItem, {
        grow: false
      }, _react.default.createElement(_super_update_button.EuiSuperUpdateButton, {
        needsUpdate: _this.state.hasChanged,
        showTooltip: !_this.state.isStartDatePopoverOpen && !_this.state.isEndDatePopoverOpen,
        isLoading: _this.props.isLoading,
        isDisabled: _this.props.isDisabled || _this.state.isInvalid,
        onClick: _this.handleClickUpdateButton,
        "data-test-subj": "superDatePickerApplyTimeButton"
      }));
    });
    return _this;
  }

  (0, _createClass2.default)(EuiSuperDatePicker, [{
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          commonlyUsedRanges = _this$props4.commonlyUsedRanges,
          customQuickSelectPanels = _this$props4.customQuickSelectPanels,
          dateFormat = _this$props4.dateFormat,
          end = _this$props4.end,
          isAutoRefreshOnly = _this$props4.isAutoRefreshOnly,
          isDisabled = _this$props4.isDisabled,
          isPaused = _this$props4.isPaused,
          onRefreshChange = _this$props4.onRefreshChange,
          recentlyUsedRanges = _this$props4.recentlyUsedRanges,
          refreshInterval = _this$props4.refreshInterval,
          showUpdateButton = _this$props4.showUpdateButton,
          start = _this$props4.start;

      var quickSelect = _react.default.createElement(_quick_select_popover.EuiQuickSelectPopover, {
        applyRefreshInterval: onRefreshChange ? this.onRefreshChange : undefined,
        applyTime: this.applyQuickTime,
        commonlyUsedRanges: commonlyUsedRanges,
        customQuickSelectPanels: customQuickSelectPanels,
        dateFormat: dateFormat,
        end: end,
        isAutoRefreshOnly: isAutoRefreshOnly,
        isDisabled: isDisabled,
        isPaused: isPaused,
        recentlyUsedRanges: recentlyUsedRanges,
        refreshInterval: refreshInterval,
        start: start
      });

      var flexWrapperClasses = (0, _classnames.default)('euiSuperDatePicker__flexWrapper', {
        'euiSuperDatePicker__flexWrapper--noUpdateButton': !showUpdateButton,
        'euiSuperDatePicker__flexWrapper--isAutoRefreshOnly': isAutoRefreshOnly
      });
      return _react.default.createElement(_flex.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        className: flexWrapperClasses
      }, _react.default.createElement(_flex.EuiFlexItem, null, _react.default.createElement(_form.EuiFormControlLayout, {
        className: "euiSuperDatePicker",
        isDisabled: isDisabled,
        prepend: quickSelect
      }, this.renderDatePickerRange())), this.renderUpdateButton());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.start !== prevState.prevProps.start || nextProps.end !== prevState.prevProps.end) {
        return {
          prevProps: {
            start: nextProps.start,
            end: nextProps.end
          },
          start: nextProps.start,
          end: nextProps.end,
          isInvalid: isRangeInvalid(nextProps.start, nextProps.end),
          hasChanged: false,
          showPrettyDuration: (0, _pretty_duration.showPrettyDuration)(nextProps.start, nextProps.end, nextProps.commonlyUsedRanges)
        };
      }

      return null;
    }
  }]);
  return EuiSuperDatePicker;
}(_react.Component);

exports.EuiSuperDatePicker = EuiSuperDatePicker;
(0, _defineProperty2.default)(EuiSuperDatePicker, "defaultProps", {
  commonlyUsedRanges: _pretty_duration.commonDurationRanges,
  dateFormat: 'MMM D, YYYY @ HH:mm:ss.SSS',
  end: 'now',
  isAutoRefreshOnly: false,
  isDisabled: false,
  isPaused: true,
  recentlyUsedRanges: [],
  refreshInterval: 0,
  showUpdateButton: true,
  start: 'now-15m',
  timeFormat: 'HH:mm'
});
EuiSuperDatePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    content: _propTypes.default.element.isRequired
  }).isRequired),

  /**
     * Specifies the formatted used when displaying dates and/or datetimes
     */
  dateFormat: _propTypes.default.string.isRequired,
  end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,

  /**
     * Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.
     */
  isAutoRefreshOnly: _propTypes.default.bool.isRequired,
  isDisabled: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool,
  isPaused: _propTypes.default.bool.isRequired,

  /**
     * Used to localize e.g. month names, passed to `moment`
     */
  locale: _propTypes.default.any,

  /**
     * Callback for when the refresh interval is fired.
     * EuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied
     * If a promise is returned, the next refresh interval will not start until the promise has resolved.
     * If the promise rejects the refresh interval will stop and the error thrown
     */
  onRefresh: _propTypes.default.func,

  /**
     * Callback for when the refresh interval changes.
     * Supply onRefreshChange to show refresh interval inputs in quick select popover
     */
  onRefreshChange: _propTypes.default.func,

  /**
     * Callback for when the time changes.
     */
  onTimeChange: _propTypes.default.func.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,

  /**
     * Refresh interval in milliseconds
     */
  refreshInterval: _propTypes.default.number.isRequired,

  /**
     * Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.
     */
  showUpdateButton: _propTypes.default.bool.isRequired,
  start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,

  /**
     * Specifies the formatted used when displaying times
     */
  timeFormat: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number
};

try {
  EuiSuperDatePicker.__docgenInfo = {
    description: '',
    displayName: 'EuiSuperDatePicker',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      commonlyUsedRanges: {
        defaultValue: {
          value: null
        },
        description: '',
        name: 'commonlyUsedRanges',
        parent: undefined,
        required: false,
        type: {
          name: 'DurationRange[]'
        }
      },
      customQuickSelectPanels: {
        defaultValue: null,
        description: '',
        name: 'customQuickSelectPanels',
        parent: undefined,
        required: false,
        type: {
          name: 'QuickSelectPanel[]'
        }
      },
      dateFormat: {
        defaultValue: {
          value: 'MMM D, YYYY @ HH:mm:ss.SSS'
        },
        description: 'Specifies the formatted used when displaying dates and/or datetimes',
        name: 'dateFormat',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      end: {
        defaultValue: {
          value: 'now'
        },
        description: '',
        name: 'end',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isAutoRefreshOnly: {
        defaultValue: {
          value: 'false'
        },
        description: 'Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.',
        name: 'isAutoRefreshOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isPaused: {
        defaultValue: {
          value: 'true'
        },
        description: '',
        name: 'isPaused',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      locale: {
        defaultValue: null,
        description: 'Used to localize e.g. month names, passed to `moment`',
        name: 'locale',
        parent: undefined,
        required: false,
        type: {
          name: 'LocaleSpecifier'
        }
      },
      onRefresh: {
        defaultValue: null,
        description: 'Callback for when the refresh interval is fired.\nEuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied\nIf a promise is returned, the next refresh interval will not start until the promise has resolved.\nIf the promise rejects the refresh interval will stop and the error thrown',
        name: 'onRefresh',
        parent: undefined,
        required: false,
        type: {
          name: '(props: OnRefreshProps) => void'
        }
      },
      onRefreshChange: {
        defaultValue: null,
        description: 'Callback for when the refresh interval changes.\nSupply onRefreshChange to show refresh interval inputs in quick select popover',
        name: 'onRefreshChange',
        parent: undefined,
        required: false,
        type: {
          name: 'ApplyRefreshInterval'
        }
      },
      onTimeChange: {
        defaultValue: null,
        description: 'Callback for when the time changes.',
        name: 'onTimeChange',
        parent: undefined,
        required: true,
        type: {
          name: '(props: OnTimeChangeProps) => void'
        }
      },
      recentlyUsedRanges: {
        defaultValue: {
          value: '[]'
        },
        description: '',
        name: 'recentlyUsedRanges',
        parent: undefined,
        required: false,
        type: {
          name: 'DurationRange[]'
        }
      },
      refreshInterval: {
        defaultValue: {
          value: '0'
        },
        description: 'Refresh interval in milliseconds',
        name: 'refreshInterval',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      showUpdateButton: {
        defaultValue: {
          value: 'true'
        },
        description: 'Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.',
        name: 'showUpdateButton',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      start: {
        defaultValue: {
          value: 'now-15m'
        },
        description: '',
        name: 'start',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      timeFormat: {
        defaultValue: {
          value: 'HH:mm'
        },
        description: 'Specifies the formatted used when displaying times',
        name: 'timeFormat',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      utcOffset: {
        defaultValue: null,
        description: '',
        name: 'utcOffset',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}