"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDragDropContext = exports.EuiDragDropContextContext = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _reactBeautifulDnd = require("react-beautiful-dnd");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiDragDropContextContext = (0, _react.createContext)({
  isDraggingType: null
});
exports.EuiDragDropContextContext = EuiDragDropContextContext;

var EuiDragDropContext = function EuiDragDropContext(_ref) {
  var onBeforeDragStart = _ref.onBeforeDragStart,
      onDragStart = _ref.onDragStart,
      onDragUpdate = _ref.onDragUpdate,
      onDragEnd = _ref.onDragEnd,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["onBeforeDragStart", "onDragStart", "onDragUpdate", "onDragEnd", "children"]);

  var _useState = (0, _react.useState)(null),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isDraggingType = _useState2[0],
      setIsDraggingType = _useState2[1];

  var euiOnDragStart = function euiOnDragStart(start, provided) {
    setIsDraggingType(start.type);

    if (onDragStart) {
      onDragStart(start, provided);
    }
  };

  var euiOnDragEnd = function euiOnDragEnd(result, provided) {
    setIsDraggingType(null);

    if (onDragEnd) {
      onDragEnd(result, provided);
    }
  };

  return _react.default.createElement(_reactBeautifulDnd.DragDropContext, (0, _extends2.default)({
    onBeforeDragStart: onBeforeDragStart,
    onDragStart: euiOnDragStart,
    onDragUpdate: onDragUpdate,
    onDragEnd: euiOnDragEnd
  }, rest), _react.default.createElement(EuiDragDropContextContext.Provider, {
    value: {
      isDraggingType: isDraggingType
    }
  }, children));
};

exports.EuiDragDropContext = EuiDragDropContext;

try {
  EuiDragDropContext.__docgenInfo = {
    description: '',
    displayName: 'EuiDragDropContext',
    methods: [],
    props: {
      onBeforeCapture: {
        defaultValue: null,
        description: '',
        name: 'onBeforeCapture',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(before: BeforeCapture) => void'
        }
      },
      onBeforeDragStart: {
        defaultValue: null,
        description: '',
        name: 'onBeforeDragStart',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(initial: DragStart) => void'
        }
      },
      onDragStart: {
        defaultValue: null,
        description: '',
        name: 'onDragStart',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(initial: DragStart, provided: ResponderProvided) => void'
        }
      },
      onDragUpdate: {
        defaultValue: null,
        description: '',
        name: 'onDragUpdate',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(initial: DragUpdate, provided: ResponderProvided) => void'
        }
      },
      onDragEnd: {
        defaultValue: null,
        description: '',
        name: 'onDragEnd',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: true,
        type: {
          name: '(result: DropResult, provided: ResponderProvided) => void'
        }
      },
      sensors: {
        defaultValue: null,
        description: '',
        name: 'sensors',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: 'Sensor[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}