"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiDragDropContext", {
  enumerable: true,
  get: function get() {
    return _drag_drop_context.EuiDragDropContext;
  }
});
Object.defineProperty(exports, "EuiDraggable", {
  enumerable: true,
  get: function get() {
    return _draggable.EuiDraggable;
  }
});
Object.defineProperty(exports, "EuiDroppable", {
  enumerable: true,
  get: function get() {
    return _droppable.EuiDroppable;
  }
});
Object.defineProperty(exports, "euiDragDropCopy", {
  enumerable: true,
  get: function get() {
    return _services.euiDragDropCopy;
  }
});
Object.defineProperty(exports, "euiDragDropMove", {
  enumerable: true,
  get: function get() {
    return _services.euiDragDropMove;
  }
});
Object.defineProperty(exports, "euiDragDropReorder", {
  enumerable: true,
  get: function get() {
    return _services.euiDragDropReorder;
  }
});

var _drag_drop_context = require("./drag_drop_context");

var _draggable = require("./draggable");

var _droppable = require("./droppable");

var _services = require("./services");

require("react-beautiful-dnd");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// Interfaces in react-beautiful-dnd that EUI abstracts over
// allows consumers to pull these from EUI instead of react-beautiful-dnd
try {
  EuiDragDropContext.__docgenInfo = {
    description: '',
    displayName: 'EuiDragDropContext',
    methods: [],
    props: {
      onBeforeCapture: {
        defaultValue: null,
        description: '',
        name: 'onBeforeCapture',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(before: BeforeCapture) => void'
        }
      },
      onBeforeDragStart: {
        defaultValue: null,
        description: '',
        name: 'onBeforeDragStart',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(initial: DragStart) => void'
        }
      },
      onDragStart: {
        defaultValue: null,
        description: '',
        name: 'onDragStart',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(initial: DragStart, provided: ResponderProvided) => void'
        }
      },
      onDragUpdate: {
        defaultValue: null,
        description: '',
        name: 'onDragUpdate',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: '(initial: DragUpdate, provided: ResponderProvided) => void'
        }
      },
      onDragEnd: {
        defaultValue: null,
        description: '',
        name: 'onDragEnd',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: true,
        type: {
          name: '(result: DropResult, provided: ResponderProvided) => void'
        }
      },
      sensors: {
        defaultValue: null,
        description: '',
        name: 'sensors',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DragDropContextProps'
        },
        required: false,
        type: {
          name: 'Sensor[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiDraggable.__docgenInfo = {
    description: '',
    displayName: 'EuiDraggable',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactElement<...> | ReactNodeArray | ReactPortal | DraggableChildrenFn'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      customDragHandle: {
        defaultValue: null,
        description: 'Whether the `children` will provide and set up its own drag handle',
        name: 'customDragHandle',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isRemovable: {
        defaultValue: null,
        description: 'Whether the item is currently in a position to be removed',
        name: 'isRemovable',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      spacing: {
        defaultValue: null,
        description: 'Adds padding to the draggable item',
        name: 'spacing',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      index: {
        defaultValue: null,
        description: '',
        name: 'index',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      draggableId: {
        defaultValue: null,
        description: '',
        name: 'draggableId',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isDragDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDragDisabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disableInteractiveElementBlocking: {
        defaultValue: null,
        description: '',
        name: 'disableInteractiveElementBlocking',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      shouldRespectForcePress: {
        defaultValue: null,
        description: '',
        name: 'shouldRespectForcePress',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiDroppable.__docgenInfo = {
    description: '',
    displayName: 'EuiDroppable',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement | ReactElement<...>[] | ((provided: DroppableProvided, snapshot: DroppableStateSnapshot) => ReactElement<...>)'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      cloneDraggables: {
        defaultValue: null,
        description: 'Makes its items immutable. Dragging creates cloned items that can be dropped elsewhere.',
        name: 'cloneDraggables',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      spacing: {
        defaultValue: null,
        description: 'Adds padding to the droppable area',
        name: 'spacing',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      withPanel: {
        defaultValue: null,
        description: 'Adds an EuiPanel style to the droppable area',
        name: 'withPanel',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      grow: {
        defaultValue: null,
        description: 'Allow the panel to flex-grow?',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      direction: {
        defaultValue: null,
        description: '',
        name: 'direction',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      mode: {
        defaultValue: null,
        description: '',
        name: 'mode',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'DroppableMode',
          value: [{
            value: '"standard"'
          }, {
            value: '"virtual"'
          }]
        }
      },
      droppableId: {
        defaultValue: null,
        description: '',
        name: 'droppableId',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isDropDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDropDisabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isCombineEnabled: {
        defaultValue: null,
        description: '',
        name: 'isCombineEnabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ignoreContainerClipping: {
        defaultValue: null,
        description: '',
        name: 'ignoreContainerClipping',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      renderClone: {
        defaultValue: null,
        description: '',
        name: 'renderClone',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'DraggableChildrenFn'
        }
      },
      getContainerForClone: {
        defaultValue: null,
        description: '',
        name: 'getContainerForClone',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: '() => ReactElement<HTMLElement, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)>'
        }
      }
    },
    extends: []
  };
} catch (e) {}